/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.skirnir.freyja.EvaluationRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.cms.pluggable.ClassTraverser;
import org.seasar.cms.pluggable.hotdeploy.LocalHotdeployS2Container;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.kvasir.util.StringUtils;
import org.seasar.kvasir.util.collection.MapProperties;
import org.seasar.kvasir.util.io.IOUtils;
import org.seasar.ymir.ActionNotFoundRuntimeException;
import org.seasar.ymir.Application;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.MatchedPathMapping;
import org.seasar.ymir.PageComponent;
import org.seasar.ymir.PageComponentVisitor;
import org.seasar.ymir.PathMapping;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.ResponseCreator;
import org.seasar.ymir.ResponseType;
import org.seasar.ymir.Ymir;
import org.seasar.ymir.annotation.Include;
import org.seasar.ymir.constraint.PermissionDeniedException;
import org.seasar.ymir.conversation.annotation.Begin;
import org.seasar.ymir.converter.TypeConversionManager;
import org.seasar.ymir.extension.creator.AnnotationDesc;
import org.seasar.ymir.extension.creator.BodyDesc;
import org.seasar.ymir.extension.creator.Born;
import org.seasar.ymir.extension.creator.ClassCreationHintBag;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassDescBag;
import org.seasar.ymir.extension.creator.ClassDescModifier;
import org.seasar.ymir.extension.creator.ClassDescSet;
import org.seasar.ymir.extension.creator.ClassHint;
import org.seasar.ymir.extension.creator.ClassType;
import org.seasar.ymir.extension.creator.Desc;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.DescValidator;
import org.seasar.ymir.extension.creator.EntityMetaData;
import org.seasar.ymir.extension.creator.InvalidClassDescException;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.MethodDescKey;
import org.seasar.ymir.extension.creator.ParameterDesc;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.PropertyTypeHint;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.SourceCreatorSetting;
import org.seasar.ymir.extension.creator.SourceGenerator;
import org.seasar.ymir.extension.creator.Template;
import org.seasar.ymir.extension.creator.TemplateAnalyzer;
import org.seasar.ymir.extension.creator.TemplateProvider;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.action.ActionSelector;
import org.seasar.ymir.extension.creator.action.Condition;
import org.seasar.ymir.extension.creator.action.State;
import org.seasar.ymir.extension.creator.action.UpdateAction;
import org.seasar.ymir.extension.creator.action.UpdateByExceptionAction;
import org.seasar.ymir.extension.creator.action.impl.ClassifyParametersAction;
import org.seasar.ymir.extension.creator.action.impl.CreateActionAction;
import org.seasar.ymir.extension.creator.action.impl.CreateClassAction;
import org.seasar.ymir.extension.creator.action.impl.CreateClassAndTemplateAction;
import org.seasar.ymir.extension.creator.action.impl.CreateConfigurationAction;
import org.seasar.ymir.extension.creator.action.impl.CreateMessageAction;
import org.seasar.ymir.extension.creator.action.impl.CreateMessagesAction;
import org.seasar.ymir.extension.creator.action.impl.CreateTemplateAction;
import org.seasar.ymir.extension.creator.action.impl.DoEditTemplateAction;
import org.seasar.ymir.extension.creator.action.impl.DoUpdateTemplateAction;
import org.seasar.ymir.extension.creator.action.impl.ResourceAction;
import org.seasar.ymir.extension.creator.action.impl.SystemConsoleAction;
import org.seasar.ymir.extension.creator.action.impl.UpdateClassesAction;
import org.seasar.ymir.extension.creator.impl.AnnotationDescImpl;
import org.seasar.ymir.extension.creator.impl.BodyDescImpl;
import org.seasar.ymir.extension.creator.impl.ClassDescImpl;
import org.seasar.ymir.extension.creator.impl.DefaultTemplateProvider;
import org.seasar.ymir.extension.creator.impl.ImportDescImpl;
import org.seasar.ymir.extension.creator.impl.LazyPathMetaData;
import org.seasar.ymir.extension.creator.impl.MetaAnnotationDescImpl;
import org.seasar.ymir.extension.creator.impl.MethodDescImpl;
import org.seasar.ymir.extension.creator.impl.ParameterDescImpl;
import org.seasar.ymir.extension.creator.impl.PropertyDescImpl;
import org.seasar.ymir.extension.creator.impl.ThrowsDescImpl;
import org.seasar.ymir.extension.creator.impl.TypeDescImpl;
import org.seasar.ymir.extension.creator.mapping.ActionSelectorSeed;
import org.seasar.ymir.extension.creator.mapping.ExtraPathMapping;
import org.seasar.ymir.extension.creator.mapping.PathMappingExtraData;
import org.seasar.ymir.extension.creator.mapping.impl.ActionSelectorSeedImpl;
import org.seasar.ymir.extension.creator.mapping.impl.ExtraPathMappingImpl;
import org.seasar.ymir.extension.creator.util.DescUtils;
import org.seasar.ymir.extension.creator.util.GenericsUtils;
import org.seasar.ymir.extension.creator.util.PersistentProperties;
import org.seasar.ymir.extension.creator.util.SourceCreatorUtils;
import org.seasar.ymir.extension.creator.util.type.TypeToken;
import org.seasar.ymir.extension.zpt.AnalyzerUtils;
import org.seasar.ymir.extension.zpt.ParameterRole;
import org.seasar.ymir.id.action.Action;
import org.seasar.ymir.impl.PageComponentImpl;
import org.seasar.ymir.impl.YmirImpl;
import org.seasar.ymir.message.MessageNotFoundRuntimeException;
import org.seasar.ymir.message.Messages;
import org.seasar.ymir.message.MessagesNotFoundRuntimeException;
import org.seasar.ymir.message.Notes;
import org.seasar.ymir.response.PassthroughResponse;
import org.seasar.ymir.scope.annotation.Inject;
import org.seasar.ymir.scope.annotation.RequestParameter;
import org.seasar.ymir.util.BeanUtils;
import org.seasar.ymir.util.ClassUtils;
import org.seasar.ymir.util.HTMLUtils;
import org.seasar.ymir.util.MetaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCreatorImpl
implements SourceCreator {
    private static final String PREFIX_ABSTRACT = "Abstract";
    private static final String MULTIPLE_SUFFIX = "ies";
    private static final String SINGULAR_SUFFIX = "y";
    private static final String MULTIPLE_SUFFIX2 = "s";
    private static final String SINGULAR_SUFFIX2 = "";
    private static final String PROPERTY_ID = "id";
    private static final String ID_ANNOTATIONNAME = "org.seasar.dao.annotation.tiger.Id";
    private static final String ID_BODY = "(org.seasar.dao.annotation.tiger.IdType.IDENTITY)";
    private static final Class<?> ID_TYPE = Integer.TYPE;
    private static final String PACKAGEPREFIX_JAVA_LANG = "java.lang.";
    private static final String PACKAGEPREFIX_JAVA_UTIL = "java.util.";
    private static final String RESOURCE_PREAMBLE_JAVA = "org/seasar/ymir/extension/Preamble.java.txt";
    private static final String PROP_LENGTH = "length";
    private static final String PROP_SIZE = "size";
    private static final Comparator<PropertyDesc> COMPARATOR_PROPERTYDESC_BY_NAME = new Comparator<PropertyDesc>(){

        @Override
        public int compare(PropertyDesc o1, PropertyDesc o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Comparator<MethodDesc> COMPARATOR_METHODDESC_BY_NAME = new Comparator<MethodDesc>(){

        @Override
        public int compare(MethodDesc o1, MethodDesc o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final String ACTIONMETHOD_FIELD_KEY = "KEY";
    private static final Map<HttpMethod, Class<? extends Action>> ACTIONINTERFACE_BY_HTTPMETHOD_MAP;
    private static final Comparator<? super Field> COMPARATOR_FIELD_BY_NAME;
    private YmirImpl ymir_;
    private NamingConvention namingConvention_;
    private TemplateAnalyzer analyzer_;
    private ClassDescModifier[] classDescModifiers_ = new ClassDescModifier[0];
    private String sourceEncoding_ = "UTF-8";
    private SourceGenerator sourceGenerator_;
    private ResponseCreator responseCreator_;
    public Properties sourceCreatorProperties_;
    private ApplicationManager applicationManager_;
    private TemplateProvider templateProvider_ = new DefaultTemplateProvider(this);
    private SourceCreatorSetting setting_ = new SourceCreatorSetting(this);
    private Map<Class<? extends PathMapping>, PathMappingExtraData<?>> pathMappingExtraDataMap_ = new HashMap();
    private ActionSelector<UpdateAction> byRequestingActionSelector_ = new ActionSelector<ClassifyParametersAction>().register(new Condition(State.TRUE, State.ANY, State.ANY, HttpMethod.GET), new ClassifyParametersAction(this)).register(new Condition(State.TRUE, State.ANY, State.ANY, HttpMethod.POST), new ClassifyParametersAction(this)).register("classifyParameters", new ClassifyParametersAction(this)).register("createConfiguration", (ClassifyParametersAction)((Object)new CreateConfigurationAction(this))).register("systemConsole", (ClassifyParametersAction)((Object)new SystemConsoleAction(this))).register("resource", (ClassifyParametersAction)((Object)new ResourceAction(this))).register("editTemplate.do", (ClassifyParametersAction)((Object)new DoEditTemplateAction(this))).register("updateTemplate.do", (ClassifyParametersAction)((Object)new DoUpdateTemplateAction(this)));
    private ActionSelector<UpdateAction> actionSelector_ = new ActionSelector<CreateTemplateAction>().register(new Condition(State.ANY, State.ANY, State.FALSE, HttpMethod.GET), new CreateTemplateAction(this)).register(new Condition(State.ANY, State.ANY, State.TRUE, HttpMethod.GET), (CreateTemplateAction)((Object)new UpdateClassesAction(this))).register(new Condition(State.ANY, State.FALSE, State.FALSE, HttpMethod.POST), (CreateTemplateAction)((Object)new CreateClassAndTemplateAction(this))).register(new Condition(State.ANY, State.ANY, State.TRUE, HttpMethod.POST), (CreateTemplateAction)((Object)new UpdateClassesAction(this))).register(new Condition(State.TRUE, State.TRUE, State.FALSE, HttpMethod.POST), new CreateTemplateAction(this)).register("createClass", (CreateTemplateAction)((Object)new CreateClassAction(this))).register("createTemplate", new CreateTemplateAction(this)).register("createClassAndTemplate", (CreateTemplateAction)((Object)new CreateClassAndTemplateAction(this))).register("updateClasses", (CreateTemplateAction)((Object)new UpdateClassesAction(this)));
    private ActionSelector<UpdateByExceptionAction> byExceptionActionSelector_ = new ActionSelector<CreateMessagesAction>().register(MessagesNotFoundRuntimeException.class, new CreateMessagesAction(this)).register("createMessages", new CreateMessagesAction(this)).register(MessageNotFoundRuntimeException.class, (CreateMessagesAction)((Object)new CreateMessageAction(this))).register("createMessage", (CreateMessagesAction)((Object)new CreateMessageAction(this))).register(ActionNotFoundRuntimeException.class, (CreateMessagesAction)((Object)new CreateActionAction(this))).register("createAction", (CreateMessagesAction)((Object)new CreateActionAction(this)));
    private boolean initialized_;
    private Log log_ = LogFactory.getLog(SourceCreatorImpl.class);

    @Binding(bindingType=BindingType.MUST)
    public void setTemplateAnalyzer(TemplateAnalyzer analyzer) {
        this.analyzer_ = analyzer;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention_ = namingConvention;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setYmir(Ymir ymir) {
        if (!(ymir instanceof YmirImpl)) {
            throw new ComponentNotFoundRuntimeException((Object)"YmirImpl");
        }
        this.ymir_ = (YmirImpl)ymir;
    }

    @Binding(value="@org.seasar.ymir.util.ContainerUtils@findAllComponents(container, @org.seasar.ymir.extension.creator.ClassDescModifier@class)", bindingType=BindingType.MUST)
    public void setClassDescModifiers(ClassDescModifier[] classDescModifiers) {
        this.classDescModifiers_ = classDescModifiers;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding_ = sourceEncoding;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setSourceGenerator(SourceGenerator sourceGenerator) {
        this.sourceGenerator_ = sourceGenerator;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setResponseCreator(ResponseCreator responseCreator) {
        this.responseCreator_ = responseCreator;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(value="@org.seasar.ymir.util.ContainerUtils@findAllComponents(container, @org.seasar.ymir.extension.creator.mapping.PathMappingExtraData@class)", bindingType=BindingType.MUST)
    public void setPathMappingExtraDatas(PathMappingExtraData<?>[] pathMappingExtraDatas) {
        for (int i = 0; i < pathMappingExtraDatas.length; ++i) {
            this.pathMappingExtraDataMap_.put(pathMappingExtraDatas[i].getPathMappingClass(), pathMappingExtraDatas[i]);
        }
    }

    public Response updateByRequesting(Request request) {
        return this.update(request, null, this.byRequestingActionSelector_, false);
    }

    public Response update(Request request, Response response) {
        return this.update(request, response, this.actionSelector_, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response update(Request request, Response response, ActionSelector<UpdateAction> actionSelector, boolean processEvenIfAnotherTaskSpecified) {
        Response newResponse;
        SourceCreatorImpl sourceCreatorImpl = this;
        synchronized (sourceCreatorImpl) {
            if (!this.initialized_) {
                this.setProjectRootIfNotDetecetd(this.getApplication());
                this.initialized_ = true;
            }
        }
        if (!this.shouldUpdate()) {
            return response;
        }
        LazyPathMetaData pathMetaData = this.createLazyPathMetaData(request, response);
        String path = pathMetaData.getPath();
        String forwardPath = pathMetaData.getForwardPath();
        HttpMethod method = pathMetaData.getMethod();
        if (!(request.getParameter("__ymir__task") != null || this.shouldUpdate(path) && this.shouldUpdate(forwardPath))) {
            return response;
        }
        Object condition = null;
        boolean taskSpecified = false;
        if (request.getParameter("__ymir__task") != null) {
            condition = request.getParameter("__ymir__task");
            taskSpecified = true;
        } else if (path.startsWith("/__ymir__/")) {
            int slash = path.indexOf(47, "/__ymir__/".length());
            condition = slash >= 0 ? path.substring("/__ymir__/".length(), slash) : path.substring("/__ymir__/".length());
        } else {
            if (request.getCurrentDispatch().isIgnored()) {
                return response;
            }
            if (response != null && response.getType() != ResponseType.PASSTHROUGH && response.getType() != ResponseType.FORWARD) {
                return response;
            }
        }
        if (condition == null) {
            if (!this.isAlreadyConfigured(this.getApplication())) {
                condition = "createConfiguration";
            } else {
                String className = pathMetaData.getClassName();
                File sourceFile = pathMetaData.getSourceFile();
                Template template = pathMetaData.getTemplate();
                if (SINGULAR_SUFFIX2.equals(forwardPath)) {
                    if (className == null || sourceFile.exists()) {
                        return response;
                    }
                    condition = "createClass";
                } else {
                    condition = new Condition(State.valueOf(className != null), State.valueOf(sourceFile.exists()), State.valueOf(template != null && template.exists()), method);
                }
            }
        }
        UpdateAction action = null;
        if (taskSpecified && processEvenIfAnotherTaskSpecified) {
            UpdateByExceptionAction byExceptionAction;
            action = this.byRequestingActionSelector_.getAction(condition);
            if (action == null && (action = this.actionSelector_.getAction(condition)) == null && (byExceptionAction = this.byExceptionActionSelector_.getAction(condition)) != null) {
                Response newResponse2 = byExceptionAction.act(request, pathMetaData, null);
                if (newResponse2 != null) {
                    response = newResponse2;
                }
                return response;
            }
        } else {
            action = actionSelector.getAction(condition);
        }
        if (action != null && (newResponse = action.act(request, pathMetaData)) != null) {
            response = newResponse;
        }
        return response;
    }

    void setProjectRootIfNotDetecetd(Application application) {
        if (application.getProjectRoot() != null && new File(application.getProjectRoot()).exists()) {
            return;
        }
        String projectRoot = SourceCreatorUtils.findProjectRootDirectory(application);
        if (projectRoot != null) {
            application.setProjectRoot(projectRoot);
            this.log_.info((Object)("Project root has been detected and set automatically: " + projectRoot));
        }
    }

    LazyPathMetaData createLazyPathMetaData(Request request, Response response) {
        String path = request.getCurrentDispatch().getPath();
        String forwardPath = null;
        if (response != null) {
            if (response.getType() == ResponseType.FORWARD) {
                forwardPath = response.getPath();
            } else if (response.getType() == ResponseType.PASSTHROUGH) {
                forwardPath = path;
            }
        }
        return new LazyPathMetaData(this, path, this.getOriginalMethod(request), forwardPath);
    }

    public Response updateByException(Request request, Throwable t) {
        Class<?> condition;
        UpdateByExceptionAction action;
        if (!this.shouldUpdate() || !this.shouldUpdate(this.getRequest().getCurrentDispatch().getPath())) {
            return null;
        }
        if (t instanceof EvaluationRuntimeException && t.getCause() != null) {
            t = t.getCause();
        }
        if ((action = this.byExceptionActionSelector_.getAction(condition = t.getClass())) == null) {
            return null;
        }
        return action.act(request, this.createLazyPathMetaData(request, null), t);
    }

    HttpMethod getOriginalMethod(Request request) {
        String originalMethod = request.getParameter("__ymir__method");
        if (originalMethod != null) {
            return HttpMethod.enumOf((String)originalMethod);
        }
        return request.getMethod();
    }

    public boolean shouldUpdate() {
        return this.setting_.isSourceCreatorEnabled();
    }

    @Override
    public boolean shouldUpdate(String path) {
        return path == null || this.setting_.isSourceCreatorEnabledWith(path);
    }

    boolean isAlreadyConfigured(Application application) {
        String projectRoot;
        String projectRootFromProperties = SourceCreatorUtils.getProjectRootFromLocalProperties(application);
        if (projectRootFromProperties == null) {
            projectRootFromProperties = SourceCreatorUtils.getProjectRootFromProperties(application);
        }
        return (projectRoot = application.getProjectRoot()) != null && (projectRootFromProperties == null || projectRootFromProperties.equals(projectRoot)) && application.getFirstRootPackageName() != null;
    }

    @Override
    public ClassDescBag gatherClassDescs(DescPool pool, Notes warnings, boolean analyzeTemplate, PathMetaData ... pathMetaDatas) {
        return this.gatherClassDescs(pool, warnings, analyzeTemplate, (String[])null, pathMetaDatas);
    }

    @Override
    public ClassDescBag gatherClassDescs(DescPool pool, Notes warnings, boolean analyzeTemplate, String[] ignoreVariables, PathMetaData ... pathMetaDatas) {
        for (int i = 0; i < pathMetaDatas.length; ++i) {
            this.gatherClassDescs(pool, warnings, analyzeTemplate, ignoreVariables, pathMetaDatas[i]);
        }
        ClassDesc[] classDescs = this.addRelativeClassDescs(pool.getGeneratedClassDescs().toArray(new ClassDesc[0]), pool.getHintBag());
        return this.newClassDescBag(classDescs);
    }

    @Override
    public void updateClasses(ClassDescBag classDescBag) {
        if (this.setting_.isConverterCreationFeatureEnabled()) {
            for (ClassDesc dtoCd : classDescBag.getClassDescs(ClassType.DTO)) {
                String[] pairTypeNames = this.getPairTypeNames(dtoCd);
                if (pairTypeNames == null) continue;
                ClassDesc converterCd = this.createConverterClassDesc(dtoCd, pairTypeNames);
                if (this.getClass(converterCd.getName()) == null) {
                    classDescBag.addAsCreated(converterCd);
                    continue;
                }
                classDescBag.addAsUpdated(converterCd);
            }
        }
        ClassDescSet classDescSet = classDescBag.getClassDescSet();
        ClassDesc[] pageClassDescs = classDescBag.getClassDescs(ClassType.PAGE);
        for (int i = 0; i < pageClassDescs.length; ++i) {
            this.addConverterSetterToPageClassDesc(pageClassDescs[i], classDescSet);
        }
        this.updateClasses0(classDescBag);
    }

    void writeBaseSourceFileIfNotExist(ClassDescBag classDescBag) {
        ArrayList<ClassDesc> newClassDescList;
        ArrayList<ClassDesc> classDescList = new ArrayList<ClassDesc>(Arrays.asList(classDescBag.getClassDescs()));
        do {
            newClassDescList = new ArrayList<ClassDesc>();
            for (ClassDesc classDesc : classDescList) {
                ClassDesc superClassDesc;
                Class<?> superclass;
                String superclassName = classDesc.getSuperclassName();
                if (superclassName == null || (superclass = this.getClass(superclassName)) != null || this.isOuter(superClassDesc = this.newClassDesc(classDesc.getDescPool(), superclassName, null))) continue;
                this.prepareForUpdating(superClassDesc);
                this.writeEmptyBaseSourceFileIfNotExists(superClassDesc);
                classDescBag.addAsCreated(superClassDesc, true);
                newClassDescList.add(superClassDesc);
            }
        } while (!(classDescList = newClassDescList).isEmpty());
    }

    void addConverterSetterToPageClassDesc(ClassDesc pageClassDesc, ClassDescSet classDescSet) {
        this.addConverterSetterToPageClassDesc(pageClassDesc, pageClassDesc, classDescSet, new HashSet<String>());
    }

    void addConverterSetterToPageClassDesc(ClassDesc pageClassDesc, ClassDesc dtoClassDesc, ClassDescSet classDescSet, Set<String> processedClassNameSet) {
        for (PropertyDesc pd : dtoClassDesc.getPropertyDescs()) {
            TypeDesc td = pd.getTypeDesc();
            ClassDesc dtoCd = td.getComponentClassDesc();
            if (!processedClassNameSet.add(dtoCd.getName()) || !DescValidator.validate(td, classDescSet).isValid() || dtoCd.getType() != ClassType.DTO) continue;
            EntityMetaData metaData = new EntityMetaData(pageClassDesc.getDescPool(), dtoCd.getName());
            TypeDesc typeDesc = pageClassDesc.getDescPool().newTypeDesc(metaData.getConverterClassDesc());
            PropertyDesc propertyDesc = pageClassDesc.getPropertyDesc(typeDesc.getInstanceName());
            if (propertyDesc != null && propertyDesc.isWritable()) continue;
            this.addComponentSetterToPageIfValid(pageClassDesc, typeDesc, classDescSet);
            this.addConverterSetterToPageClassDesc(pageClassDesc, dtoCd, classDescSet, processedClassNameSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassDesc createConverterClassDesc(ClassDesc dtoCd, String[] pairTypeNames) {
        DescPool pool = dtoCd.getDescPool();
        String oldBornOf = pool.getBornOf();
        try {
            pool.setBornOf(dtoCd.getBornOf());
            ClassDesc converterCd = new EntityMetaData(pool, dtoCd.getName()).getConverterClassDesc();
            Map<String, Object> parameter = converterCd.getSourceGeneratorParameter();
            ClassDesc clonedDtoCd = dtoCd.transcriptTo(DescPool.newInstance(this, null).getClassDesc(dtoCd.getName()));
            this.mergeWithExistentClass(clonedDtoCd);
            parameter.put("targetClassDesc", clonedDtoCd);
            this.addToAuxDescList(converterCd, clonedDtoCd);
            ArrayList<TypeDesc> pairTdList = new ArrayList<TypeDesc>();
            for (int i = 0; i < pairTypeNames.length; ++i) {
                Class<?> pairClass = this.getClass(GenericsUtils.getNonGenericClassName(pairTypeNames[i]));
                if (pairClass == null || pairClass == Object.class) continue;
                pool.registerClassDesc(this.newClassDesc(pool, pairClass, false));
                pairTdList.add(pool.newTypeDesc(pairTypeNames[i]));
            }
            TypeDesc[] pairTds = pairTdList.toArray(new TypeDesc[0]);
            parameter.put("pairTypeDescs", pairTds);
            this.addToAuxDescList(converterCd, pairTds);
            ClassDesc classDesc = converterCd;
            return classDesc;
        }
        finally {
            pool.setBornOf(oldBornOf);
        }
    }

    private void addToAuxDescList(ClassDesc classDesc, Desc<?> ... descs) {
        Map<String, Object> parameter = classDesc.getSourceGeneratorParameter();
        ArrayList list = (ArrayList)parameter.get("auxDescList");
        if (list == null) {
            list = new ArrayList();
            parameter.put("auxDescList", list);
        }
        list.addAll(Arrays.asList(descs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gatherClassDescs(DescPool pool, Notes warnings, boolean analyzeTemplate, String[] ignoreVariables, PathMetaData pathMetaData) {
        String path = pathMetaData.getPath();
        String oldBornOf = pool.getBornOf();
        try {
            MethodDescImpl methodDesc;
            if (analyzeTemplate) {
                pool.setBornOf(path);
            }
            HttpMethod method = pathMetaData.getMethod();
            String pageClassName = pathMetaData.getClassName();
            if (analyzeTemplate) {
                this.analyzer_.analyze(this.getServletContext(), this.getHttpServletRequest(), this.getHttpServletResponse(), this.getRequest(), path, method, pathMetaData.getTemplate(), pageClassName, ignoreVariables, pool, warnings);
            } else {
                this.finishAnalyzing(pool);
            }
            for (int i = 0; i < this.classDescModifiers_.length; ++i) {
                this.classDescModifiers_[i].modify(pool, pathMetaData);
            }
            ClassDesc pageClassDesc = pool.getClassDesc(pageClassName);
            if (analyzeTemplate) {
                MethodDesc actionMethodDesc = this.newActionMethodDesc(pool, path, HttpMethod.GET, new ActionSelectorSeedImpl());
                if (pageClassDesc.getMethodDesc(actionMethodDesc) == null) {
                    pageClassDesc.setMethodDesc(actionMethodDesc);
                }
                MethodDesc prerenderMethodDesc = this.newPrerenderActionMethodDesc(pool, path, method, new ActionSelectorSeedImpl());
                pageClassDesc.setMethodDesc(prerenderMethodDesc);
            }
            if (this.isValidationFailedMethodEnabled()) {
                methodDesc = new MethodDescImpl(pageClassDesc.getDescPool(), "_validationFailed");
                methodDesc.setParameterDescs(new ParameterDescImpl(pageClassDesc.getDescPool(), (Type)((Object)Notes.class), "notes"));
                pageClassDesc.setMethodDesc(methodDesc);
            }
            if (this.isPermissionDeniedMethodEnabled()) {
                methodDesc = new MethodDescImpl(pageClassDesc.getDescPool(), "_permissionDenied");
                methodDesc.setParameterDescs(new ParameterDescImpl(pageClassDesc.getDescPool(), (Type)((Object)PermissionDeniedException.class), "ex"));
                methodDesc.setThrowsDesc(new ThrowsDescImpl(PermissionDeniedException.class));
                methodDesc.setBodyDesc(new BodyDescImpl("_permissionDenied", new HashMap<String, Object>(), new String[0]));
                pageClassDesc.setMethodDesc(methodDesc);
            }
        }
        finally {
            pool.setBornOf(oldBornOf);
        }
    }

    @Override
    public void finishAnalyzing(DescPool pool) {
        Iterator<ClassDesc> itr = pool.iterator();
        while (itr.hasNext()) {
            ClassHint hint;
            ClassDesc classDesc = itr.next();
            if (this.isEmptyDto(classDesc) && !this.isFormDto(classDesc)) {
                itr.remove();
                continue;
            }
            ClassCreationHintBag hintBag = pool.getHintBag();
            if (hintBag == null || (hint = hintBag.getClassHint(classDesc.getName())) == null) continue;
            classDesc.setSuperclassName(hint.getSuperclassName());
        }
        for (ClassDesc classDesc : pool.getGeneratedClassDescs()) {
            for (PropertyDesc pd : classDesc.getPropertyDescs()) {
                if (pd.isTypeAlreadySet(Integer.MAX_VALUE)) continue;
                this.replaceSimpleDtoTypeToDefaultType(pd);
            }
        }
    }

    private boolean isEmptyDto(ClassDesc classDesc) {
        return this.isTypeOf(classDesc, ClassType.DTO) && classDesc.isEmpty();
    }

    private boolean isTypeOf(ClassDesc classDesc, ClassType type) {
        return classDesc.isTypeOf(type) && !this.isOuter(classDesc);
    }

    private boolean isFormDto(ClassDesc classDesc) {
        Boolean formDto = (Boolean)classDesc.getAttribute("formDto");
        return formDto != null && formDto != false;
    }

    private boolean isDto(ClassDesc classDesc) {
        return this.isTypeOf(classDesc, ClassType.DTO);
    }

    void replaceSimpleDtoTypeToDefaultType(PropertyDesc propertyDesc) {
        TypeDesc typeDesc = propertyDesc.getTypeDesc();
        if (this.isDto(typeDesc.getComponentClassDesc()) && !propertyDesc.getDescPool().contains(typeDesc.getComponentClassDesc())) {
            typeDesc.setComponentClassDesc(propertyDesc.isMayBoolean() && propertyDesc.getReferCount() == 0 ? Boolean.TYPE : String.class);
        }
    }

    @Begin
    Begin getBeginAnnotation() {
        try {
            return SourceCreatorImpl.class.getDeclaredMethod("getBeginAnnotation", new Class[0]).getAnnotation(Begin.class);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Logic error!", ex);
        }
    }

    ClassDescBag newClassDescBag(ClassDesc[] classDescs) {
        ClassDescBag classDescBag = new ClassDescBag();
        for (int i = 0; i < classDescs.length; ++i) {
            if (this.getClass(classDescs[i].getName()) == null) {
                classDescBag.addAsCreated(classDescs[i]);
                continue;
            }
            classDescBag.addAsUpdated(classDescs[i]);
        }
        return classDescBag;
    }

    @Override
    public ClassDesc newClassDesc(DescPool pool, Class<?> clazz, boolean onlyDeclared) {
        return this.newClassDesc(pool, clazz, null, onlyDeclared);
    }

    @Override
    public ClassDesc newClassDesc(DescPool pool, Class<?> clazz, String qualifier, boolean onlyDeclared) {
        if (clazz == null) {
            return null;
        }
        ClassDesc classDesc = this.newClassDesc(pool, clazz.getName(), qualifier, null);
        AnnotationDesc[] ads = DescUtils.newAnnotationDescs(clazz);
        for (int i = 0; i < ads.length; ++i) {
            classDesc.setAnnotationDesc(ads[i]);
        }
        for (PropertyDescriptor descriptor : this.getPropertyDescriptors(clazz, onlyDeclared)) {
            classDesc.setPropertyDesc(new PropertyDescImpl(pool, descriptor));
        }
        for (Method method : this.getMethods(clazz, onlyDeclared)) {
            Class<?> actionMethodClass;
            MethodDescImpl md = new MethodDescImpl(pool, method);
            classDesc.setMethodDesc(md);
            String[] source = md.getMetaValue("source");
            if (source != null) {
                ArrayList<String> classNameList = new ArrayList<String>();
                for (Class<?> cl : md.getMetaClassValue("source")) {
                    classNameList.add(cl.getName());
                }
                int idx = 0;
                md.setBodyDesc(new BodyDescImpl(source[idx++], classNameList.toArray(new String[0])));
                ParameterDesc[] parameterDescs = md.getParameterDescs();
                for (int i = 0; idx < source.length && i < parameterDescs.length; ++idx, ++i) {
                    parameterDescs[i].setName(source[idx]);
                }
            }
            if ((actionMethodClass = this.getClass(clazz.getName() + "$" + method.getName())) == null) continue;
            boolean action = true;
            String actionKey = null;
            try {
                actionKey = (String)actionMethodClass.getField(ACTIONMETHOD_FIELD_KEY).get(null);
            }
            catch (Throwable t) {
                if (this.log_.isDebugEnabled()) {
                    this.log_.debug((Object)("Cannot get field 'KEY' value of class '" + actionMethodClass + "'"), t);
                }
                action = false;
            }
            if (!action) continue;
            Class<?> actionInterface = actionMethodClass.getInterfaces()[0];
            this.setActionInfo(md, actionInterface, actionKey);
        }
        Field[] fields = clazz.getDeclaredFields();
        Arrays.sort(fields, COMPARATOR_FIELD_BY_NAME);
        for (Field field : fields) {
            PropertyDesc propertyDesc;
            String name;
            if (MetaUtils.hasMeta((AnnotatedElement)field, (String)"property")) {
                String propertyName = MetaUtils.getFirstValue((AnnotatedElement)field, (String)"property");
                PropertyDesc pd = classDesc.getPropertyDesc(propertyName);
                if (pd == null) {
                    pd = classDesc.addPropertyDesc(propertyName, 0);
                }
                pd.setTypeDesc(field.getGenericType());
                for (Annotation annotation : field.getAnnotations()) {
                    pd.setAnnotationDesc(DescUtils.newAnnotationDesc(annotation));
                }
            }
            if (!(name = field.getName()).startsWith("P_")) continue;
            String propertyName = name.substring("P_".length());
            int delim = propertyName.indexOf("$");
            if (delim >= 0) {
                propertyName = propertyName.substring(0, delim);
            }
            if ((propertyDesc = classDesc.getPropertyDesc(propertyName)) == null || propertyDesc.getAnnotationDescOnGetter(RequestParameter.class.getName()) == null && propertyDesc.getAnnotationDescOnSetter(RequestParameter.class.getName()) == null) continue;
            try {
                DescUtils.addParameter(propertyDesc, (String)field.get(null), MetaUtils.getValue((AnnotatedElement)field, (String)"bornOf"));
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("May logic error", ex);
            }
            catch (IllegalAccessException ignore) {
            }
            catch (ClassCastException ignore) {
                // empty catch block
            }
        }
        return classDesc;
    }

    public void setActionInfo(MethodDesc methodDesc, Class<? extends Action> actionInterface, String actionKey) {
        methodDesc.setAttribute("action", Boolean.TRUE);
        methodDesc.setAttribute("action.interface", actionInterface);
        methodDesc.setAttribute("action.key", actionKey);
    }

    Method[] getMethods(Class<?> clazz, boolean onlyDeclared) {
        HashSet<Method> excludeMethodSet = new HashSet<Method>();
        for (PropertyDescriptor descriptor : this.getPropertyDescriptors(clazz, onlyDeclared)) {
            Method method = descriptor.getReadMethod();
            if (method != null) {
                excludeMethodSet.add(method);
            }
            if ((method = descriptor.getWriteMethod()) == null) continue;
            excludeMethodSet.add(method);
        }
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : ClassUtils.getMethods(clazz)) {
            if (onlyDeclared && method.getDeclaringClass() != clazz || this.getOriginalDeclaringClass(method) == Object.class || excludeMethodSet.contains(method)) continue;
            list.add(method);
        }
        Collections.sort(list, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                Type[] types2;
                int cmp = o1.getName().compareTo(o2.getName());
                if (cmp != 0) {
                    return cmp;
                }
                Type[] types1 = o1.getGenericParameterTypes();
                cmp = types1.length - (types2 = o2.getGenericParameterTypes()).length;
                if (cmp != 0) {
                    return cmp;
                }
                for (int i = 0; i < types1.length; ++i) {
                    cmp = types1[i].toString().compareTo(types2[i].toString());
                    if (cmp == 0) continue;
                    return cmp;
                }
                return 0;
            }
        });
        return list.toArray(new Method[0]);
    }

    private Class<?> getOriginalDeclaringClass(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        Class<?> superclass;
        while ((superclass = clazz.getSuperclass()) != null) {
            try {
                superclass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (SecurityException ignore) {
            }
            catch (NoSuchMethodException ex) {
                return clazz;
            }
            clazz = superclass;
        }
        return clazz;
    }

    private PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz, boolean onlyDeclared) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException(ex);
        }
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            Method readMethod = descriptor.getReadMethod();
            Method writeMethod = descriptor.getWriteMethod();
            if (readMethod != null && readMethod.getDeclaringClass() == Object.class || writeMethod != null && writeMethod.getDeclaringClass() == Object.class) continue;
            if (onlyDeclared) {
                if (readMethod != null && readMethod.getDeclaringClass() != clazz) {
                    readMethod = null;
                }
                if (writeMethod != null && writeMethod.getDeclaringClass() != clazz) {
                    writeMethod = null;
                }
            }
            if (readMethod == null && writeMethod == null) continue;
            try {
                list.add(new PropertyDescriptor(this.getPropertyName(descriptor), readMethod, writeMethod));
            }
            catch (IntrospectionException ex) {
                throw new RuntimeException("Can't happen!", ex);
            }
        }
        Collections.sort(list, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor o1, PropertyDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return list.toArray(new PropertyDescriptor[0]);
    }

    private String getPropertyName(PropertyDescriptor descriptor) {
        String name = descriptor.getName();
        if (this.findField(descriptor.getReadMethod(), name) == null && this.findField(descriptor.getWriteMethod(), name) == null && name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            String n = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            if (this.findField(descriptor.getReadMethod(), n) != null || this.findField(descriptor.getWriteMethod(), n) != null) {
                return n;
            }
        }
        return name;
    }

    @Override
    public Field findField(Method accessorMethod, String propertyName) {
        Field field = null;
        if (accessorMethod != null) {
            String formName = MetaUtils.getFirstValue((AnnotatedElement)accessorMethod, (String)"formProperty");
            if (formName != null) {
                Field formField = this.findField(formName, accessorMethod.getDeclaringClass());
                if (formField != null) {
                    field = this.findField(propertyName, formField.getType());
                }
            } else {
                field = this.findField(propertyName, accessorMethod.getDeclaringClass());
            }
        }
        return field;
    }

    private Field findField(String propertyName, Class<?> clazz) {
        Field field = null;
        if (clazz != null && (field = DescUtils.findField(this.setting_.getFieldName(propertyName), clazz)) == null) {
            field = DescUtils.findField(propertyName, clazz);
        }
        return field;
    }

    String quote(String value) {
        if (value == null) {
            return "null";
        }
        return StringUtils.quoteString((String)value, (char)'\"');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassDesc[] addRelativeClassDescs(ClassDesc[] classDescs, ClassCreationHintBag hintBag) {
        List list;
        HashMap<String, ArrayList<ClassDesc>> pageByDtoMap = new HashMap<String, ArrayList<ClassDesc>>();
        for (ClassDesc classDesc : classDescs) {
            if (!classDesc.isTypeOf(ClassType.PAGE)) continue;
            for (PropertyDesc propertyDesc : classDesc.getPropertyDescs()) {
                ClassDesc cd = propertyDesc.getTypeDesc().getComponentClassDesc();
                if (!cd.isTypeOf(ClassType.DTO)) continue;
                list = (ArrayList<ClassDesc>)pageByDtoMap.get(cd.getName());
                if (list == null) {
                    list = new ArrayList<ClassDesc>();
                    pageByDtoMap.put(cd.getName(), (ArrayList<ClassDesc>)list);
                }
                list.add(classDesc);
            }
        }
        ArrayList<ClassDesc> classDescList = new ArrayList<ClassDesc>(Arrays.asList(classDescs));
        for (ClassDesc classDesc : classDescs) {
            DescPool pool = classDesc.getDescPool();
            String oldBornOf = pool.getBornOf();
            try {
                pool.setBornOf(classDesc.getBornOf());
                if (!classDesc.isTypeOf(ClassType.DTO)) continue;
                EntityMetaData metaData = new EntityMetaData(pool, classDesc.getName());
                if (this.setting_.isDaoCreationFeatureEnabled()) {
                    ClassDesc daoClassDesc = metaData.getDaoClassDesc();
                    classDescList.add(daoClassDesc);
                    ClassDesc beanClassDesc = metaData.getBeanClassDesc();
                    PropertyDesc[] pds = classDesc.getPropertyDescs();
                    for (int j = 0; j < pds.length; ++j) {
                        beanClassDesc.setPropertyDesc(pds[j].transcriptTo(pool.newPropertyDesc(pds[j].getName())));
                    }
                    PropertyDesc idPd = beanClassDesc.getPropertyDesc(PROPERTY_ID);
                    if (idPd == null) {
                        idPd = beanClassDesc.addPropertyDesc(PROPERTY_ID, 3);
                        idPd.setTypeDesc(ID_TYPE);
                    }
                    idPd.setAnnotationDescOnGetter(new AnnotationDescImpl(ID_ANNOTATIONNAME, ID_BODY));
                    classDescList.add(beanClassDesc);
                }
                if (!this.setting_.isDxoCreationFeatureEnabled()) continue;
                ClassDesc dxoClassDesc = metaData.getDxoClassDesc();
                list = (List)pageByDtoMap.get(classDesc.getName());
                if (list != null) {
                    Iterator itr = list.iterator();
                    while (itr.hasNext()) {
                        MethodDescImpl md = new MethodDescImpl(pool, "convert");
                        ParameterDesc[] pmds = new ParameterDesc[]{new ParameterDescImpl(pool, new TypeDescImpl(pool, (ClassDesc)itr.next()))};
                        md.setParameterDescs(pmds);
                        md.setReturnTypeDesc(pool.newTypeDesc(metaData.getBeanClassDesc().getName()));
                        dxoClassDesc.setMethodDesc(md);
                    }
                }
                classDescList.add(dxoClassDesc);
            }
            finally {
                pool.setBornOf(oldBornOf);
            }
        }
        return classDescList.toArray(new ClassDesc[0]);
    }

    String[] getPairTypeNames(ClassDesc classDesc) {
        String[] pairTypeNames = classDesc.getMetaValue("conversion");
        if (pairTypeNames == null) {
            pairTypeNames = MetaUtils.getValue(this.getClass(classDesc.getName() + "Base"), (String)"conversion");
        }
        return pairTypeNames;
    }

    boolean addComponentSetterToPageIfValid(ClassDesc pageClassDesc, TypeDesc typeDesc, ClassDescSet classDescSet) {
        if (DescValidator.validate(typeDesc, classDescSet).isValid()) {
            PropertyDesc propertyDesc = pageClassDesc.addPropertyDesc(typeDesc.getInstanceName(), 2);
            propertyDesc.setTypeDesc(typeDesc);
            propertyDesc.setAnnotationDescOnSetter(new AnnotationDescImpl(Inject.class.getName()));
            return true;
        }
        return false;
    }

    private void updateClasses0(ClassDescBag classDescBag) {
        this.writeBaseSourceFileIfNotExist(classDescBag);
        for (ClassType type : ClassType.values()) {
            ClassDesc[] classDescs = classDescBag.getClassDescs(type);
            ClassDescSet classDescSet = classDescBag.getClassDescSet();
            for (int i = 0; i < classDescs.length; ++i) {
                try {
                    this.updateClass(classDescs[i], classDescSet);
                    continue;
                }
                catch (InvalidClassDescException ex) {
                    classDescBag.remove(classDescs[i].getName());
                    classDescBag.addAsFailed(classDescs[i], ex.getLackingClassNames());
                }
            }
        }
    }

    @Override
    public void updateClass(ClassDesc classDesc) throws InvalidClassDescException {
        this.writeBaseSourceFileIfNotExist(this.newClassDescBag(new ClassDesc[]{classDesc}));
        this.updateClass(classDesc, null);
    }

    void updateClass(ClassDesc classDesc, ClassDescSet classDescSet) throws InvalidClassDescException {
        this.adjustByExistentClass(classDesc);
        if (this.setting_.shouldSortElementsByName()) {
            this.sortElementsByName(classDesc);
        }
        this.prepareForAttribute(classDesc);
        this.prepareForUpdating(classDesc);
        this.writeSourceFile(classDesc, classDescSet);
    }

    @Override
    public void prepareForUpdating(ClassDesc classDesc) {
        this.prepareForWriting(classDesc);
        this.prepareForMethodBody(classDesc);
        this.prepareForImportDesc(classDesc);
    }

    private void sortElementsByName(ClassDesc classDesc) {
        PropertyDesc[] propertyDescs = classDesc.getPropertyDescs();
        Arrays.sort(propertyDescs, COMPARATOR_PROPERTYDESC_BY_NAME);
        for (PropertyDesc propertyDesc : propertyDescs) {
            Object[] parameters = (Born[])propertyDesc.getAttribute("parameters");
            if (parameters == null) continue;
            Arrays.sort(parameters);
        }
        classDesc.setPropertyDescs(propertyDescs);
        MethodDesc[] methodDescs = classDesc.getMethodDescs();
        Arrays.sort(methodDescs, COMPARATOR_METHODDESC_BY_NAME);
        classDesc.setMethodDescs(methodDescs);
    }

    private void prepareForMethodBody(ClassDesc classDesc) {
        MethodDesc[] mds = classDesc.getMethodDescs();
        for (int i = 0; i < mds.length; ++i) {
            BodyDesc bodyDesc = mds[i].getBodyDesc();
            String evaluatedBody = this.sourceGenerator_.generateBodySource(bodyDesc);
            mds[i].setAttribute("evaluatedBody", evaluatedBody);
            boolean shouldRemainSourceMeta = false;
            if (evaluatedBody != null && evaluatedBody.length() > 0) {
                shouldRemainSourceMeta = true;
            } else {
                for (ParameterDesc pd : mds[i].getParameterDescs()) {
                    if (pd.getNameAsIs() == null) continue;
                    shouldRemainSourceMeta = true;
                    break;
                }
            }
            if (!shouldRemainSourceMeta) continue;
            ArrayList<String> list = new ArrayList<String>();
            list.add(evaluatedBody != null ? evaluatedBody : SINGULAR_SUFFIX2);
            for (ParameterDesc pd : mds[i].getParameterDescs()) {
                list.add(pd.getName());
            }
            Class[] dependingClasses = bodyDesc != null ? this.toClasses(bodyDesc.getDependingClassNames()) : new Class[]{};
            mds[i].setAnnotationDesc(new MetaAnnotationDescImpl("source", list.toArray(new String[0]), dependingClasses));
        }
    }

    private Class<?>[] toClasses(String[] classNames) {
        ArrayList list = new ArrayList();
        for (String className : classNames) {
            Class<?> clazz = this.getClass(className);
            if (clazz == null) continue;
            list.add(clazz);
        }
        return list.toArray(new Class[0]);
    }

    private void prepareForImportDesc(ClassDesc classDesc) {
        Map<String, Object> parameter = classDesc.getSourceGeneratorParameter();
        EntityMetaData entityMetaData = new EntityMetaData(classDesc.getDescPool(), classDesc.getName());
        HashSet<String> importClassNameSet = new HashSet<String>();
        HashSet<String> baseImportClassNameSet = new HashSet<String>();
        if (classDesc.getSuperclassName() != null) {
            String baseClassShortName = classDesc.getShortName();
            if (!baseClassShortName.endsWith("Base")) {
                baseClassShortName = baseClassShortName + "Base";
            }
            if (!(classDesc.getSuperclassShortName().equals(baseClassShortName) || ClassUtils.getPackageName((String)classDesc.getSuperclassName()).equals(classDesc.getPackageName()) || ClassUtils.isJavaLang((String)classDesc.getSuperclassName()))) {
                baseImportClassNameSet.add(classDesc.getSuperclassName());
            }
        }
        switch (classDesc.getType()) {
            case BEAN: {
                importClassNameSet.add("org.seasar.ymir.beantable.annotation.Managed");
                break;
            }
            case PAGE: {
                for (MethodDesc md : classDesc.getMethodDescs()) {
                    BodyDesc bodyDesc;
                    if (this.isAction(md)) {
                        Class actionInterface = (Class)md.getAttribute("action.interface");
                        baseImportClassNameSet.add(actionInterface.getName());
                        md.setAttribute("action.interface.shortName", ClassUtils.getShortName((Class)actionInterface));
                    }
                    if ((bodyDesc = md.getBodyDesc()) == null) continue;
                    baseImportClassNameSet.addAll(Arrays.asList(bodyDesc.getDependingClassNames()));
                }
                break;
            }
            case DTO: {
                importClassNameSet.add(Serializable.class.getName());
                baseImportClassNameSet.add(Serializable.class.getName());
                baseImportClassNameSet.add(Array.class.getName());
                break;
            }
            case DAO: {
                importClassNameSet.add("org.seasar.dao.annotation.tiger.S2Dao");
                break;
            }
            case DXO: {
                importClassNameSet.add(List.class.getName());
                importClassNameSet.add(entityMetaData.getBeanClassDesc().getName());
                importClassNameSet.add(entityMetaData.getDtoClassDesc().getName());
                break;
            }
            case CONVERTER: {
                importClassNameSet.clear();
                baseImportClassNameSet.add(Binding.class.getName());
                baseImportClassNameSet.add(BindingType.class.getName());
                baseImportClassNameSet.add(Messages.class.getName());
                baseImportClassNameSet.add(TypeConversionManager.class.getName());
                TypeDesc[] pairTypeDescs = (TypeDesc[])parameter.get("pairTypeDescs");
                if (pairTypeDescs == null || pairTypeDescs.length <= 0) break;
                baseImportClassNameSet.add(ArrayList.class.getName());
                baseImportClassNameSet.add(List.class.getName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Logic error");
            }
        }
        parameter.put("classDesc", classDesc);
        parameter.put("importClassSet", importClassNameSet);
        parameter.put("baseImportClassSet", baseImportClassNameSet);
    }

    private void prepareForWriting(ClassDesc classDesc) {
        Map<String, Object> parameter = classDesc.getSourceGeneratorParameter();
        parameter.put("preamble", this.getJavaPreamble());
    }

    public void prepareForAttribute(ClassDesc classDesc) {
        if (classDesc.isTypeOf(ClassType.PAGE)) {
            ArrayList<MethodDesc> list = new ArrayList<MethodDesc>();
            for (MethodDesc methodDesc : classDesc.getMethodDescs()) {
                if (!this.isAction(methodDesc)) continue;
                list.add(methodDesc);
            }
            classDesc.setAttribute("action", list.toArray(new MethodDesc[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustByExistentClass(ClassDesc desc) {
        DescPool pool = desc.getDescPool();
        String oldBornOf = pool.getBornOf();
        try {
            Object key;
            ClassDesc baseDesc;
            pool.setBornOf(null);
            String className = desc.getName();
            Class<?> clazz = this.getClass(className);
            ClassDesc gapDesc = this.newClassDesc(pool, clazz, true);
            if (gapDesc == null) {
                gapDesc = this.newClassDesc(pool, className, null);
            }
            String baseClassName = className + "Base";
            Class<?> baseClass = this.getClass(baseClassName);
            ClassDesc classDesc = baseDesc = desc.getType().isSubordinate() ? null : this.newClassDesc(pool, baseClass, true);
            if (baseDesc == null) {
                baseDesc = this.newClassDesc(pool, baseClassName, null);
                if (!baseClassName.equals(desc.getSuperclassName())) {
                    baseDesc.setSuperclassName(desc.getSuperclassName());
                }
            }
            if (baseClass != null) {
                desc.setAbstract(Modifier.isAbstract(baseClass.getModifiers()));
            }
            ClassDesc generated = desc.transcriptTo(this.newClassDesc(pool, desc.getName(), null));
            desc.clear();
            desc.setSourceGeneratorParameter(generated.getSourceGeneratorParameter());
            desc.setAttributeMap(generated.getAttributeMap());
            ClassDesc baseDescOtherBoneOf = baseDesc.transcriptTo(pool.getClassDesc(baseDesc.getName()));
            baseDescOtherBoneOf.removeBornOf(desc.getBornOf());
            desc.merge(baseDescOtherBoneOf, true);
            ClassDesc superDesc = this.newClassDesc(pool, this.getClass(desc.getSuperclassName()), false);
            if (superDesc == null) {
                superDesc = this.newClassDesc(pool, Object.class, false);
            }
            PropertyDesc[] pds = generated.getPropertyDescs();
            for (int i = 0; i < pds.length; ++i) {
                PropertyDesc generatedPd = pds[i];
                PropertyDesc basePd = baseDesc.getPropertyDesc(generatedPd.getName());
                if (basePd == null || !basePd.isReadable()) {
                    this.removeModeFrom(generatedPd, 1, gapDesc);
                    this.removeModeFrom(generatedPd, 1, superDesc);
                }
                if (basePd == null || !basePd.isWritable()) {
                    this.removeModeFrom(generatedPd, 2, gapDesc);
                    this.removeModeFrom(generatedPd, 2, superDesc);
                }
                if (!(generatedPd.isReadable() || generatedPd.isWritable() || pds[i].hasMeta("property") && !this.isFormDtoFieldPresent(superDesc, generatedPd.getName()))) {
                    generated.removePropertyDesc(generatedPd.getName());
                }
                if (basePd == null || generatedPd == null) continue;
                TypeDesc baseTd = basePd.getTypeDesc();
                TypeDesc generatedTd = generatedPd.getTypeDesc();
                if (generatedTd.getCollectionImplementationClassName() == null) {
                    generatedTd.setCollectionImplementationClassName(baseTd.getCollectionImplementationClassName());
                }
                generatedPd.setAnnotationDescs(this.mergeAnnotationDescs(basePd.getAnnotationDescs(), generatedPd.getAnnotationDescs()));
                generatedPd.setAnnotationDescsOnGetter(this.mergeAnnotationDescs(basePd.getAnnotationDescsOnGetter(), generatedPd.getAnnotationDescsOnGetter()));
                generatedPd.setAnnotationDescsOnSetter(this.mergeAnnotationDescs(basePd.getAnnotationDescsOnSetter(), generatedPd.getAnnotationDescsOnSetter()));
            }
            MethodDesc[] mds = generated.getMethodDescs();
            for (int i = 0; i < mds.length; ++i) {
                MethodDesc existentMd;
                TypeDesc td;
                MethodDesc generatedMd = mds[i];
                MethodDesc gapMd = gapDesc.getMethodDesc(generatedMd);
                MethodDesc baseMd = baseDesc.getMethodDesc(generatedMd);
                MethodDesc otherBornOfMd = desc.getMethodDesc(generatedMd);
                MethodDesc superMd = superDesc.getMethodDesc(generatedMd);
                if (baseMd == null && (gapMd != null || superMd != null)) {
                    generated.removeMethodDesc(generatedMd);
                    continue;
                }
                if (this.isAction(generatedMd)) {
                    key = new MethodDescKey(generatedMd);
                    for (MethodDesc md : gapDesc.getMethodDescs(generatedMd.getName())) {
                        if (((MethodDescKey)key).equals(new MethodDescKey(md))) continue;
                        generated.removeMethodDesc(generatedMd);
                    }
                }
                TypeDesc returnTd = generatedMd.getReturnTypeDesc();
                if (gapMd != null && !returnTd.equals(gapMd.getReturnTypeDesc())) {
                    td = gapMd.getReturnTypeDesc();
                    generatedMd.setReturnTypeDesc(td.transcriptTo(desc.getDescPool().newTypeDesc(td)));
                } else if (superMd != null && !returnTd.equals(superMd.getReturnTypeDesc())) {
                    td = superMd.getReturnTypeDesc();
                    generatedMd.setReturnTypeDesc(td.transcriptTo(desc.getDescPool().newTypeDesc(td)));
                } else if (otherBornOfMd != null && Void.TYPE.getName().equals(returnTd.getName())) {
                    td = otherBornOfMd.getReturnTypeDesc();
                    generatedMd.setReturnTypeDesc(td.transcriptTo(desc.getDescPool().newTypeDesc(td)));
                }
                MethodDesc methodDesc = existentMd = gapMd != null ? gapMd : baseMd;
                if (existentMd != null) {
                    ThrowsDescImpl throwsDesc = new ThrowsDescImpl();
                    for (String throwableClassName : existentMd.getThrowsDesc().getThrowableClassNames()) {
                        throwsDesc.addThrowable(throwableClassName);
                    }
                    generatedMd.setThrowsDesc(throwsDesc);
                }
                if (baseMd == null) continue;
                generatedMd.setAnnotationDescs(this.mergeAnnotationDescs(baseMd.getAnnotationDescs(), generatedMd.getAnnotationDescs()));
                if (gapMd != null || generatedMd.getBodyDesc() != null || baseMd.getBodyDesc() == null) continue;
                generatedMd.setBodyDesc(baseMd.getBodyDesc());
                generatedMd.setReturnTypeDesc(baseMd.getReturnTypeDesc());
            }
            LinkedHashMap<Object, PropertyDesc> newDescPdMap = new LinkedHashMap<Object, PropertyDesc>();
            LinkedHashMap<String, PropertyDesc> descPdMap = new LinkedHashMap<String, PropertyDesc>();
            for (PropertyDesc descPd : desc.getPropertyDescs()) {
                descPdMap.put(descPd.getName(), descPd);
            }
            for (PropertyDesc generatedPd : generated.getPropertyDescs()) {
                key = generatedPd.getName();
                PropertyDesc pd = (PropertyDesc)descPdMap.get(key);
                if (pd == null) continue;
                newDescPdMap.put(key, pd);
                descPdMap.remove(key);
            }
            for (PropertyDesc descPd : descPdMap.values()) {
                newDescPdMap.put(descPd.getName(), descPd);
            }
            desc.setPropertyDescs(newDescPdMap.values().toArray(new PropertyDesc[0]));
            LinkedHashMap<MethodDescKey, MethodDesc> newDescMdMap = new LinkedHashMap<MethodDescKey, MethodDesc>();
            LinkedHashMap<MethodDescKey, MethodDesc> descMdMap = new LinkedHashMap<MethodDescKey, MethodDesc>();
            for (MethodDesc descMd : desc.getMethodDescs()) {
                descMdMap.put(new MethodDescKey(descMd), descMd);
            }
            for (MethodDesc generatedMd : generated.getMethodDescs()) {
                MethodDescKey key2 = new MethodDescKey(generatedMd);
                MethodDesc md = (MethodDesc)descMdMap.get(key2);
                if (md == null) continue;
                newDescMdMap.put(key2, md);
                descMdMap.remove(key2);
            }
            for (MethodDesc descMd : descMdMap.values()) {
                newDescMdMap.put(new MethodDescKey(descMd), descMd);
            }
            desc.setMethodDescs(newDescMdMap.values().toArray(new MethodDesc[0]));
            desc.merge(generated, true);
            if (desc.isTypeOf(ClassType.DTO)) {
                MethodDescImpl methodDesc = new MethodDescImpl(pool, "toString");
                desc.removeMethodDesc(methodDesc);
            }
        }
        finally {
            pool.setBornOf(oldBornOf);
        }
    }

    private AnnotationDesc[] mergeAnnotationDescs(AnnotationDesc[] baseAnnotationDescs, AnnotationDesc[] generatedAnnotationDescs) {
        HashMap<String, AnnotationDesc> baseNonMetaAdMap = new HashMap<String, AnnotationDesc>();
        HashMap<String, AnnotationDesc> baseMetaAdMap = new HashMap<String, AnnotationDesc>();
        HashMap<String, AnnotationDesc> generatedNonMetaAdMap = new HashMap<String, AnnotationDesc>();
        HashMap<String, AnnotationDesc> generatedMetaAdMap = new HashMap<String, AnnotationDesc>();
        for (AnnotationDesc ad : baseAnnotationDescs) {
            if (DescUtils.isMetaAnnotation(ad)) {
                baseMetaAdMap.put(ad.getName(), ad);
                continue;
            }
            baseNonMetaAdMap.put(ad.getName(), ad);
        }
        for (AnnotationDesc ad : generatedAnnotationDescs) {
            if (DescUtils.isMetaAnnotation(ad)) {
                generatedMetaAdMap.put(ad.getName(), ad);
                continue;
            }
            generatedNonMetaAdMap.put(ad.getName(), ad);
        }
        ClassDescImpl dummyCd = new ClassDescImpl(null, SINGULAR_SUFFIX2);
        for (AnnotationDesc ad : DescUtils.merge(baseNonMetaAdMap.values().toArray(new AnnotationDesc[0]), generatedNonMetaAdMap.values().toArray(new AnnotationDesc[0]), false)) {
            dummyCd.setAnnotationDesc(ad);
        }
        for (AnnotationDesc ad : DescUtils.merge(baseMetaAdMap.values().toArray(new AnnotationDesc[0]), generatedMetaAdMap.values().toArray(new AnnotationDesc[0]), true)) {
            dummyCd.setAnnotationDesc(ad);
        }
        return dummyCd.getAnnotationDescs();
    }

    private boolean isAction(MethodDesc methodDesc) {
        if (methodDesc == null) {
            return false;
        }
        Boolean action = (Boolean)methodDesc.getAttribute("action");
        return action != null && action != false;
    }

    boolean isFormDtoFieldPresent(ClassDesc cd, String formName) {
        Class<?> clazz = this.getClass(cd.getName());
        if (clazz == null || clazz == Object.class) {
            return false;
        }
        return DescUtils.findField(this.setting_.getFieldName(formName), clazz) != null;
    }

    void removeModeFrom(PropertyDesc pd, int mode, ClassDesc cd) {
        PropertyDesc p = cd.getPropertyDesc(pd.getName());
        if (p != null && (p.getMode() & mode) != 0) {
            pd.setMode(pd.getMode() & ~mode);
        }
    }

    public void mergeWithExistentClass(ClassDesc classDesc) {
        String className = classDesc.getName();
        classDesc.merge(this.newClassDesc(classDesc.getDescPool(), this.getClass(className), false), false);
    }

    public void writeSourceFile(ClassDesc classDesc, ClassDescSet classDescSet) throws InvalidClassDescException {
        DescValidator.Result result = DescValidator.validate(classDesc, classDescSet);
        if (!result.isValid()) {
            throw new InvalidClassDescException(result.getClassNames());
        }
        this.writeString(this.generateBaseSource(classDesc), this.getSourceFile(classDesc.getName() + "Base"));
        File sourceFile = this.getSourceFile(classDesc.getName());
        if (!sourceFile.exists()) {
            this.writeString(this.generateGapSource(classDesc), sourceFile);
        }
    }

    public String generateGapSource(ClassDesc classDesc) {
        if (classDesc == null) {
            return null;
        }
        ImportDescImpl importDesc = new ImportDescImpl(this, classDesc);
        classDesc.getSourceGeneratorParameter().put("importDesc", importDesc);
        HashSet<String> set = new HashSet<String>((Set)classDesc.getSourceGeneratorParameter().get("importClassSet"));
        classDesc.setTouchedClassNameSet(set);
        this.sourceGenerator_.generateGapSource(classDesc);
        importDesc.add(set);
        return this.sourceGenerator_.generateGapSource(classDesc);
    }

    public String generateBaseSource(ClassDesc classDesc) {
        if (classDesc == null) {
            return null;
        }
        Map<String, Object> parameter = classDesc.getSourceGeneratorParameter();
        ImportDescImpl importDesc = new ImportDescImpl(this, classDesc);
        parameter.put("importDesc", importDesc);
        HashSet<String> set = new HashSet<String>((Set)parameter.get("baseImportClassSet"));
        classDesc.setTouchedClassNameSet(set);
        List list = (List)parameter.get("auxDescList");
        if (list != null) {
            for (Desc desc : list) {
                desc.setTouchedClassNameSet(set);
            }
        }
        this.sourceGenerator_.generateBaseSource(classDesc);
        importDesc.add(set);
        return this.sourceGenerator_.generateBaseSource(classDesc);
    }

    @Override
    public void writeEmptyBaseSourceFileIfNotExists(ClassDesc classDesc) {
        if (classDesc == null) {
            return;
        }
        Map<String, Object> parameter = classDesc.getSourceGeneratorParameter();
        ImportDescImpl importDesc = new ImportDescImpl(this, classDesc);
        importDesc.add(new HashSet<String>((Set)parameter.get("baseImportClassSet")));
        parameter.put("importDesc", importDesc);
        this.writeSourceFile("Base.java", classDesc, false);
    }

    @Override
    public void writeSourceFile(String templateName, ClassDesc classDesc, boolean force) {
        File sourceFile = this.getSourceFile(classDesc.getName());
        if (force || !sourceFile.exists()) {
            this.writeString(this.sourceGenerator_.generateClassSource(templateName, classDesc), sourceFile);
        }
    }

    void writeString(String string, File file) {
        if (string == null) {
            return;
        }
        file.getParentFile().mkdirs();
        try {
            this.writeString(string, new FileOutputStream(file));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    void writeString(String string, OutputStream os) {
        try {
            if (string == null) {
                return;
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, this.sourceEncoding_));
            writer.write(string);
            writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    @Override
    public MatchedPathMapping findMatchedPathMapping(String path, HttpMethod method) {
        if (path == null) {
            return null;
        }
        return this.ymir_.findMatchedPathMapping(path, method);
    }

    @Override
    public boolean isDenied(String path, HttpMethod method) {
        if (path == null) {
            return true;
        }
        MatchedPathMapping matched = this.ymir_.findMatchedPathMapping(path, method);
        if (matched == null) {
            return true;
        }
        return matched.getPathMapping().isDenied();
    }

    @Override
    public String getComponentName(String path, HttpMethod method) {
        if (path == null) {
            return null;
        }
        MatchedPathMapping matched = this.ymir_.findMatchedPathMapping(path, method);
        if (matched == null) {
            return null;
        }
        return matched.getPathMapping().getPageComponentName(matched.getVariableResolver());
    }

    @Override
    public String getClassName(String componentName) {
        LocalHotdeployS2Container hotdeployContainer;
        String className;
        if (componentName != null && (className = (hotdeployContainer = this.getApplication().getHotdeployS2Container()).getNamingConvention().fromComponentNameToClassName(componentName)) != null) {
            return className;
        }
        return null;
    }

    @Override
    public Class<?> getClass(String className) {
        if (className == null) {
            return null;
        }
        Class clazz = ClassUtils.getPrimitive((String)className);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader cl = this.getClassLoader();
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            block16: {
                if (className.indexOf(46) < 0) {
                    try {
                        return cl.loadClass(PACKAGEPREFIX_JAVA_LANG + className);
                    }
                    catch (ClassNotFoundException ex2) {
                        try {
                            return cl.loadClass(PACKAGEPREFIX_JAVA_UTIL + className);
                        }
                        catch (ClassNotFoundException ex3) {
                            String dtoClassName = this.setting_.findDtoClassName(className);
                            if (dtoClassName != null) {
                                try {
                                    return cl.loadClass(dtoClassName);
                                }
                                catch (ClassNotFoundException ignore) {
                                    // empty catch block
                                }
                            }
                            ClassTraverser traverser = new ClassTraverser();
                            for (Class<?> landmark : this.getLandmarks()) {
                                traverser.addReferenceClass(landmark);
                            }
                            for (String rootPackageName : this.getRootPackageNames()) {
                                traverser.addClassPattern(rootPackageName, className);
                            }
                            final String[] found = new String[1];
                            traverser.setClassHandler(new ClassTraversal.ClassHandler(){

                                public void processClass(String packageName, String shortClassName) {
                                    found[0] = packageName + "." + shortClassName;
                                }
                            });
                            traverser.traverse();
                            if (found[0] == null) break block16;
                            try {
                                return cl.loadClass(found[0]);
                            }
                            catch (ClassNotFoundException ignore) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            return null;
        }
    }

    private Class<?>[] getLandmarks() {
        ClassLoader classLoader = this.getClassLoader();
        ArrayList landmarkList = new ArrayList();
        for (String landmarkClassName : PropertyUtils.toLines((String)this.getApplication().getProperty("landmark", "org.seasar.ymir.landmark.Landmark"))) {
            try {
                landmarkList.add(classLoader.loadClass(landmarkClassName));
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        return landmarkList.toArray(new Class[0]);
    }

    protected ClassLoader getClassLoader() {
        return this.getApplication().getHotdeployS2Container().getContainer().getClassLoader();
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String className, String propertyName) {
        Class<?> clazz = this.getClass(className);
        if (clazz == null || propertyName == null) {
            return null;
        }
        return this.getPropertyDescriptor(clazz, propertyName);
    }

    private PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String propertyName) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException(ex);
        }
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            if (!descriptor.getName().equals(propertyName)) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public Template getTemplate(String path) {
        return this.templateProvider_.getTemplate(path);
    }

    @Override
    public File getSourceFile(String className) {
        return new File(this.getSourceDirectory(), className.replace('.', '/') + ".java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getSourceCreatorProperties() {
        if (this.sourceCreatorProperties_ == null) {
            this.sourceCreatorProperties_ = new Properties();
            File file = this.getSourceCreatorPropertiesFile();
            if (file.exists()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file);
                    this.sourceCreatorProperties_.load(new BufferedInputStream(fis));
                }
                catch (IOException ex) {
                    this.log_.error((Object)("Can't read properties: " + file));
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return this.sourceCreatorProperties_;
    }

    @Override
    public File getSourceCreatorPropertiesFile() {
        return new File(this.getPreferencesDirectory(), "org.seasar.ymir.extension.sourceCreator.prefs");
    }

    File getMappingPropertiesFile() {
        return new File(this.getPreferencesDirectory(), "org.seasar.ymir.extension.mapping.prefs");
    }

    @Override
    public PersistentProperties getMappingProperties() {
        return new PersistentProperties(this.getMappingPropertiesFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSourceCreatorProperties() {
        if (this.sourceCreatorProperties_ == null) {
            return;
        }
        MapProperties prop = new MapProperties(new TreeMap<Object, Object>(this.sourceCreatorProperties_));
        File file = this.getSourceCreatorPropertiesFile();
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            prop.store((OutputStream)new BufferedOutputStream(fos), "ISO-8859-1");
            fos = null;
        }
        catch (IOException ex) {
            this.log_.error((Object)("Can't write properties: " + file));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    @Override
    public File getSourceDirectory() {
        String sourceDirectory = this.getApplication().getSourceDirectory();
        if (sourceDirectory != null) {
            return new File(sourceDirectory);
        }
        return null;
    }

    @Override
    public File getResourcesDirectory() {
        String resourcesDirectory = this.getApplication().getResourcesDirectory();
        if (resourcesDirectory != null) {
            return new File(resourcesDirectory);
        }
        return null;
    }

    File getPreferencesDirectory() {
        return new File(this.getApplication().getProjectRoot(), ".settings");
    }

    @Override
    public File getWebappSourceRoot() {
        return new File(this.getApplication().getWebappSourceRoot());
    }

    public TemplateAnalyzer getTemplateAnalyzer() {
        return this.analyzer_;
    }

    @Override
    public String getSourceEncoding() {
        return this.sourceEncoding_;
    }

    @Override
    public String getFirstRootPackageName() {
        return this.getApplication().getFirstRootPackageName();
    }

    @Override
    public String[] getRootPackageNames() {
        return this.getApplication().getRootPackageNames();
    }

    @Override
    public String getPagePackageName() {
        return this.getFirstRootPackageName() + "." + this.namingConvention_.getSubApplicationRootPackageName();
    }

    @Override
    public String getDtoPackageName() {
        return this.getFirstRootPackageName() + "." + this.namingConvention_.getDtoPackageName();
    }

    @Override
    public String getDaoPackageName() {
        return this.getFirstRootPackageName() + "." + this.namingConvention_.getDaoPackageName();
    }

    @Override
    public String getDxoPackageName() {
        return this.getFirstRootPackageName() + "." + this.namingConvention_.getDxoPackageName();
    }

    @Override
    public String getConverterPackageName() {
        return this.getFirstRootPackageName() + "." + this.namingConvention_.getConverterPackageName();
    }

    @Override
    public SourceGenerator getSourceGenerator() {
        return this.sourceGenerator_;
    }

    @Override
    public ResponseCreator getResponseCreator() {
        return this.responseCreator_;
    }

    @Override
    public Application getApplication() {
        return this.applicationManager_.findContextApplication();
    }

    @Override
    public ServletContext getServletContext() {
        return (ServletContext)this.getRootS2Container().getComponent(ServletContext.class);
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.getRootS2Container().getComponent(HttpServletRequest.class);
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)this.getRootS2Container().getComponent(HttpServletResponse.class);
    }

    Request getRequest() {
        return (Request)this.getRootS2Container().getComponent(Request.class);
    }

    S2Container getS2Container() {
        return this.getApplication().getS2Container();
    }

    S2Container getRootS2Container() {
        return SingletonS2ContainerFactory.getContainer();
    }

    public void registerUpdateAction(Object condition, UpdateAction updateAction) {
        this.actionSelector_.register(condition, updateAction);
    }

    @Override
    public ClassDesc newClassDesc(DescPool pool, String className, ClassCreationHintBag hintBag) {
        return this.newClassDesc(pool, className, null, hintBag);
    }

    @Override
    public ClassDesc newClassDesc(DescPool pool, String className, String qualifier, ClassCreationHintBag hintBag) {
        ClassHint hint;
        ClassDescImpl classDesc = new ClassDescImpl(pool, className, qualifier);
        String superclassName = null;
        if (hintBag != null && (hint = hintBag.getClassHint(className)) != null) {
            superclassName = hint.getSuperclassName();
        }
        if (superclassName == null) {
            Class<?> superclass;
            Class<?> clazz = this.getClass(className);
            if (clazz != null && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
                if (superclass.getName().equals(className + "Base")) {
                    superclass = superclass.getSuperclass();
                }
                superclassName = superclass.getName();
            }
            if (superclassName == null && (superclassName = this.setting_.getSuperclassName(className)) == null && classDesc.isTypeOf(ClassType.PAGE)) {
                superclassName = this.setting_.getPageSuperclassName();
                if (className.equals(superclassName)) {
                    superclassName = null;
                }
                if (superclassName != null && (superclass = this.findClass(ClassUtils.getShortName((String)superclassName), className)) != null) {
                    superclassName = superclass.getName();
                }
            }
        }
        if (superclassName != null) {
            classDesc.setSuperclassName(superclassName);
        }
        return classDesc;
    }

    @Override
    public TemplateProvider getTemplateProvider() {
        return this.templateProvider_;
    }

    public String filterResponse(String response) {
        if (!this.shouldUpdate() || !this.shouldUpdate(this.getRequest().getCurrentDispatch().getPath())) {
            return response;
        }
        if (this.setting_.isJavascriptEnabled()) {
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            variableMap.put("sourceCreator", this);
            variableMap.put("root", this.getHttpServletRequest().getContextPath() + "/__ymir__/" + "resource");
            variableMap.put("buttonCreator", new ButtonCreator(this.getRequest()));
            String javascriptHead = this.getResponseCreator().evaluateTemplate("javascriptHead", variableMap);
            response = response.replace("</head>", javascriptHead + "</head>");
            if (this.setting_.isInPlaceEditorEnabled()) {
                String inPlaceEditorBodyHead = this.getResponseCreator().evaluateTemplate("inPlaceEditorBodyHead", variableMap);
                response = Pattern.compile("(<body(\\s+[^>]*)?>)").matcher(response).replaceFirst("$1" + Matcher.quoteReplacement(inPlaceEditorBodyHead));
                String inPlaceEditorBodyFoot = this.getResponseCreator().evaluateTemplate("inPlaceEditorBodyFoot", variableMap);
                response = response.replace("</body>", Matcher.quoteReplacement(inPlaceEditorBodyFoot) + "</body>");
            }
            if (this.setting_.isControlPanelEnabled()) {
                String controlPanelBody = this.getResponseCreator().evaluateTemplate("controlPanelBody", variableMap);
                response = response.replace("</body>", Matcher.quoteReplacement(controlPanelBody) + "</body>");
            }
        }
        return response;
    }

    String createButtonHTML(Request request, String taskName, String buttonLabel) {
        StringBuilder sb = new StringBuilder();
        sb.append("<form action=\"").append(request.getAbsolutePath()).append("\" method=\"post\">").append("<input type=\"hidden\" name=\"").append("__ymir__task").append("\" value=\"").append(taskName).append("\" /><input type=\"hidden\" name=\"").append("__ymir__method").append("\" value=\"").append(request.getMethod()).append("\" />");
        Iterator itr = request.getParameterNames();
        while (itr.hasNext()) {
            String encodedName;
            String name = (String)itr.next();
            if (name.startsWith("__ymir__")) continue;
            try {
                encodedName = HTMLUtils.filter((String)URLEncoder.encode(name, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Can't happen!", ex);
            }
            for (String value : request.getParameterValues(name)) {
                String encodedValue;
                try {
                    encodedValue = HTMLUtils.filter((String)URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException("Can't happen!", ex);
                }
                sb.append("<input type=\"hidden\" name=\"").append(encodedName).append("\" value=\"").append(encodedValue).append("\" />");
            }
        }
        sb.append("<input type=\"submit\" value=\"").append(buttonLabel).append("\" /></form>");
        return sb.toString();
    }

    @Override
    public String getTemplateEncoding() {
        return this.getApplication().getTemplateEncoding();
    }

    @Override
    public long getCheckedTime(Template template) {
        String key;
        Properties prop = this.getSourceCreatorProperties();
        String timeString = prop.getProperty(key = "updateClassesAction.checkedTime." + template.getPath());
        long time = timeString == null ? 0L : Long.parseLong(timeString);
        return time;
    }

    @Override
    public void updateCheckedTime(Template template) {
        Properties prop = this.getSourceCreatorProperties();
        String key = "updateClassesAction.checkedTime." + template.getPath();
        prop.setProperty(key, String.valueOf(System.currentTimeMillis()));
        this.saveSourceCreatorProperties();
    }

    @Override
    public String getJavaPreamble() {
        return IOUtils.readString((InputStream)this.getClassLoader().getResourceAsStream(RESOURCE_PREAMBLE_JAVA), (String)"UTF-8", (boolean)true);
    }

    @Override
    public SourceCreatorSetting getSourceCreatorSetting() {
        return this.setting_;
    }

    @Override
    public ExtraPathMapping getExtraPathMapping(String path, HttpMethod method) {
        PathMappingExtraData<?> pathMappingExtraData;
        MatchedPathMapping mapping = this.findMatchedPathMapping(path, method);
        if (mapping == null) {
            return null;
        }
        Class<?> clazz = mapping.getPathMapping().getClass();
        do {
            pathMappingExtraData = this.pathMappingExtraDataMap_.get(clazz);
            clazz = clazz.getSuperclass();
        } while (pathMappingExtraData == null && clazz != Object.class);
        if (pathMappingExtraData == null) {
            throw new RuntimeException("PathMappingExtraData not found. Please register PathMappingExtraData Component: " + clazz.getName());
        }
        return new ExtraPathMappingImpl(pathMappingExtraData, mapping, path, method);
    }

    @Override
    public Class<?> findClass(String name, String baseClassName) {
        int dot;
        int pre = baseClassName.length();
        while ((dot = baseClassName.lastIndexOf(46, pre)) >= 0) {
            try {
                return ClassUtils.forName((String)(baseClassName.substring(0, dot + 1) + name));
            }
            catch (ClassNotFoundException ignore) {
                pre = dot - 1;
            }
        }
        return null;
    }

    @Override
    public MethodDesc newActionMethodDesc(DescPool pool, String path, HttpMethod method, ActionSelectorSeed seed) {
        MethodDesc methodDesc = this.getExtraPathMapping(path, method).newActionMethodDesc(pool, seed);
        String returnType = this.setting_.getActionReturnType(method);
        methodDesc.setReturnTypeDesc(returnType);
        this.setActionMethodDescBodyTo(methodDesc);
        this.setActionInfo(methodDesc, this.getActionInterface(method), seed.getActionKey());
        return methodDesc;
    }

    private Class<? extends Action> getActionInterface(HttpMethod method) {
        return ACTIONINTERFACE_BY_HTTPMETHOD_MAP.get(method);
    }

    @Override
    public MethodDesc newPrerenderActionMethodDesc(DescPool pool, String path, HttpMethod method, ActionSelectorSeed seed) {
        return this.getExtraPathMapping(path, method).newPrerenderActionMethodDesc(pool, seed);
    }

    void setActionMethodDescBodyTo(MethodDesc methodDesc) {
        String returnType = methodDesc.getReturnTypeDesc().getCompleteName();
        if (returnType.equals(String.class.getName())) {
            methodDesc.setBodyDesc(new BodyDescImpl("return \"passthrough:\";", new String[0]));
        } else if (returnType.equals(Response.class.getName())) {
            methodDesc.setBodyDesc(new BodyDescImpl("return new PassthroughResponse();", new String[]{PassthroughResponse.class.getName()}));
        }
    }

    boolean isValidationFailedMethodEnabled() {
        return PropertyUtils.valueOf((String)this.getApplication().getProperty("core.constraint.validationFailedMethod.enable"), (boolean)true);
    }

    boolean isPermissionDeniedMethodEnabled() {
        return PropertyUtils.valueOf((String)this.getApplication().getProperty("core.constraint.permissionDeniedMethod.enable"), (boolean)true);
    }

    @Override
    public boolean isGeneratedClass(String className) {
        if (className == null) {
            return false;
        }
        return className.startsWith(this.getFirstRootPackageName() + ".");
    }

    @Override
    public boolean isDtoClass(String className) {
        if (className == null) {
            return false;
        }
        return this.setting_.isOnDtoSearchPath(className) || new ClassDescImpl(null, className).isTypeOf(ClassType.DTO);
    }

    @Override
    public String getActionKeyFromParameterName(String path, HttpMethod method, String parameterName) {
        if (parameterName == null) {
            return null;
        }
        MatchedPathMapping matched = this.findMatchedPathMapping(path, method);
        if (matched == null) {
            return null;
        }
        return matched.getPathMapping().getActionKeyFromParameterName(parameterName);
    }

    @Override
    public ParameterRole inferParameterRole(final String path, final HttpMethod method, String pageClassName, String parameterName, ClassHint classHint) {
        ParameterRole role;
        if (classHint != null && (role = classHint.getParameterRole(parameterName)) != ParameterRole.UNDECIDED) {
            return role;
        }
        final String actionKey = this.getActionKeyFromParameterName(path, method, parameterName);
        if (actionKey == null) {
            return ParameterRole.PARAMETER;
        }
        Class<?> pageClass = this.getClass(pageClassName);
        if (pageClass == null) {
            return ParameterRole.UNDECIDED;
        }
        PageComponent pageComponent = this.createPageComponent(pageClass);
        if (pageComponent == null) {
            return ParameterRole.UNDECIDED;
        }
        ParameterRole role2 = (ParameterRole)((Object)pageComponent.accept((Object)new PageComponentVisitor<ParameterRole>(){

            public ParameterRole process(PageComponent pageComponent, Object ... parameters) {
                if (SourceCreatorImpl.this.getPropertyDescriptor(pageComponent.getPageClass(), actionKey) != null) {
                    return ParameterRole.PARAMETER;
                }
                String methodName = SourceCreatorImpl.this.newActionMethodDesc(DescPool.newInstance(SourceCreatorImpl.this, null), path, method, new ActionSelectorSeedImpl(actionKey)).getName();
                for (Method m : ClassUtils.getMethods((Class)pageComponent.getPageClass())) {
                    if (!m.getName().equals(methodName)) continue;
                    return ParameterRole.BUTTON;
                }
                return null;
            }
        }, new Object[0]));
        if (role2 == null) {
            role2 = ParameterRole.UNDECIDED;
        }
        return role2;
    }

    private PageComponent createPageComponent(Class<?> pageClass) {
        PageComponentImpl pageComponent;
        Object page;
        try {
            page = pageClass.newInstance();
        }
        catch (Throwable t) {
            this.log_.warn((Object)("Can't instantiate Page object: " + pageClass.getName()), t);
            return null;
        }
        Include children = pageClass.getAnnotation(Include.class);
        if (children != null) {
            Class[] childrenClasses = children.value();
            ArrayList<PageComponent> childPageList = new ArrayList<PageComponent>();
            for (int i = 0; i < childrenClasses.length; ++i) {
                PageComponent pc = this.createPageComponent(childrenClasses[i]);
                if (pc == null) continue;
                childPageList.add(pc);
            }
            pageComponent = new PageComponentImpl(page, pageClass, childPageList.toArray(new PageComponent[0]));
        } else {
            pageComponent = new PageComponentImpl(page, pageClass);
        }
        return pageComponent;
    }

    @Override
    public ClassDesc buildTransitionClassDesc(DescPool pool, String path, HttpMethod method, Map<String, String[]> parameterMap) {
        MatchedPathMapping matched = this.findMatchedPathMapping(path, method);
        if (matched == null || matched.isDenied()) {
            return null;
        }
        String pageClassName = this.getClassName(matched.getPageComponentName());
        if (pageClassName == null) {
            return null;
        }
        ClassDesc classDesc = pool.getClassDesc(pageClassName);
        block5: for (String name : parameterMap.keySet()) {
            if (!AnalyzerUtils.shouldGeneratePropertyForParameter(name)) continue;
            if (BeanUtils.isSingleSegment((String)name)) {
                String[] values = parameterMap.get(name);
                ParameterRole role = values != null && values.length != 0 && (values.length != 1 || !SINGULAR_SUFFIX2.equals(values[0])) ? ParameterRole.PARAMETER : this.inferParameterRole(path, method, pageClassName, name, this.getClassHint(pool, pageClassName));
                switch (role) {
                    case PARAMETER: {
                        PropertyDesc propertyDesc = this.addPropertyDesc(classDesc, name, 3, pageClassName);
                        propertyDesc.setAnnotationDescOnSetter(new AnnotationDescImpl(RequestParameter.class.getName()));
                        DescUtils.addParameter(propertyDesc, name);
                        break;
                    }
                    case BUTTON: {
                        MethodDesc methodDesc = this.newActionMethodDesc(classDesc.getDescPool(), path, method, new ActionSelectorSeedImpl(name));
                        if (classDesc.getMethodDesc(methodDesc) != null) continue block5;
                        classDesc.setMethodDesc(methodDesc);
                        break;
                    }
                    case UNDECIDED: {
                        Object[] parameters = (String[])classDesc.getAttribute("undecidedParameterNames");
                        parameters = parameters == null ? new String[]{name} : (String[])ArrayUtil.add((Object[])parameters, (Object)name);
                        classDesc.setAttribute("undecidedParameterNames", parameters);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Logic error");
                    }
                }
                continue;
            }
            PropertyDesc propertyDesc = this.addPropertyDesc(classDesc, BeanUtils.getFirstSimpleSegment((String)name), 1, pageClassName);
            propertyDesc.setAnnotationDescOnGetter(new AnnotationDescImpl(RequestParameter.class.getName()));
            DescUtils.addParameter(propertyDesc, name);
        }
        return classDesc;
    }

    @Override
    public PropertyDesc addPropertyDesc(ClassDesc classDesc, String propertyName, int mode, String propertyTypeAlias, boolean asCollection, String collectionClassName, int probability, String pageClassName) {
        TypeDesc typeDesc;
        PropertyDesc propertyDesc = classDesc.addPropertyDesc(propertyName, mode);
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("Adding property '" + propertyName + "' (object path is '" + this.getPathExpression(propertyDesc) + "' ..."));
        }
        if (propertyDesc.isTypeAlreadySet(probability)) {
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)"Nothing has been done because type of this property had been set.");
            }
            return propertyDesc;
        }
        String className = classDesc.getName();
        String baseClassName = this.getGeneratedClassName(className, pageClassName);
        PropertyTypeHint hint = this.getPropertyTypeHint(classDesc.getDescPool(), className, propertyName);
        if (hint != null) {
            typeDesc = classDesc.getDescPool().newTypeDesc(hint.getTypeName(), this.getQualifier(propertyTypeAlias != null ? propertyTypeAlias : (asCollection ? this.toSingular(propertyName) : propertyName), GenericsUtils.getComponentClassName(hint.getTypeName())));
            probability = Integer.MAX_VALUE;
        } else {
            PropertyDescriptor descriptor = this.findPropertyDescriptor(classDesc, propertyName);
            if (descriptor != null) {
                String componentClassName;
                Method readMethod = descriptor.getReadMethod();
                if (readMethod != null) {
                    propertyDesc.setGetterName(readMethod.getName());
                }
                Class<?> componentClass = this.getClass(GenericsUtils.getComponentPropertyTypeName(descriptor));
                String qualifier = null;
                String interfaceClassName = null;
                if (componentClass.isInterface()) {
                    String qfr = this.findQualifier(propertyDesc);
                    componentClassName = this.findPropertyClassName(propertyTypeAlias != null ? propertyTypeAlias : (qfr != null ? qfr + ClassUtils.getShorterName(componentClass) : Introspector.decapitalize(ClassUtils.getShorterName(componentClass))), baseClassName);
                    if (qfr != null) {
                        probability = 5000;
                    }
                    interfaceClassName = componentClass.getName();
                } else {
                    componentClassName = componentClass.getName();
                    qualifier = this.getQualifier(propertyTypeAlias != null ? propertyTypeAlias : (asCollection ? this.toSingular(propertyName) : propertyName), componentClassName);
                    probability = this.isOuter(descriptor) ? Integer.MAX_VALUE : 5000;
                }
                String typeName = GenericsUtils.getGenericPropertyTypeName(descriptor);
                if (Collection.class.isAssignableFrom(descriptor.getPropertyType())) {
                    TypeToken typeToken = new TypeToken(typeName);
                    typeToken.getTypes()[0].setBaseName(componentClassName);
                    typeDesc = classDesc.getDescPool().newTypeDesc(typeToken.getAsString(), qualifier);
                } else {
                    typeDesc = descriptor.getPropertyType().isArray() ? classDesc.getDescPool().newTypeDesc(componentClassName + "[]", qualifier) : classDesc.getDescPool().newTypeDesc(componentClassName, qualifier);
                }
                if (interfaceClassName != null) {
                    String abstractClassName;
                    ClassDesc componentClassDesc = typeDesc.getComponentClassDesc();
                    componentClassDesc.setInterfaceTypeDescs(classDesc.getDescPool().newTypeDesc(interfaceClassName));
                    boolean createBaseClassesEnabled = this.getSourceCreatorSetting().isCreateBaseClassesEnabled();
                    if ((componentClassDesc.getSuperclassName() == null || createBaseClassesEnabled && componentClassDesc.getSuperclassName().equals(this.getSourceCreatorSetting().getSuperclassName(componentClassDesc.getName()))) && (abstractClassName = this.getSourceCreatorSetting().findDtoClassName(PREFIX_ABSTRACT + ClassUtils.getShortName((String)interfaceClassName))) != null) {
                        componentClassDesc.setSuperclassName(abstractClassName);
                    }
                }
            } else {
                String seed = propertyTypeAlias != null ? propertyTypeAlias : (asCollection ? this.toSingular(propertyName) : propertyName);
                String propertyClassName = this.inferPropertyClassName(seed, baseClassName);
                typeDesc = classDesc.getDescPool().newTypeDesc(propertyClassName, this.getQualifier(seed, propertyClassName));
                if (asCollection) {
                    this.setToCollection(typeDesc, collectionClassName);
                }
            }
        }
        if (typeDesc.isCollection() && List.class.getName().equals(typeDesc.getCollectionClassName())) {
            typeDesc.setCollectionImplementationClassName(propertyDesc.getTypeDesc().getCollectionImplementationClassName());
        }
        propertyDesc.setTypeDesc(typeDesc);
        propertyDesc.notifyTypeUpdated(probability);
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("This property's type has been inferred as '" + typeDesc + "'"));
        }
        return propertyDesc;
    }

    @Override
    public PropertyDesc addPropertyDesc(ClassDesc classDesc, String propertyName, int mode, String pageClassName) {
        return this.addPropertyDesc(classDesc, propertyName, mode, null, false, null, 1000, pageClassName);
    }

    private String getPathExpression(PropertyDesc propertyDesc) {
        LinkedList<String> list = new LinkedList<String>();
        int count = 10;
        PropertyDesc desc = propertyDesc;
        do {
            if (desc instanceof PropertyDesc) {
                list.addFirst(desc.getName());
                continue;
            }
            if (!(desc instanceof ClassDesc)) continue;
            list.addFirst("[" + ((ClassDesc)((Object)desc)).getShortName() + "]");
        } while ((desc = desc.getParent()) != null && --count >= 0);
        StringBuilder sb = new StringBuilder();
        String delim = SINGULAR_SUFFIX2;
        for (String segment : list) {
            sb.append(delim).append(segment);
            delim = "/";
        }
        return sb.toString();
    }

    private PropertyTypeHint getPropertyTypeHint(DescPool pool, String className, String propertyName) {
        if (pool.getHintBag() != null) {
            return pool.getHintBag().getPropertyTypeHint(className, propertyName);
        }
        return null;
    }

    private ClassHint getClassHint(DescPool pool, String className) {
        if (pool.getHintBag() != null) {
            return pool.getHintBag().getClassHint(className);
        }
        return null;
    }

    private String toSingular(String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(MULTIPLE_SUFFIX)) {
            return name.substring(0, name.length() - MULTIPLE_SUFFIX.length()) + SINGULAR_SUFFIX;
        }
        if (name.endsWith(MULTIPLE_SUFFIX2)) {
            return name.substring(0, name.length() - MULTIPLE_SUFFIX2.length()) + SINGULAR_SUFFIX2;
        }
        return name;
    }

    private String getQualifier(String seed, String className) {
        if (!this.getSourceCreatorSetting().isOnDtoSearchPath(className)) {
            return null;
        }
        String suffix = ClassUtils.getShorterName((String)className);
        if (seed.endsWith(suffix)) {
            return seed.substring(0, seed.length() - suffix.length());
        }
        return null;
    }

    private boolean isOuter(PropertyDescriptor descriptor) {
        Method method = descriptor.getReadMethod();
        if (method == null) {
            method = descriptor.getWriteMethod();
        }
        return this.isOuter(method.getDeclaringClass().getName());
    }

    private PropertyDescriptor findPropertyDescriptor(ClassDesc classDesc, String propertyName) {
        String className = classDesc.getName();
        PropertyDescriptor descriptor = this.getPropertyDescriptor(className, propertyName);
        if (descriptor == null) {
            descriptor = this.getPropertyDescriptor(classDesc.getSuperclassName(), propertyName);
        }
        return descriptor;
    }

    private String findQualifier(PropertyDesc propertyDesc) {
        Object parent = propertyDesc.getParent();
        if (parent instanceof ClassDesc) {
            return ((ClassDesc)parent).getQualifier();
        }
        return null;
    }

    @Override
    public String findPropertyClassName(String propertyName, String baseClassName) {
        String rootPackageName = this.getFirstRootPackageName();
        if (!baseClassName.startsWith(rootPackageName + ".")) {
            throw new IllegalArgumentException();
        }
        String subPackageName = baseClassName.substring(rootPackageName.length(), baseClassName.lastIndexOf(46));
        int dot = subPackageName.indexOf(46, 1);
        subPackageName = dot >= 0 ? subPackageName.substring(dot) : SINGULAR_SUFFIX2;
        return this.findClassName(this.getDtoPackageName(), subPackageName, this.getDtoShortClassName(propertyName));
    }

    @Override
    public String inferPropertyClassName(String propertyName, String baseClassName) {
        String className = this.findPropertyClassName(propertyName, baseClassName);
        if (this.getClass(className) != null) {
            return className;
        }
        String classNameFromSearchPath = this.getSourceCreatorSetting().findDtoClassName(propertyName);
        if (classNameFromSearchPath != null) {
            className = classNameFromSearchPath;
        }
        return className;
    }

    private String findClassName(String packageName, String subPackageName, String shortClassName) {
        int idx;
        String fullClassName = packageName + subPackageName + "." + shortClassName;
        if (this.getClass(fullClassName) != null) {
            return fullClassName;
        }
        int pre = subPackageName.length();
        while ((idx = subPackageName.lastIndexOf(46, pre)) >= 0) {
            String className = packageName + subPackageName.substring(0, idx) + "." + shortClassName;
            if (this.getClass(className) != null) {
                return className;
            }
            pre = idx - 1;
        }
        return fullClassName;
    }

    @Override
    public void setToCollection(TypeDesc typeDesc, String collectionClassName) {
        if (collectionClassName == null) {
            this.removePropertyIfNotExistActually(typeDesc.getComponentClassDesc(), PROP_LENGTH);
        } else {
            this.removePropertyIfNotExistActually(typeDesc.getComponentClassDesc(), PROP_SIZE);
        }
        typeDesc.setCollectionClassName(collectionClassName);
        typeDesc.setCollection(true);
    }

    @Override
    public boolean isOuter(ClassDesc classDesc) {
        return this.isOuter(classDesc.getName());
    }

    @Override
    public boolean isOuter(String typeName) {
        return !this.isGeneratedClass(GenericsUtils.getNonGenericClassName(typeName));
    }

    String getDtoShortClassName(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        return DescUtils.capFirst(propertyName) + ClassType.DTO.getSuffix();
    }

    private void removePropertyIfNotExistActually(ClassDesc classDesc, String propertyName) {
        if (this.getPropertyDescriptor(classDesc.getName(), propertyName) == null) {
            classDesc.removePropertyDesc(propertyName);
        }
    }

    @Override
    public String getGeneratedClassName(String className, String generatedClassName) {
        if (this.isGeneratedClass(className)) {
            return className;
        }
        return generatedClassName;
    }

    static {
        COMPARATOR_FIELD_BY_NAME = new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        HashMap<HttpMethod, Class> map = new HashMap<HttpMethod, Class>();
        for (HttpMethod method : HttpMethod.values()) {
            String name = method.name();
            try {
                Class actionInterface = ClassUtils.forName((String)("org.seasar.ymir.id.action." + name.substring(0, 1) + name.substring(1, name.length()).toLowerCase() + "Action"));
                map.put(method, actionInterface);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Cannot find Action interface. Please add Action interface for HTTP method '" + name + "'");
            }
        }
        ACTIONINTERFACE_BY_HTTPMETHOD_MAP = Collections.unmodifiableMap(map);
    }

    public class ButtonCreator {
        private Request request;

        public ButtonCreator(Request request) {
            this.request = request;
        }

        public Button getButton(String taskName) {
            return new Button(taskName);
        }

        public class Button {
            private String taskName;
            private String label;

            public Button(String taskName) {
                this.taskName = taskName;
            }

            public Button getLabel(String label) {
                this.label = label;
                return this;
            }

            public String getHTML() {
                return SourceCreatorImpl.this.createButtonHTML(ButtonCreator.this.request, this.taskName, this.label);
            }
        }
    }
}

