/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.io.File;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.Template;
import org.seasar.ymir.util.ServletUtils;

public class LazyPathMetaData
implements PathMetaData {
    private SourceCreator sourceCreator_;
    private String path_;
    private HttpMethod method_;
    private String forwardPath_;
    private boolean deniedLoaded_;
    private boolean denied_;
    private String componentName_;
    private boolean componentNameLoaded_;
    private String className_;
    private boolean classNameLoaded_;
    private File sourceFile_;
    private boolean sourceFileLoaded_;
    private File baseSourceFile_;
    private boolean baseSourceFileLoaded_;
    private Template template_;
    private boolean templateLoaded_;

    public LazyPathMetaData(SourceCreator sourceCreator, String path, HttpMethod method, String forwardPath) {
        this.sourceCreator_ = sourceCreator;
        this.path_ = ServletUtils.normalizePath((String)path);
        this.method_ = method;
        this.forwardPath_ = this.strip(forwardPath);
    }

    String strip(String path) {
        if (path == null) {
            return null;
        }
        int index = path.indexOf(63);
        if (index < 0) {
            return this.stripPathParameter(path);
        }
        return this.stripPathParameter(path.substring(0, index));
    }

    String stripPathParameter(String path) {
        if (path == null) {
            return null;
        }
        int index = path.indexOf(59);
        if (index < 0) {
            return path;
        }
        return path.substring(0, index);
    }

    public HttpMethod getMethod() {
        return this.method_;
    }

    public String getPath() {
        return this.path_;
    }

    public String getForwardPath() {
        return this.forwardPath_;
    }

    public boolean isDenied() {
        if (!this.deniedLoaded_) {
            this.denied_ = this.sourceCreator_.isDenied(this.path_, this.method_);
            this.deniedLoaded_ = true;
        }
        return this.denied_;
    }

    public String getComponentName() {
        if (!this.componentNameLoaded_) {
            String componentName = this.sourceCreator_.getComponentName(this.forwardPath_, this.method_);
            this.componentName_ = this.sourceCreator_.getClass(this.sourceCreator_.getClassName(componentName)) != null ? componentName : this.sourceCreator_.getComponentName(this.path_, this.method_);
            this.componentNameLoaded_ = true;
        }
        return this.componentName_;
    }

    public String getClassName() {
        if (!this.classNameLoaded_) {
            this.className_ = this.sourceCreator_.getClassName(this.getComponentName());
            this.classNameLoaded_ = true;
        }
        return this.className_;
    }

    public File getBaseSourceFile() {
        if (!this.baseSourceFileLoaded_) {
            this.baseSourceFile_ = this.sourceCreator_.getSourceFile(this.getClassName() + "Base");
            this.baseSourceFileLoaded_ = true;
        }
        return this.baseSourceFile_;
    }

    public File getSourceFile() {
        if (!this.sourceFileLoaded_) {
            this.sourceFile_ = this.sourceCreator_.getSourceFile(this.getClassName());
            this.sourceFileLoaded_ = true;
        }
        return this.sourceFile_;
    }

    public Template getTemplate() {
        if (!this.templateLoaded_) {
            this.template_ = this.forwardPath_ != null ? this.sourceCreator_.getTemplate(this.forwardPath_) : null;
            this.templateLoaded_ = true;
        }
        return this.template_;
    }
}

