/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.seasar.ymir.Phase;
import org.seasar.ymir.annotation.ForTesting;
import org.seasar.ymir.annotation.Include;
import org.seasar.ymir.annotation.Invoke;
import org.seasar.ymir.annotation.Published;
import org.seasar.ymir.aop.annotation.HTTP;
import org.seasar.ymir.aop.annotation.HTTPS;
import org.seasar.ymir.constraint.ConstraintType;
import org.seasar.ymir.constraint.annotation.Confirmed;
import org.seasar.ymir.constraint.annotation.Confirmeds;
import org.seasar.ymir.constraint.annotation.ConstraintAnnotation;
import org.seasar.ymir.constraint.annotation.Datetime;
import org.seasar.ymir.constraint.annotation.Datetimes;
import org.seasar.ymir.constraint.annotation.Length;
import org.seasar.ymir.constraint.annotation.Lengths;
import org.seasar.ymir.constraint.annotation.Matched;
import org.seasar.ymir.constraint.annotation.Matcheds;
import org.seasar.ymir.constraint.annotation.Numeric;
import org.seasar.ymir.constraint.annotation.Numerics;
import org.seasar.ymir.constraint.annotation.PermissionDenied;
import org.seasar.ymir.constraint.annotation.Required;
import org.seasar.ymir.constraint.annotation.Requireds;
import org.seasar.ymir.constraint.annotation.SuppressConstraints;
import org.seasar.ymir.constraint.annotation.ValidationFailed;
import org.seasar.ymir.constraint.annotation.Validator;
import org.seasar.ymir.constraint.impl.RequiredConstraint;
import org.seasar.ymir.conversation.annotation.Begin;
import org.seasar.ymir.conversation.annotation.BeginSubConversation;
import org.seasar.ymir.conversation.annotation.Conversation;
import org.seasar.ymir.conversation.annotation.End;
import org.seasar.ymir.converter.annotation.TypeConversionHint;
import org.seasar.ymir.handler.annotation.ExceptionHandler;
import org.seasar.ymir.scope.annotation.In;
import org.seasar.ymir.scope.annotation.Inject;
import org.seasar.ymir.scope.annotation.Injects;
import org.seasar.ymir.scope.annotation.Ins;
import org.seasar.ymir.scope.annotation.Out;
import org.seasar.ymir.scope.annotation.Outs;
import org.seasar.ymir.scope.annotation.Populate;
import org.seasar.ymir.scope.annotation.RequestParameter;
import org.seasar.ymir.scope.annotation.Resolve;
import org.seasar.ymir.token.constraint.annotation.TokenRequired;
import org.seasar.ymir.util.ClassUtils;
import org.seasar.ymir.util.MethodUtils;

public class AnnotationsMetaData {
    @DefaultAnnotations
    private static final Object DEFAULT_ANNOTATIONS_HOLDER = null;
    public static final AnnotationsMetaData INSTANCE = new AnnotationsMetaData();
    private Map<Class<?>, AnnotationMetaData> metaDataMap_ = new HashMap();

    private AnnotationsMetaData() {
        this.loadDefaultAnnotations();
    }

    void loadDefaultAnnotations() {
        Field holder;
        try {
            holder = AnnotationsMetaData.class.getDeclaredField("DEFAULT_ANNOTATIONS_HOLDER");
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        DefaultAnnotations defaultAnnotations = holder.getAnnotation(DefaultAnnotations.class);
        for (Method method : defaultAnnotations.getClass().getMethods()) {
            if (!Annotation.class.isAssignableFrom(method.getReturnType())) continue;
            this.metaDataMap_.put(method.getReturnType(), new AnnotationMetaData(defaultAnnotations, method));
        }
    }

    public boolean isDefaultValue(Annotation annotation, String attribute, Object value) {
        AnnotationMetaData metaData = this.metaDataMap_.get(annotation.annotationType());
        if (metaData == null) {
            return false;
        }
        return metaData.isDefaultValue(attribute, value);
    }

    boolean equals(Object o1, Object o2) {
        int l2;
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        if (!o1.getClass().isArray()) {
            return o1.equals(o2);
        }
        int l1 = Array.getLength(o1);
        if (l1 != (l2 = Array.getLength(o2))) {
            return false;
        }
        for (int i = 0; i < l1; ++i) {
            if (this.equals(Array.get(o1, i), Array.get(o2, i))) continue;
            return false;
        }
        return true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface DefaultAnnotations {
        public Begin Begin() default @Begin;

        @RequiredAttributes(value={"reenter"})
        public BeginSubConversation BeginSubConversation() default @BeginSubConversation(reenter="");

        @RequiredAttributes(value={"value"})
        public Confirmed Confirmed() default @Confirmed(value={});

        @RequiredAttributes(value={"value"})
        public Confirmeds Confirmeds() default @Confirmeds(value={});

        @RequiredAttributes(value={"component", "type"})
        public ConstraintAnnotation ConstraintAnnotation() default @ConstraintAnnotation(component=RequiredConstraint.class, type=ConstraintType.PERMISSION);

        @RequiredAttributes(value={"name"})
        public Conversation Conversation() default @Conversation(name="");

        public Datetime Datetime() default @Datetime;

        @RequiredAttributes(value={"value"})
        public Datetimes Datetimes() default @Datetimes(value={});

        public ExceptionHandler ExceptionHandler() default @ExceptionHandler;

        public End End() default @End;

        public ForTesting ForTesting() default @ForTesting;

        public HTTP HTTP() default @HTTP;

        public HTTPS HTTPS() default @HTTPS;

        public In In() default @In;

        @RequiredAttributes(value={"value"})
        public Include Include() default @Include(value={});

        public Inject Inject() default @Inject;

        @RequiredAttributes(value={"value"})
        public Injects Injects() default @Injects(value={});

        @RequiredAttributes(value={"value"})
        public Ins Ins() default @Ins(value={});

        @RequiredAttributes(value={"value"})
        public Invoke Invoke() default @Invoke(value=Phase.ACTION_INVOKED);

        public Length Length() default @Length;

        @RequiredAttributes(value={"value"})
        public Lengths Lengths() default @Lengths(value={});

        public Matched Matched() default @Matched;

        @RequiredAttributes(value={"value"})
        public Matcheds Matcheds() default @Matcheds(value={});

        public Numeric Numeric() default @Numeric;

        @RequiredAttributes(value={"value"})
        public Numerics Numerics() default @Numerics(value={});

        public Out Out() default @Out;

        @RequiredAttributes(value={"value"})
        public Outs Outs() default @Outs(value={});

        public PermissionDenied PermissionDenied() default @PermissionDenied;

        public Populate Populate() default @Populate;

        public Published Published() default @Published;

        public RequestParameter RequestParameter() default @RequestParameter;

        public Required Required() default @Required;

        @RequiredAttributes(value={"value"})
        public Requireds Requireds() default @Requireds(value={});

        public Resolve Resolve() default @Resolve;

        public SuppressConstraints SuppressConstraints() default @SuppressConstraints;

        public TokenRequired TokenRequired() default @TokenRequired;

        public TypeConversionHint TypeConversionHint() default @TypeConversionHint;

        public ValidationFailed ValidationFailed() default @ValidationFailed;

        public Validator Validator() default @Validator;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface RequiredAttributes {
        public String[] value();
    }

    class AnnotationMetaData {
        private Annotation defaultAnnotation_;
        private Set<String> requilredAttributeSet_ = new HashSet<String>();

        public AnnotationMetaData(DefaultAnnotations defaultAnnotations, Method method) {
            this.defaultAnnotation_ = (Annotation)MethodUtils.invoke((Method)method, (Object)defaultAnnotations, (Object[])new Object[0]);
            RequiredAttributes requiredAttributes = method.getAnnotation(RequiredAttributes.class);
            if (requiredAttributes != null) {
                this.requilredAttributeSet_.addAll(Arrays.asList(requiredAttributes.value()));
            }
        }

        public boolean isDefaultValue(String attribute, Object value) {
            if (this.requilredAttributeSet_.contains(attribute)) {
                return false;
            }
            return AnnotationsMetaData.this.equals(MethodUtils.invoke((Method)ClassUtils.getMethod(this.defaultAnnotation_.annotationType(), (String)attribute, (Class[])new Class[0]), (Object)this.defaultAnnotation_, (Object[])new Object[0]), value);
        }
    }
}

