/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.kvasir.util.collection.MapProperties;
import org.seasar.ymir.Application;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.action.UpdateAction;
import org.seasar.ymir.extension.creator.action.impl.AbstractAction;
import org.seasar.ymir.extension.creator.util.SourceCreatorUtils;
import org.seasar.ymir.util.StringUtils;

public class CreateConfigurationAction
extends AbstractAction
implements UpdateAction {
    private static final String PARAMPREFIX_KEY = "__ymir__key_";
    private static final Log log = LogFactory.getLog(CreateConfigurationAction.class);

    public CreateConfigurationAction(SourceCreator sourceCreator) {
        super(sourceCreator);
    }

    public Response act(Request request, PathMetaData pathMetaData) {
        if (this.isSkipButtonPushed(request)) {
            return null;
        }
        String subTask = request.getParameter("__ymir__subTask");
        if ("create".equals(subTask)) {
            return this.actCreate(request, pathMetaData);
        }
        return this.actDefault(request, pathMetaData);
    }

    Response actDefault(Request request, PathMetaData pathMetaData) {
        Application application = this.getSourceCreator().getApplication();
        String projectRootFromProperties = SourceCreatorUtils.getProjectRootFromLocalProperties(application);
        if (projectRootFromProperties == null) {
            projectRootFromProperties = SourceCreatorUtils.getProjectRootFromProperties(application);
        }
        boolean shouldSpecifyProjectRoot = projectRootFromProperties != null || application.getProjectRoot() == null;
        boolean existsProjectRoot = projectRootFromProperties != null && new File(projectRootFromProperties).exists();
        boolean canBeEmptyProjectRoot = SourceCreatorUtils.findProjectRootDirectory(application) != null;
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("application", application);
        variableMap.put("setting", this.getSourceCreatorSetting());
        variableMap.put("reconfigured", this.isReconfigured());
        variableMap.put("shouldSpecifyProjectRoot", shouldSpecifyProjectRoot);
        variableMap.put("existsProjectRoot", existsProjectRoot);
        variableMap.put("projectRootFromProperties", projectRootFromProperties);
        variableMap.put("canBeEmptyProjectRoot", canBeEmptyProjectRoot);
        return this.getSourceCreator().getResponseCreator().createResponse("createConfiguration", variableMap);
    }

    boolean isReconfigured() {
        return this.getSourceCreator().getApplication().getFirstRootPackageName() != null;
    }

    Response actCreate(Request request, PathMetaData pathMetaDataf) {
        String method = request.getParameter("__ymir__method");
        if (method == null) {
            return null;
        }
        Application application = this.getSourceCreator().getApplication();
        MapProperties orderedLocalProp = SourceCreatorUtils.readLocalPropertiesInOrder(application);
        MapProperties orderedProp = SourceCreatorUtils.readPropertiesInOrder(application);
        orderedLocalProp.removeProperty("projectRoot");
        TreeSet nameSet = new TreeSet();
        Iterator itr = request.getParameterNames();
        while (itr.hasNext()) {
            nameSet.add(itr.next());
        }
        for (String name : nameSet) {
            if (!name.startsWith(PARAMPREFIX_KEY)) continue;
            Destination destination = Destination.GLOBAL;
            boolean skip = false;
            String key = name.substring(PARAMPREFIX_KEY.length());
            String value = request.getParameter(name).trim();
            if ("projectRoot".equals(key)) {
                destination = Destination.LOCAL;
                if (value.trim().length() == 0) {
                    skip = true;
                    value = SourceCreatorUtils.findProjectRootDirectory(application);
                }
                application.setProjectRoot(value);
            } else if ("extension.sourceCreator.superclass".equals(key)) {
                if (!StringUtils.isEmpty((String)value)) {
                    application.setProperty(key, value);
                    ClassDesc classDesc = this.getSourceCreator().newClassDesc(this.newDescPool(), value, null);
                    this.getSourceCreator().prepareForUpdating(classDesc);
                    this.getSourceCreator().writeEmptyBaseSourceFileIfNotExists(classDesc);
                } else {
                    application.removeProperty(key);
                    skip = true;
                }
            } else {
                application.setProperty(key, value);
            }
            if (skip) continue;
            if (destination == Destination.LOCAL) {
                orderedLocalProp.setProperty(key, value);
                continue;
            }
            if (destination != Destination.GLOBAL) continue;
            orderedProp.setProperty(key, value);
        }
        this.saveProperties(application.getDefaultLocalPropertiesFilePath(), orderedLocalProp);
        this.saveProperties(application.getDefaultPropertiesFilePath(), orderedProp);
        boolean successfullySynchronized = this.synchronizeResources(null);
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", method);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("successfullySynchronized", successfullySynchronized);
        return this.getSourceCreator().getResponseCreator().createResponse("createConfiguration_create", variableMap);
    }

    private void saveProperties(String filePath, MapProperties prop) {
        if (filePath == null) {
            log.error((Object)"Can't save properties: filePath is null");
            return;
        }
        File file = new File(filePath);
        if (!file.exists() && prop.size() == 0) {
            return;
        }
        file.getParentFile().mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            SourceCreatorUtils.writeHeader(fos, null);
            prop.store((OutputStream)fos);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't write property file: " + file.getAbsolutePath());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Destination {
        GLOBAL,
        LOCAL;

    }
}

