/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.kvasir.util.io.IOUtils;
import org.seasar.ymir.Application;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.Request;
import org.seasar.ymir.extension.creator.ClassCreationHintBag;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.SourceCreatorSetting;
import org.seasar.ymir.extension.creator.Template;
import org.seasar.ymir.extension.creator.util.PersistentProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAction {
    private static final String PARAM_BUTTON_SKIP = "__ymir__button_skip";
    public static final String PARAM_SUBTASK = "__ymir__subTask";
    private static final int TIMEOUT_MILLISEC = 3000;
    private static final String SP = System.getProperty("line.separator");
    private static final String RESOURCESYNCHRONIZER_ENCODING = "UTF-8";
    private final Log log_ = LogFactory.getLog(AbstractAction.class);
    private SourceCreator sourceCreator_;

    public AbstractAction(SourceCreator sourceCreator) {
        this.sourceCreator_ = sourceCreator;
    }

    public SourceCreator getSourceCreator() {
        return this.sourceCreator_;
    }

    protected String getSuffix(String name) {
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            return "";
        }
        return name.substring(dot);
    }

    protected String quote(String string) {
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch == '\"' || ch == '\\') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        sb.append('\"');
        return sb.toString();
    }

    protected Parameter[] getParameters(Request request) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (Map.Entry entry : request.getCurrentDispatch().getQueryParameterMap().entrySet()) {
            String name = (String)entry.getKey();
            if (name.startsWith("__ymir__")) continue;
            String[] values = (String[])entry.getValue();
            for (int i = 0; i < values.length; ++i) {
                list.add(new Parameter(name, values[i]));
            }
        }
        return list.toArray(new Parameter[0]);
    }

    protected boolean isSkipButtonPushed(Request request) {
        return request.getParameter(PARAM_BUTTON_SKIP) != null;
    }

    protected HttpMethod getHttpMethod(Request request) {
        return HttpMethod.enumOf((String)request.getParameter("__ymir__method"));
    }

    protected Map<String, Object> newVariableMap() {
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        Application application = this.getSourceCreator().getApplication();
        variableMap.put("sourceCreator", this.getSourceCreator());
        variableMap.put("resourceAutoSynchronized", this.getSourceCreatorSetting().isResourceSynchronized());
        variableMap.put("templateEncoding", application.getTemplateEncoding());
        return variableMap;
    }

    protected boolean synchronizeResources(String[] paths) {
        if (!this.getSourceCreatorSetting().isResourceSynchronized()) {
            return true;
        }
        if (paths != null && paths.length == 0) {
            return true;
        }
        String projectPath = "/" + this.getSourceCreatorSetting().getEclipseProjectName();
        if (paths == null) {
            try {
                this.synchronizeResources0(projectPath);
                return true;
            }
            catch (IOException ignore) {
                return false;
            }
        }
        LinkedHashSet<String> absolutePathSet = new LinkedHashSet<String>();
        for (String path : paths) {
            if (path == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(projectPath);
            if (path.length() > 0 && !path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
            absolutePathSet.add(sb.toString());
        }
        absolutePathSet.add(projectPath + "/" + ".settings");
        try {
            LinkedHashSet<String> absolutePathForRetrySet;
            String[] absolutePaths = absolutePathSet.toArray(new String[0]);
            do {
                absolutePathForRetrySet = new LinkedHashSet<String>();
                for (String absolutePath : this.synchronizeResources0(absolutePaths)) {
                    absolutePathForRetrySet.add(this.getParentPath(absolutePath));
                }
            } while ((absolutePaths = absolutePathForRetrySet.toArray(new String[0])).length > 0);
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    String getParentPath(String path) {
        if (path == null) {
            return null;
        }
        int slash = path.lastIndexOf(47);
        if (slash < 0) {
            return "";
        }
        return path.substring(0, slash);
    }

    protected String[] synchronizeResources0(String ... absolutePaths) throws IOException {
        HashSet<String> okAbsolutePathSet;
        if (absolutePaths != null && absolutePaths.length == 0) {
            return new String[0];
        }
        StringBuilder sb = new StringBuilder().append("refresh?");
        String delim = "";
        for (String absolutePath : absolutePaths) {
            sb.append(delim).append(absolutePath).append("=INFINITE");
            delim = "&";
        }
        URL url = this.getSourceCreatorSetting().constructResourceSynchronizerURL(sb.toString());
        if (url == null) {
            return new String[0];
        }
        InputStream is = null;
        try {
            URLConnection connection = url.openConnection();
            connection.setReadTimeout(3000);
            connection.connect();
            is = connection.getInputStream();
            String response = IOUtils.readString((InputStream)is, (String)RESOURCESYNCHRONIZER_ENCODING, (boolean)false);
            okAbsolutePathSet = new HashSet<String>(Arrays.asList(PropertyUtils.toArray((String)response)));
            if (okAbsolutePathSet.contains("/")) {
                okAbsolutePathSet.add("");
            }
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("Response from " + url + " is:" + SP + response));
            }
        }
        catch (IOException ex) {
            try {
                this.log_.warn((Object)("I/O error occured on a resourceSynchronizing server: " + url), (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        ArrayList<String> ngAbsolutePathList = new ArrayList<String>();
        for (String absolutePath : absolutePaths) {
            if (okAbsolutePathSet.contains(absolutePath)) continue;
            ngAbsolutePathList.add(absolutePath);
        }
        return ngAbsolutePathList.toArray(new String[0]);
    }

    protected void pause(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void openJavaCodeInEclipseEditor(String className) {
        URL url;
        if (!this.getSourceCreatorSetting().isResourceSynchronized()) {
            return;
        }
        if (className == null) {
            return;
        }
        try {
            url = this.getSourceCreatorSetting().constructResourceSynchronizerURL("select?project=" + URLEncoder.encode(this.getSourceCreatorSetting().getEclipseProjectName(), RESOURCESYNCHRONIZER_ENCODING) + "&classname=" + URLEncoder.encode(className, RESOURCESYNCHRONIZER_ENCODING) + "&openInEditor=true&line=3");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Can't happen!", ex);
        }
        this.connectToEclipse(url);
    }

    protected void openResourceInEclipseEditor(String path) {
        URL url;
        if (!this.getSourceCreatorSetting().isResourceSynchronized()) {
            return;
        }
        if (path == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        String projectName = this.getSourceCreatorSetting().getEclipseProjectName();
        if (projectName == null) {
            this.log_.warn((Object)"Do nothing because property 'extension.sourceCreator.eclipse.projectName' is not specified in app.properties");
            return;
        }
        sb.append(projectName);
        if (projectName.endsWith("/")) {
            if (path.startsWith("/")) {
                sb.append(path.substring(1));
            } else {
                sb.append(path);
            }
        } else {
            if (!path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
        }
        try {
            url = this.getSourceCreatorSetting().constructResourceSynchronizerURL("resource?path=" + URLEncoder.encode(sb.toString(), RESOURCESYNCHRONIZER_ENCODING));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Can't happen!", ex);
        }
        this.connectToEclipse(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectToEclipse(URL url) {
        InputStream is;
        block5: {
            if (url == null) {
                return;
            }
            is = null;
            try {
                URLConnection connection = url.openConnection();
                connection.setReadTimeout(3000);
                connection.connect();
                is = connection.getInputStream();
                String response = IOUtils.readString((InputStream)is, (String)RESOURCESYNCHRONIZER_ENCODING, (boolean)false);
                if (!this.log_.isDebugEnabled()) break block5;
                this.log_.debug((Object)("Response from " + url + " is:" + SP + response));
            }
            catch (IOException ex) {
                try {
                    this.log_.warn((Object)("I/O error occured on a resourceSynchronizing server: " + url), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    protected String getRootPackagePath() {
        String sourcePath = this.adjustPath(this.getSourceCreator().getApplication().getSourceDirectory());
        if (sourcePath == null) {
            return null;
        }
        String rootPackageName = this.getSourceCreator().getApplication().getFirstRootPackageName();
        if (rootPackageName == null) {
            return sourcePath;
        }
        return sourcePath + "/" + rootPackageName.replace('.', '/');
    }

    protected String getResourcesPath() {
        return this.adjustPath(this.getSourceCreator().getApplication().getResourcesDirectory());
    }

    protected String getWebappSourceRootPath() {
        return this.adjustPath(this.getSourceCreator().getApplication().getWebappSourceRoot());
    }

    protected String getPath(Template template) {
        if (template == null) {
            return null;
        }
        String webappSourceRootPath = this.getWebappSourceRootPath();
        if (webappSourceRootPath == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(webappSourceRootPath);
        String templatePath = template.getPath();
        if (!templatePath.startsWith("/")) {
            sb.append("/");
        }
        sb.append(templatePath);
        return sb.toString();
    }

    protected String adjustPath(String filePath) {
        if (filePath == null) {
            return null;
        }
        filePath = filePath.replace('\\', '/');
        String projectRoot = this.getProjectRoot();
        if (projectRoot == null) {
            return null;
        }
        if (filePath.startsWith(projectRoot)) {
            return filePath.substring(projectRoot.length());
        }
        return null;
    }

    protected String getProjectRoot() {
        String projectRoot = this.getSourceCreator().getApplication().getProjectRoot();
        if (projectRoot == null || projectRoot.length() == 0) {
            return null;
        }
        return projectRoot.replace('\\', '/');
    }

    protected SourceCreatorSetting getSourceCreatorSetting() {
        return this.sourceCreator_.getSourceCreatorSetting();
    }

    protected void updateMapping(PathMetaData ... pathMetaDatas) {
        PersistentProperties props = this.sourceCreator_.getMappingProperties();
        for (PathMetaData pathMetaData : pathMetaDatas) {
            props.setProperty(pathMetaData.getPath().replace('/', '%'), pathMetaData.getClassName());
            props.setProperty(pathMetaData.getClassName(), pathMetaData.getPath());
        }
        props.save();
    }

    protected DescPool newDescPool() {
        return this.newDescPool(null);
    }

    protected DescPool newDescPool(ClassCreationHintBag hintBag) {
        return DescPool.newInstance(this.sourceCreator_, hintBag);
    }

    public static class Parameter {
        private String name_;
        private String value_;

        public Parameter(String name, String value) {
            this.name_ = name;
            this.value_ = value;
        }

        public String getName() {
            return this.name_;
        }

        public String getValue() {
            return this.value_;
        }
    }
}

