/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator;

import java.util.Set;
import java.util.TreeSet;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassDescSet;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.ParameterDesc;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.util.DescUtils;
import org.seasar.ymir.util.ClassUtils;

public class DescValidator {
    private DescValidator() {
    }

    public static Result validate(ClassDesc classDesc, ClassDescSet classDescSet) {
        return DescValidator.validate(classDesc, classDescSet, new Result());
    }

    static Result validate(ClassDesc classDesc, ClassDescSet classDescSet, Result result) {
        PropertyDesc[] pds = classDesc.getPropertyDescs();
        for (int i = 0; i < pds.length; ++i) {
            DescValidator.validate(pds[i], classDescSet, result);
        }
        MethodDesc[] mds = classDesc.getMethodDescs();
        for (int i = 0; i < mds.length; ++i) {
            DescValidator.validate(mds[i], classDescSet, result);
        }
        return result;
    }

    static Result validate(PropertyDesc propertyDesc, ClassDescSet classDescSet, Result result) {
        return DescValidator.validate(propertyDesc.getTypeDesc(), classDescSet, result);
    }

    static Result validate(MethodDesc methodDesc, ClassDescSet classDescSet, Result result) {
        DescValidator.validate(methodDesc.getReturnTypeDesc(), classDescSet, result);
        ParameterDesc[] parameterDescs = methodDesc.getParameterDescs();
        for (int i = 0; i < parameterDescs.length; ++i) {
            DescValidator.validate(parameterDescs[i], classDescSet, result);
        }
        return result;
    }

    static Result validate(ParameterDesc parameterDesc, ClassDescSet classDescSet, Result result) {
        return DescValidator.validate(parameterDesc.getTypeDesc(), classDescSet, result);
    }

    public static Result validate(TypeDesc typeDesc, ClassDescSet classDescSet) {
        return DescValidator.validate(typeDesc, classDescSet, new Result());
    }

    static Result validate(TypeDesc typeDesc, ClassDescSet classDescSet, Result result) {
        String className = typeDesc.getComponentClassDesc().getName();
        if (!DescValidator.isValidClassName(className, classDescSet)) {
            result.addClassName(className);
        }
        return result;
    }

    public static boolean isValidClassName(String className, ClassDescSet classDescSet) {
        if (Void.TYPE.getName().equals(className)) {
            return true;
        }
        if (ClassUtils.isPrimitive((String)className)) {
            return true;
        }
        if (classDescSet != null && classDescSet.contains(className)) {
            return true;
        }
        return DescUtils.getClass(className) != null;
    }

    public static class Result {
        private Set<String> classNameSet_ = new TreeSet<String>();

        public void addClassName(String className) {
            this.classNameSet_.add(className);
        }

        public String[] getClassNames() {
            return this.classNameSet_.toArray(new String[0]);
        }

        public boolean isValid() {
            return this.classNameSet_.isEmpty();
        }
    }
}

