/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.font.LineMetrics;

public class GVTLineMetrics {
    protected float ascent;
    protected int baselineIndex;
    protected float[] baselineOffsets;
    protected float descent;
    protected float height;
    protected float leading;
    protected int numChars;
    protected float strikethroughOffset;
    protected float strikethroughThickness;
    protected float underlineOffset;
    protected float underlineThickness;
    protected float overlineOffset;
    protected float overlineThickness;

    public GVTLineMetrics(LineMetrics lineMetrics) {
        this.ascent = lineMetrics.getAscent();
        this.baselineIndex = lineMetrics.getBaselineIndex();
        this.baselineOffsets = lineMetrics.getBaselineOffsets();
        this.descent = lineMetrics.getDescent();
        this.height = lineMetrics.getHeight();
        this.leading = lineMetrics.getLeading();
        this.numChars = lineMetrics.getNumChars();
        this.strikethroughOffset = lineMetrics.getStrikethroughOffset();
        this.strikethroughThickness = lineMetrics.getStrikethroughThickness();
        this.underlineOffset = lineMetrics.getUnderlineOffset();
        this.underlineThickness = lineMetrics.getUnderlineThickness();
        this.overlineOffset = -this.ascent;
        this.overlineThickness = this.underlineThickness;
    }

    public GVTLineMetrics(LineMetrics lineMetrics, float f) {
        this.ascent = lineMetrics.getAscent() * f;
        this.baselineIndex = lineMetrics.getBaselineIndex();
        this.baselineOffsets = lineMetrics.getBaselineOffsets();
        int n = 0;
        while (n < this.baselineOffsets.length) {
            int n2 = n++;
            this.baselineOffsets[n2] = this.baselineOffsets[n2] * f;
        }
        this.descent = lineMetrics.getDescent() * f;
        this.height = lineMetrics.getHeight() * f;
        this.leading = lineMetrics.getLeading();
        this.numChars = lineMetrics.getNumChars();
        this.strikethroughOffset = lineMetrics.getStrikethroughOffset() * f;
        this.strikethroughThickness = lineMetrics.getStrikethroughThickness() * f;
        this.underlineOffset = lineMetrics.getUnderlineOffset() * f;
        this.underlineThickness = lineMetrics.getUnderlineThickness() * f;
        this.overlineOffset = -this.ascent;
        this.overlineThickness = this.underlineThickness;
    }

    public GVTLineMetrics(float f, int n, float[] fArray, float f2, float f3, float f4, int n2, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.ascent = f;
        this.baselineIndex = n;
        this.baselineOffsets = fArray;
        this.descent = f2;
        this.height = f3;
        this.leading = f4;
        this.numChars = n2;
        this.strikethroughOffset = f5;
        this.strikethroughThickness = f6;
        this.underlineOffset = f7;
        this.underlineThickness = f8;
        this.overlineOffset = f9;
        this.overlineThickness = f10;
    }

    public float getAscent() {
        return this.ascent;
    }

    public int getBaselineIndex() {
        return this.baselineIndex;
    }

    public float[] getBaselineOffsets() {
        return this.baselineOffsets;
    }

    public float getDescent() {
        return this.descent;
    }

    public float getHeight() {
        return this.height;
    }

    public float getLeading() {
        return this.leading;
    }

    public int getNumChars() {
        return this.numChars;
    }

    public float getStrikethroughOffset() {
        return this.strikethroughOffset;
    }

    public float getStrikethroughThickness() {
        return this.strikethroughThickness;
    }

    public float getUnderlineOffset() {
        return this.underlineOffset;
    }

    public float getUnderlineThickness() {
        return this.underlineThickness;
    }

    public float getOverlineOffset() {
        return this.overlineOffset;
    }

    public float getOverlineThickness() {
        return this.overlineThickness;
    }
}

