/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.util.Iterator;
import java.util.Vector;

public class TileBlock {
    int occX;
    int occY;
    int occW;
    int occH;
    int xOff;
    int yOff;
    int w;
    int h;
    int benefit;
    boolean[] occupied;

    TileBlock(int n, int n2, int n3, int n4, boolean[] blArray, int n5, int n6, int n7, int n8) {
        this.occX = n;
        this.occY = n2;
        this.occW = n3;
        this.occH = n4;
        this.xOff = n5;
        this.yOff = n6;
        this.w = n7;
        this.h = n8;
        this.occupied = blArray;
        for (int i = 0; i < n8; ++i) {
            for (int j = 0; j < n7; ++j) {
                if (blArray[j + n5 + n3 * (i + n6)]) continue;
                ++this.benefit;
            }
        }
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.occH; ++i) {
            for (int j = 0; j < this.occW + 1; ++j) {
                string = j == this.xOff || j == this.xOff + this.w ? (i == this.yOff || i == this.yOff + this.h - 1 ? string + "+" : (i > this.yOff && i < this.yOff + this.h - 1 ? string + "|" : string + " ")) : (i == this.yOff && j > this.xOff && j < this.xOff + this.w ? string + "-" : (i == this.yOff + this.h - 1 && j > this.xOff && j < this.xOff + this.w ? string + "_" : string + " "));
                if (j == this.occW) continue;
                string = this.occupied[j + i * this.occW] ? string + "*" : string + ".";
            }
            string = string + "\n";
        }
        return string;
    }

    int getXLoc() {
        return this.occX + this.xOff;
    }

    int getYLoc() {
        return this.occY + this.yOff;
    }

    int getWidth() {
        return this.w;
    }

    int getHeight() {
        return this.h;
    }

    int getBenefit() {
        return this.benefit;
    }

    int getWork() {
        return this.w * this.h + 1;
    }

    static int getWork(TileBlock[] tileBlockArray) {
        int n = 0;
        for (int i = 0; i < tileBlockArray.length; ++i) {
            n += tileBlockArray[i].getWork();
        }
        return n;
    }

    TileBlock[] getBestSplit() {
        if (this.simplify()) {
            return null;
        }
        if (this.benefit == this.w * this.h) {
            return new TileBlock[]{this};
        }
        return this.splitOneGo();
    }

    public TileBlock[] splitOneGo() {
        int n;
        boolean[] blArray = (boolean[])this.occupied.clone();
        Vector<TileBlock> vector = new Vector<TileBlock>();
        for (int i = this.yOff; i < this.yOff + this.h; ++i) {
            for (int j = this.xOff; j < this.xOff + this.w; ++j) {
                int n2;
                if (blArray[j + i * this.occW]) continue;
                n = this.xOff + this.w - j;
                for (n2 = j; n2 < j + n; ++n2) {
                    if (blArray[n2 + i * this.occW]) {
                        n = n2 - j;
                        continue;
                    }
                    blArray[n2 + i * this.occW] = true;
                }
                n2 = 1;
                for (int k = i + 1; k < this.yOff + this.h; ++k) {
                    int n3;
                    for (n3 = j; n3 < j + n && !blArray[n3 + k * this.occW]; ++n3) {
                    }
                    if (n3 != j + n) break;
                    for (n3 = j; n3 < j + n; ++n3) {
                        blArray[n3 + k * this.occW] = true;
                    }
                    ++n2;
                }
                vector.add(new TileBlock(this.occX, this.occY, this.occW, this.occH, this.occupied, j, i, n, n2));
                j += n - 1;
            }
        }
        TileBlock[] tileBlockArray = new TileBlock[vector.size()];
        Iterator iterator = vector.iterator();
        n = 0;
        while (iterator.hasNext()) {
            tileBlockArray[n++] = (TileBlock)iterator.next();
        }
        return tileBlockArray;
    }

    public boolean simplify() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.h; ++n2) {
            for (n = 0; n < this.w && this.occupied[n + this.xOff + this.occW * (n2 + this.yOff)]; ++n) {
            }
            if (n != this.w) break;
            ++this.yOff;
            --n2;
            --this.h;
        }
        if (this.h == 0) {
            return true;
        }
        for (n2 = this.h - 1; n2 >= 0; --n2) {
            for (n = 0; n < this.w && this.occupied[n + this.xOff + this.occW * (n2 + this.yOff)]; ++n) {
            }
            if (n != this.w) break;
            --this.h;
        }
        for (n2 = 0; n2 < this.w; ++n2) {
            for (n = 0; n < this.h && this.occupied[n2 + this.xOff + this.occW * (n + this.yOff)]; ++n) {
            }
            if (n != this.h) break;
            ++this.xOff;
            --n2;
            --this.w;
        }
        for (n2 = this.w - 1; n2 >= 0; --n2) {
            for (n = 0; n < this.h && this.occupied[n2 + this.xOff + this.occW * (n + this.yOff)]; ++n) {
            }
            if (n != this.h) break;
            --this.w;
        }
        return false;
    }
}

