/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public class FontEntityAtom
extends RecordAtom {
    private byte[] _header;
    private byte[] _recdata;

    protected FontEntityAtom(byte[] source, int start, int len) {
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._recdata = new byte[len - 8];
        System.arraycopy(source, start + 8, this._recdata, 0, len - 8);
    }

    protected FontEntityAtom() {
        this._recdata = new byte[68];
        this._header = new byte[8];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._recdata.length);
    }

    public long getRecordType() {
        return RecordTypes.FontEntityAtom.typeID;
    }

    public String getFontName() {
        String name = null;
        try {
            for (int i = 0; i < 64; i += 2) {
                if (this._recdata[i] != 0 || this._recdata[i + 1] != 0) continue;
                name = new String(this._recdata, 0, i, "UTF-16LE");
                break;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return name;
    }

    public void setFontName(String name) {
        if (!name.endsWith("\u0000")) {
            name = name + "\u0000";
        }
        if (name.length() > 32) {
            throw new RuntimeException("The length of the font name, including null termination, must not exceed 32 characters");
        }
        try {
            byte[] bytes = name.getBytes("UTF-16LE");
            System.arraycopy(bytes, 0, this._recdata, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void setFontIndex(int idx) {
        LittleEndian.putShort(this._header, 0, (short)idx);
    }

    protected int getFontIndex() {
        return LittleEndian.getShort(this._header, 0);
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._recdata);
    }
}

