/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;

public class MimePartDataSource
implements DataSource,
MessageAware {
    private final MimePart part;

    public MimePartDataSource(MimePart part) {
        this.part = part;
    }

    public InputStream getInputStream() throws IOException {
        try {
            InputStream stream;
            if (this.part instanceof MimeMessage) {
                stream = ((MimeMessage)this.part).getContentStream();
            } else if (this.part instanceof MimeBodyPart) {
                stream = ((MimeBodyPart)this.part).getContentStream();
            } else {
                throw new MessagingException("Unknown part");
            }
            String encoding = this.part.getEncoding();
            return encoding == null ? stream : MimeUtility.decode(stream, encoding);
        }
        catch (MessagingException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    public String getContentType() {
        try {
            return this.part.getContentType();
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public String getName() {
        return "";
    }

    public synchronized MessageContext getMessageContext() {
        return new MessageContext(this.part);
    }
}

