/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.tools.SimpleResultSet;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class ValueResultSet
extends Value {
    private final ResultSet result;

    private ValueResultSet(ResultSet rs) {
        this.result = rs;
    }

    public static ValueResultSet get(ResultSet rs) throws SQLException {
        ValueResultSet val = new ValueResultSet(rs);
        return val;
    }

    public static ValueResultSet getCopy(ResultSet rs, int maxrows) throws SQLException {
        int i;
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        SimpleResultSet simple = new SimpleResultSet();
        ValueResultSet val = new ValueResultSet(simple);
        for (i = 0; i < columnCount; ++i) {
            String name = meta.getColumnLabel(i + 1);
            int sqlType = meta.getColumnType(i + 1);
            int precision = meta.getPrecision(i + 1);
            int scale = meta.getScale(i + 1);
            simple.addColumn(name, sqlType, precision, scale);
        }
        for (i = 0; i < maxrows && rs.next(); ++i) {
            Object[] list = new Object[columnCount];
            for (int j = 0; j < columnCount; ++j) {
                list[j] = rs.getObject(j + 1);
            }
            simple.addRow(list);
        }
        return val;
    }

    public int getType() {
        return 18;
    }

    public long getPrecision() {
        return 0L;
    }

    public int getDisplaySize() {
        return 100;
    }

    public String getString() throws SQLException {
        StringBuffer buff = new StringBuffer();
        buff.append("(");
        this.result.beforeFirst();
        ResultSetMetaData meta = this.result.getMetaData();
        int columnCount = meta.getColumnCount();
        int i = 0;
        while (this.result.next()) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append('(');
            for (int j = 0; j < columnCount; ++j) {
                if (j > 0) {
                    buff.append(", ");
                }
                int t = DataType.convertSQLTypeToValueType(meta.getColumnType(j + 1));
                Value v = DataType.readValue(null, this.result, j + 1, t);
                buff.append(v.getString());
            }
            buff.append(')');
            ++i;
        }
        buff.append(")");
        this.result.beforeFirst();
        return buff.toString();
    }

    protected int compareSecure(Value v, CompareMode mode) throws SQLException {
        throw Message.getUnsupportedException();
    }

    protected boolean isEqual(Value v) {
        return false;
    }

    public Object getObject() throws SQLException {
        return this.result;
    }

    public ResultSet getResultSet() {
        return this.result;
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public String getSQL() {
        return "";
    }
}

