/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.constraint.Constraint;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.StringUtils;

public class ConstraintUnique
extends Constraint {
    private Index index;
    private boolean indexOwner;
    private Column[] columns;

    public ConstraintUnique(Schema schema, int id, String name, Table table) {
        super(schema, id, name, table);
    }

    public String getConstraintType() {
        return "UNIQUE";
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        return this.getCreateSQLForCopy(table, quotedName, true);
    }

    public String getCreateSQLForCopy(Table table, String quotedName, boolean internalIndex) {
        StringBuffer buff = new StringBuffer();
        buff.append("ALTER TABLE ");
        buff.append(table.getSQL());
        buff.append(" ADD CONSTRAINT ");
        buff.append(quotedName);
        if (this.comment != null) {
            buff.append(" COMMENT ");
            buff.append(StringUtils.quoteStringSQL(this.comment));
        }
        buff.append(" UNIQUE(");
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(Parser.quoteIdentifier(this.columns[i].getName()));
        }
        buff.append(")");
        if (internalIndex && this.indexOwner && table == this.table) {
            buff.append(" INDEX ");
            buff.append(this.index.getSQL());
        }
        return buff.toString();
    }

    public String getShortDescription() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getName());
        buff.append(": ");
        buff.append("UNIQUE(");
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(Parser.quoteIdentifier(this.columns[i].getName()));
        }
        buff.append(")");
        return buff.toString();
    }

    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(), false);
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public void setIndex(Index index, boolean isOwner) {
        this.index = index;
        this.indexOwner = isOwner;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.table.removeConstraint(this);
        if (this.indexOwner) {
            this.database.removeSchemaObject(session, this.index);
        }
        this.index = null;
        this.columns = null;
        this.table = null;
        this.invalidate();
    }

    public void checkRow(Session session, Table t, Row oldRow, Row newRow) {
    }

    public boolean usesIndex(Index idx) {
        return idx == this.index;
    }

    public boolean containsColumn(Column col) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] != col) continue;
            return true;
        }
        return false;
    }

    public boolean isBefore() {
        return true;
    }

    public void checkExistingData(Session session) throws SQLException {
    }
}

