/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

public class GrantRevoke
extends DefineCommand {
    public static final int GRANT = 0;
    public static final int REVOKE = 1;
    private ObjectArray roleNames;
    private int operationType;
    private int rightMask;
    private ObjectArray tables = new ObjectArray();
    private RightOwner grantee;

    public GrantRevoke(Session session) {
        super(session);
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public void addRight(int right) {
        this.rightMask |= right;
    }

    public void addRoleName(String roleName) {
        if (this.roleNames == null) {
            this.roleNames = new ObjectArray();
        }
        this.roleNames.add(roleName);
    }

    public void setGranteeName(String granteeName) throws JdbcSQLException {
        Database db = this.session.getDatabase();
        this.grantee = db.findUser(granteeName);
        if (this.grantee == null) {
            this.grantee = db.findRole(granteeName);
            if (this.grantee == null) {
                throw Message.getSQLException(90071, granteeName);
            }
        }
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        if (this.roleNames != null) {
            for (int i = 0; i < this.roleNames.size(); ++i) {
                String name = (String)this.roleNames.get(i);
                Role grantedRole = db.findRole(name);
                if (grantedRole == null) {
                    throw Message.getSQLException(90070, name);
                }
                if (this.operationType == 0) {
                    this.grantRole(grantedRole);
                    continue;
                }
                if (this.operationType == 1) {
                    this.revokeRole(grantedRole);
                    continue;
                }
                throw Message.getInternalError("type=" + this.operationType);
            }
        } else if (this.operationType == 0) {
            this.grantRight();
        } else if (this.operationType == 1) {
            this.revokeRight();
        } else {
            throw Message.getInternalError("type=" + this.operationType);
        }
        return 0;
    }

    private void grantRight() throws SQLException {
        Database db = this.session.getDatabase();
        for (int i = 0; i < this.tables.size(); ++i) {
            Table table = (Table)this.tables.get(i);
            Right right = this.grantee.getRightForTable(table);
            if (right == null) {
                int id = this.getObjectId(true, true);
                right = new Right(db, id, this.grantee, this.rightMask, table);
                this.grantee.grantRight(table, right);
                db.addDatabaseObject(this.session, right);
                continue;
            }
            right.setRightMask(right.getRightMask() | this.rightMask);
        }
    }

    private void grantRole(Role grantedRole) throws SQLException {
        Role granteeRole;
        if (this.grantee.isRoleGranted(grantedRole)) {
            throw Message.getSQLException(90074, grantedRole.getSQL());
        }
        if (this.grantee instanceof Role && grantedRole.isRoleGranted(granteeRole = (Role)this.grantee)) {
            throw Message.getSQLException(90074, grantedRole.getSQL());
        }
        Database db = this.session.getDatabase();
        int id = this.getObjectId(true, true);
        Right right = new Right(db, id, this.grantee, grantedRole);
        db.addDatabaseObject(this.session, right);
        this.grantee.grantRole(this.session, grantedRole, right);
    }

    private void revokeRight() throws SQLException {
        for (int i = 0; i < this.tables.size(); ++i) {
            Table table = (Table)this.tables.get(i);
            Right right = this.grantee.getRightForTable(table);
            if (right == null) {
                throw Message.getSQLException(90073);
            }
            int mask = right.getRightMask();
            if ((mask & this.rightMask) != this.rightMask) {
                throw Message.getSQLException(90073);
            }
            int newRight = mask ^ this.rightMask;
            Database db = this.session.getDatabase();
            if (newRight == 0) {
                db.removeDatabaseObject(this.session, right);
                continue;
            }
            right.setRightMask(newRight);
            db.update(this.session, right);
        }
    }

    private void revokeRole(Role grantedRole) throws SQLException {
        Right right = this.grantee.getRightForRole(grantedRole);
        if (right == null) {
            throw Message.getSQLException(90073);
        }
        Database db = this.session.getDatabase();
        db.removeDatabaseObject(this.session, right);
    }

    public boolean isTransactional() {
        return false;
    }

    public void addTable(Table table) {
        this.tables.add(table);
    }
}

