/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layout.TextState;

public class PageNumber
extends FObj {
    float red;
    float green;
    float blue;
    int wrapOption;
    int whiteSpaceCollapse;
    TextState ts;

    public PageNumber(FObj parent, PropertyList propertyList, String systemId, int line, int column) {
        super(parent, propertyList, systemId, line, column);
    }

    public String getName() {
        return "fo:page-number";
    }

    public int layout(Area area) throws FOPException {
        if (!(area instanceof BlockArea)) {
            this.log.warn("page-number outside block area");
            return 1;
        }
        if (this.marker == -1000) {
            AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
            AuralProps mAurProps = this.propMgr.getAuralProps();
            BorderAndPadding bap = this.propMgr.getBorderAndPadding();
            BackgroundProps bProps = this.propMgr.getBackgroundProps();
            MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
            RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
            ColorType c = this.properties.get("color").getColorType();
            this.red = c.red();
            this.green = c.green();
            this.blue = c.blue();
            this.wrapOption = this.properties.get("wrap-option").getEnum();
            this.whiteSpaceCollapse = this.properties.get("white-space-collapse").getEnum();
            this.ts = new TextState();
            this.marker = 0;
            String id = this.properties.get("id").getString();
            try {
                area.getIDReferences().initializeID(id, area);
            }
            catch (FOPException e) {
                if (!e.isLocationSet()) {
                    e.setLocation(this.systemId, this.line, this.column);
                }
                throw e;
            }
        }
        String p = area.getPage().getFormattedNumber();
        this.marker = FOText.addText((BlockArea)area, this.propMgr.getFontState(area.getFontInfo()), this.red, this.green, this.blue, this.wrapOption, null, this.whiteSpaceCollapse, p.toCharArray(), 0, p.length(), this.ts, 9);
        return 1;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new PageNumber(parent, propertyList, systemId, line, column);
        }
    }
}

