/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PieceDescriptor;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;

public class TextPieceTable {
    protected ArrayList _textPieces = new ArrayList();
    int _cpMin;

    public TextPieceTable() {
    }

    public TextPieceTable(byte[] documentStream, byte[] tableStream, int offset, int size, int fcMin) throws UnsupportedEncodingException {
        PlexOfCps pieceTable = new PlexOfCps(tableStream, offset, size, PieceDescriptor.getSizeInBytes());
        int length = pieceTable.length();
        PieceDescriptor[] pieces = new PieceDescriptor[length];
        for (int x = 0; x < length; ++x) {
            GenericPropertyNode node = pieceTable.getProperty(x);
            pieces[x] = new PieceDescriptor(node.getBytes(), 0);
        }
        int firstPieceFilePosition = pieces[0].getFilePosition();
        this._cpMin = firstPieceFilePosition - fcMin;
        for (int x = 0; x < pieces.length; ++x) {
            int start = pieces[x].getFilePosition();
            GenericPropertyNode node = pieceTable.getProperty(x);
            int nodeStart = node.getStart();
            boolean unicode = pieces[x].isUnicode();
            int multiple = 1;
            if (unicode) {
                multiple = 2;
            }
            int nodeEnd = (node.getEnd() - nodeStart) * multiple + nodeStart;
            int textSize = nodeEnd - nodeStart;
            byte[] buf = new byte[textSize];
            System.arraycopy(documentStream, start, buf, 0, textSize);
            int startFilePosition = start - firstPieceFilePosition;
            this._textPieces.add(new TextPiece(startFilePosition, startFilePosition + textSize, buf, pieces[x], node.getStart()));
        }
    }

    public int getCpMin() {
        return this._cpMin;
    }

    public List getTextPieces() {
        return this._textPieces;
    }

    public byte[] writeTo(HWPFOutputStream docStream) throws IOException {
        PlexOfCps textPlex = new PlexOfCps(PieceDescriptor.getSizeInBytes());
        int size = this._textPieces.size();
        int bumpDown = 0;
        for (int x = 0; x < size; ++x) {
            TextPiece next = (TextPiece)this._textPieces.get(x);
            PieceDescriptor pd = next.getPieceDescriptor();
            int offset = docStream.getOffset();
            int mod = offset % 512;
            if (mod != 0) {
                mod = 512 - mod;
                byte[] buf = new byte[mod];
                docStream.write(buf);
            }
            pd.setFilePosition(docStream.getOffset());
            docStream.write(next.getRawBytes());
            int nodeStart = next.getStart();
            int multiple = 1;
            if (pd.isUnicode()) {
                multiple = 2;
            }
            textPlex.addProperty(new GenericPropertyNode(nodeStart - bumpDown, (next.getEnd() - nodeStart) / multiple + nodeStart - bumpDown, pd.toByteArray()));
            if (!pd.isUnicode()) continue;
            bumpDown += (next.getEnd() - nodeStart) / multiple;
        }
        return textPlex.toByteArray();
    }

    public int adjustForInsert(int listIndex, int length) {
        TextPiece tp;
        int size = this._textPieces.size();
        tp.setEnd(tp.getEnd() + (length *= (tp = (TextPiece)this._textPieces.get(listIndex)).usesUnicode() ? 2 : 1));
        for (int x = listIndex + 1; x < size; ++x) {
            tp = (TextPiece)this._textPieces.get(x);
            tp.setStart(tp.getStart() + length);
            tp.setEnd(tp.getEnd() + length);
        }
        return length;
    }

    public boolean equals(Object o) {
        TextPieceTable tpt = (TextPieceTable)o;
        int size = tpt._textPieces.size();
        if (size == this._textPieces.size()) {
            for (int x = 0; x < size; ++x) {
                if (tpt._textPieces.get(x).equals(this._textPieces.get(x))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

