/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

public class BitField {
    private long[] data = new long[10];
    private static final int ADDRESS_BITS = 6;
    private static final int BITS = 64;
    private static final int ADDRESS_MASK = 63;

    public int getLastSetBit() {
        for (int i = (this.data.length << 6) - 1; i >= 0; --i) {
            if (!this.get(i)) continue;
            return i;
        }
        return -1;
    }

    public int nextSetBit(int fromIndex) {
        int max = this.data.length;
        int maxAddress = this.data.length << 6;
        for (int i = fromIndex >> 6; i < max; ++i) {
            if (this.data[i] == 0L) continue;
            for (int j = Math.max(fromIndex, i << 6); j < maxAddress; ++j) {
                if (!this.get(j)) continue;
                return j;
            }
        }
        return -1;
    }

    public int nextClearBit(int fromIndex) {
        int max = this.data.length;
        for (int i = fromIndex >> 6; i < max; ++i) {
            if (this.data[i] == -1L) continue;
            int j = Math.max(fromIndex, i << 6);
            while (this.get(j)) {
                ++j;
            }
            return j;
        }
        return fromIndex;
    }

    public long getLong(int i) {
        int addr = this.getAddress(i);
        if (addr >= this.data.length) {
            return 0L;
        }
        return this.data[addr];
    }

    public boolean get(int i) {
        int addr = this.getAddress(i);
        if (addr >= this.data.length) {
            return false;
        }
        return (this.data[addr] & this.getBitMask(i)) != 0L;
    }

    public void set(int i) {
        int addr = this.getAddress(i);
        this.checkCapacity(addr);
        int n = addr;
        this.data[n] = this.data[n] | this.getBitMask(i);
    }

    public void clear(int i) {
        int addr = this.getAddress(i);
        if (addr >= this.data.length) {
            return;
        }
        int n = addr;
        this.data[n] = this.data[n] & (this.getBitMask(i) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private int getAddress(int i) {
        return i >> 6;
    }

    private long getBitMask(int i) {
        return 1L << (i & 0x3F);
    }

    private void checkCapacity(int size) {
        while (size >= this.data.length) {
            int newSize = this.data.length == 0 ? 1 : this.data.length * 2;
            long[] d = new long[newSize];
            System.arraycopy(this.data, 0, d, 0, this.data.length);
            this.data = d;
        }
    }

    public void setRange(int start, int len, boolean value) {
        int end = start + len;
        while (start < end) {
            this.set(start, value);
            ++start;
        }
    }

    private void set(int i, boolean value) {
        if (value) {
            this.set(i);
        } else {
            this.clear(i);
        }
    }
}

