/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.tags;

import java.util.Collection;
import java.util.Map;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.controller.FormWrapper;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.tags.FormTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TagUtils {
    private static final Logger logger = LoggerFactory.getLogger(TagUtils.class);
    public static final Object REMOVE_ATTRIBUTE = new Object();

    TagUtils() {
    }

    public static ActionErrors errors(JspContext context) {
        return (ActionErrors)context.getAttribute("errors", 2);
    }

    private static Object[] paramValues(JspContext context, String name) {
        Map valuesMap = (Map)Map.class.cast(context.getAttribute("org.seasar.cubby.params", 2));
        Object[] values = valuesMap == null || !valuesMap.containsKey(name) ? new Object[]{} : (Object[])valuesMap.get(name);
        return values;
    }

    public static Object[] multipleFormValues(JspContext context, FormWrapper formWrapper, String name) {
        return TagUtils.multipleFormValues(context, formWrapper, name, null);
    }

    public static Object[] multipleFormValues(JspContext context, FormWrapper formWrapper, String name, String checkedValue) {
        Object[] values;
        if (TagUtils.isValidationFail(context)) {
            values = TagUtils.paramValues(context, name);
        } else if (checkedValue != null) {
            values = new Object[]{checkedValue};
        } else {
            if (!formWrapper.hasValues(name)) {
                if (logger.isDebugEnabled()) {
                    logger.debug(LogMessages.format("DCUB0023", name));
                }
                return null;
            }
            values = formWrapper.getValues(name);
        }
        return values;
    }

    public static Object formValue(JspContext context, FormWrapper formWrapper, String name, Integer index, Object specifiedValue) {
        Object value;
        if (TagUtils.isValidationFail(context)) {
            if (specifiedValue == null) {
                Object[] values = TagUtils.paramValues(context, name);
                value = TagUtils.value(values, index);
            } else {
                Object[] values = TagUtils.paramValues(context, name);
                value = values.length == 0 ? specifiedValue : TagUtils.value(values, index);
            }
        } else if (specifiedValue != null) {
            value = specifiedValue;
        } else {
            if (!formWrapper.hasValues(name)) {
                logger.debug(LogMessages.format("DCUB0023", name));
                return null;
            }
            value = TagUtils.value(formWrapper.getValues(name), index);
        }
        return value;
    }

    private static Object value(Object[] values, Integer index) {
        Object value = values == null ? "" : (index == null ? TagUtils.getElement(values, 0) : TagUtils.getElement(values, index));
        return value;
    }

    private static Object getElement(Object[] values, Integer index) {
        Object value = values.length <= index ? "" : values[index];
        return value;
    }

    private static boolean isValidationFail(JspContext context) {
        return Boolean.TRUE.equals(context.getAttribute("org.seasar.cubby.validationFail", 2));
    }

    public static String toAttr(Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() == REMOVE_ATTRIBUTE) continue;
            builder.append(key);
            builder.append("=\"");
            builder.append(TagUtils.escapeHtml(entry.getValue()));
            builder.append("\" ");
        }
        return builder.toString();
    }

    public static boolean contains(Object obj, String str) {
        if (obj instanceof Collection) {
            return ((Collection)obj).contains(str);
        }
        if (obj.getClass().isArray()) {
            for (Object value : (Object[])obj) {
                if (!TagUtils.equalsAsString(value, str)) continue;
                return true;
            }
            return false;
        }
        return TagUtils.equalsAsString(obj, str);
    }

    private static boolean equalsAsString(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null) {
            return false;
        }
        return obj1.toString().equals(obj2.toString());
    }

    public static void addCSSClassName(Map<String, Object> dynamicAttributes, String className) {
        String classValue = (String)dynamicAttributes.get("class");
        classValue = StringUtils.isEmpty(classValue) ? className : classValue + " " + className;
        dynamicAttributes.put("class", classValue);
    }

    public static FormWrapper getFormWrapper(SimpleTag tag) {
        FormTag formTag = (FormTag)SimpleTagSupport.findAncestorWithClass((JspTag)tag, FormTag.class);
        if (formTag == null) {
            return null;
        }
        return formTag.getFormWrapper();
    }

    public static String escapeHtml(Object str) {
        if (str == null) {
            return "";
        }
        String text = str.toString();
        text = StringUtils.replace(text, "&", "&amp;");
        text = StringUtils.replace(text, "<", "&lt;");
        text = StringUtils.replace(text, ">", "&gt;");
        text = StringUtils.replace(text, "\"", "&quot;");
        text = StringUtils.replace(text, "'", "&#39;");
        return text;
    }

    public static String toString(Object object) {
        return object == null ? "" : object.toString();
    }

    public static String getContextPath(JspContext jspContext) {
        String contextPath = (String)jspContext.getAttribute("contextPath", 2);
        if ("/".equals(contextPath)) {
            return "";
        }
        return contextPath;
    }
}

