/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.action;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.action.ActionContext;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.action.RequestMethod;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.internal.util.MetaUtils;
import org.seasar.cubby.internal.util.QueryStringBuilder;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.routing.PathResolver;
import org.seasar.cubby.routing.Routing;
import org.seasar.cubby.spi.PathResolverProvider;
import org.seasar.cubby.spi.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Forward
implements ActionResult {
    private static final Logger logger = LoggerFactory.getLogger(Forward.class);
    private static final Map<String, String[]> EMPTY_PARAMETERS = Collections.emptyMap();
    private final PathResolverProvider pathResolverProvider;
    private String path;
    private final Routing routing;
    private Class<?> actionClass;
    private String methodName;
    private Map<String, String[]> parameters;

    public Forward(String path) {
        this.pathResolverProvider = null;
        this.path = path;
        this.routing = null;
    }

    public Forward(Class<?> actionClass, String methodName, Map<String, String[]> parameters) {
        this.pathResolverProvider = ProviderFactory.get(PathResolverProvider.class);
        this.actionClass = actionClass;
        this.methodName = methodName;
        this.parameters = parameters;
        try {
            Method method = actionClass.getMethod(methodName, new Class[0]);
            this.routing = new ForwardRouting(actionClass, method);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Forward(Class<?> actionClass) {
        this(actionClass, "index");
    }

    public Forward(Class<?> actionClass, String methodName) {
        this(actionClass, methodName, EMPTY_PARAMETERS);
    }

    public String getPath(String characterEncoding) {
        if (this.isReverseLookupRedirect()) {
            String forwardPath;
            PathResolver pathResolver = this.pathResolverProvider.getPathResolver();
            this.path = forwardPath = pathResolver.reverseLookup(this.actionClass, this.methodName, this.parameters, characterEncoding);
        }
        return this.path;
    }

    private boolean isReverseLookupRedirect() {
        return this.actionClass != null && this.methodName != null && this.parameters != null;
    }

    @Override
    public void execute(ActionContext actionContext, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        actionContext.invokePreRenderMethod();
        String forwardPath = this.calculateForwardPath(this.getPath(request.getCharacterEncoding()), actionContext.getActionClass(), request.getCharacterEncoding());
        if (this.routing != null) {
            request.setAttribute("org.seasar.cubby.routing", (Object)this.routing);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(LogMessages.format("DCUB0001", forwardPath, this.routing));
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher(forwardPath);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        if (logger.isDebugEnabled()) {
            logger.debug(LogMessages.format("DCUB0002", forwardPath));
        }
        actionContext.invokePostRenderMethod();
        actionContext.clearFlash();
    }

    protected String calculateForwardPath(String path, Class<?> actionClass, String characterEncoding) {
        String absolutePath;
        if (this.getPath(characterEncoding).startsWith("/")) {
            absolutePath = path;
        } else {
            String actionDirectory = MetaUtils.getActionDirectory(actionClass);
            if (StringUtils.isEmpty(actionDirectory)) {
                absolutePath = "/" + path;
            } else {
                StringBuilder builder = new StringBuilder();
                if (!actionDirectory.startsWith("/")) {
                    builder.append("/");
                }
                builder.append(actionDirectory);
                if (!actionDirectory.endsWith("/")) {
                    builder.append("/");
                }
                builder.append(path);
                absolutePath = builder.toString();
            }
        }
        return absolutePath;
    }

    public Forward param(String paramName, Object paramValue) {
        return this.param(paramName, new String[]{paramValue.toString()});
    }

    public Forward param(String paramName, Object[] paramValues) {
        return this.param(paramName, this.toStringArray(paramValues));
    }

    public Forward param(String paramName, String[] paramValues) {
        if (this.isReverseLookupRedirect()) {
            if (this.parameters == EMPTY_PARAMETERS) {
                this.parameters = new HashMap<String, String[]>();
            }
            this.parameters.put(paramName, paramValues);
        } else {
            QueryStringBuilder builder = new QueryStringBuilder(this.path);
            builder.addParam(paramName, paramValues);
            this.path = builder.toString();
        }
        return this;
    }

    private String[] toStringArray(Object[] paramValues) {
        String[] values = new String[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            values[i] = paramValues[i].toString();
        }
        return values;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardRouting
    implements Routing {
        private final Class<?> actionClass;
        private final Method actionMethod;

        private ForwardRouting(Class<?> actionClass, Method actionMethod) {
            this.actionClass = actionClass;
            this.actionMethod = actionMethod;
        }

        @Override
        public Class<?> getActionClass() {
            return this.actionClass;
        }

        @Override
        public Method getActionMethod() {
            return this.actionMethod;
        }

        @Override
        public String getActionPath() {
            return null;
        }

        @Override
        public List<String> getUriParameterNames() {
            return null;
        }

        @Override
        public Pattern getPattern() {
            return null;
        }

        @Override
        public RequestMethod getRequestMethod() {
            return null;
        }

        @Override
        public String getOnSubmit() {
            return null;
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public boolean isAcceptable(String requestMethod) {
            return true;
        }

        public String toString() {
            return "[" + this.actionMethod + "]";
        }
    }
}

