/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.converter.impl;

import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.converter.ConversionException;
import org.seasar.cubby.converter.ConversionHelper;
import org.seasar.cubby.converter.impl.AbstractConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumConverter
extends AbstractConverter {
    @Override
    public Class<?> getObjectType() {
        return Enum.class;
    }

    @Override
    public Object convertToObject(Object value, Class<?> objectType, ConversionHelper helper) throws ConversionException {
        if (value == null) {
            return null;
        }
        String name = value.toString();
        try {
            return Enum.valueOf(objectType, name);
        }
        catch (IllegalArgumentException e) {
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setKey("valid.enum");
            throw new ConversionException(messageInfo, (Throwable)e);
        }
    }

    @Override
    public String convertToString(Object value, ConversionHelper helper) {
        if (value == null) {
            return null;
        }
        return ((Enum)Enum.class.cast(value)).name();
    }
}

