/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.s2.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.cubby.internal.util.ReflectionUtils;
import org.seasar.cubby.spi.beans.Attribute;
import org.seasar.cubby.spi.beans.IllegalAttributeException;
import org.seasar.cubby.spi.beans.ParameterizedClassDesc;
import org.seasar.cubby.spi.beans.impl.DefaultBeanDescProvider;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.IllegalPropertyRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2BeanDescProvider
extends DefaultBeanDescProvider {
    private static volatile boolean initialized;

    private void initialize() {
        if (!initialized) {
            DisposableUtil.add((Disposable)new Disposable(){

                public void dispose() {
                    S2BeanDescProvider.this.beanDescCache.clear();
                    initialized = false;
                }
            });
            initialized = true;
        }
    }

    public org.seasar.cubby.spi.beans.BeanDesc getBeanDesc(Class<?> clazz) {
        this.initialize();
        return super.getBeanDesc(clazz);
    }

    protected org.seasar.cubby.spi.beans.BeanDesc createBeanDesc(Class<?> clazz) {
        return new S2BeanDescImpl(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class S2ParameterizedClassDesc
    implements ParameterizedClassDesc {
        private final org.seasar.framework.beans.ParameterizedClassDesc s2ParameterizedClassDesc;

        S2ParameterizedClassDesc(org.seasar.framework.beans.ParameterizedClassDesc s2ParameterizedClassDesc) {
            this.s2ParameterizedClassDesc = s2ParameterizedClassDesc;
        }

        public boolean isParameterizedClass() {
            return this.s2ParameterizedClassDesc.isParameterizedClass();
        }

        public Class<?> getRawClass() {
            return this.s2ParameterizedClassDesc.getRawClass();
        }

        public ParameterizedClassDesc[] getArguments() {
            org.seasar.framework.beans.ParameterizedClassDesc[] s2Arguments = this.s2ParameterizedClassDesc.getArguments();
            ArrayList<S2ParameterizedClassDesc> arguments = new ArrayList<S2ParameterizedClassDesc>(s2Arguments.length);
            for (org.seasar.framework.beans.ParameterizedClassDesc s2Argument : s2Arguments) {
                S2ParameterizedClassDesc argument = new S2ParameterizedClassDesc(s2Argument);
                arguments.add(argument);
            }
            return arguments.toArray(new ParameterizedClassDesc[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class S2PropertyAttribute
    implements Attribute {
        private final PropertyDesc s2PropertyDesc;
        private final ParameterizedClassDesc parameterizedClassDesc;
        private final Map<Class<? extends Annotation>, Annotation> annotationCache = new HashMap<Class<? extends Annotation>, Annotation>();

        S2PropertyAttribute(PropertyDesc s2PropertyDesc) {
            this.s2PropertyDesc = s2PropertyDesc;
            this.parameterizedClassDesc = new S2ParameterizedClassDesc(s2PropertyDesc.getParameterizedClassDesc());
        }

        public String getName() {
            return this.s2PropertyDesc.getPropertyName();
        }

        public Class<?> getType() {
            return this.s2PropertyDesc.getPropertyType();
        }

        public boolean isReadable() {
            return this.s2PropertyDesc.isReadable();
        }

        public boolean isWritable() {
            return this.s2PropertyDesc.isWritable();
        }

        public Object getValue(Object target) throws IllegalAttributeException {
            try {
                return this.s2PropertyDesc.getValue(target);
            }
            catch (IllegalPropertyRuntimeException e) {
                throw new IllegalAttributeException(e.getTargetClass(), e.getPropertyName(), (Throwable)e);
            }
        }

        public void setValue(Object target, Object value) throws IllegalAttributeException {
            try {
                this.s2PropertyDesc.setValue(target, value);
            }
            catch (IllegalPropertyRuntimeException e) {
                throw new IllegalAttributeException(e.getTargetClass(), e.getPropertyName(), (Throwable)e);
            }
        }

        public ParameterizedClassDesc getParameterizedClassDesc() {
            return this.parameterizedClassDesc;
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            Method method;
            T annotation;
            if (this.annotationCache.containsKey(annotationClass)) {
                return (T)((Annotation)annotationClass.cast(this.annotationCache.get(annotationClass)));
            }
            if (this.s2PropertyDesc.hasReadMethod() && (annotation = S2PropertyAttribute.findAnnotation(annotationClass, method = this.s2PropertyDesc.getReadMethod())) != null) {
                this.annotationCache.put((Class<? extends Annotation>)annotationClass, (Annotation)annotation);
                return annotation;
            }
            if (this.s2PropertyDesc.hasWriteMethod() && (annotation = S2PropertyAttribute.findAnnotation(annotationClass, method = this.s2PropertyDesc.getWriteMethod())) != null) {
                this.annotationCache.put((Class<? extends Annotation>)annotationClass, (Annotation)annotation);
                return annotation;
            }
            Field field = this.s2PropertyDesc.getField();
            if (field != null && (annotation = field.getAnnotation(annotationClass)) != null) {
                this.annotationCache.put((Class<? extends Annotation>)annotationClass, (Annotation)annotation);
                return field.getAnnotation(annotationClass);
            }
            return null;
        }

        private static <T extends Annotation> T findAnnotation(Class<T> annotationClass, Method method) {
            String methodName = method.getName();
            Class[] parameterTypes = method.getParameterTypes();
            Class<?> target = method.getDeclaringClass();
            while (!target.equals(Object.class)) {
                T annotation = S2PropertyAttribute.getAnnotation(annotationClass, target, methodName, parameterTypes);
                if (annotation != null) {
                    return annotation;
                }
                T annotationOfInterfaces = S2PropertyAttribute.getAnnotationOfInterfaces(annotationClass, target, methodName, parameterTypes);
                if (annotationOfInterfaces != null) {
                    return annotationOfInterfaces;
                }
                target = target.getSuperclass();
            }
            return null;
        }

        private static <T extends Annotation> T getAnnotationOfInterfaces(Class<T> annotationClass, Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                T annotation = S2PropertyAttribute.getAnnotation(annotationClass, interfaceClass, methodName, parameterTypes);
                if (annotation == null) continue;
                return annotation;
            }
            return null;
        }

        private static <T extends Annotation> T getAnnotation(Class<T> annotationClass, Class<?> clazz, String methodName, Class[] parameterTypes) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
                if (method.isAnnotationPresent(annotationClass)) {
                    return method.getAnnotation(annotationClass);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            return null;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.getAnnotation(annotationClass) != null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.s2PropertyDesc == null ? 0 : this.s2PropertyDesc.hashCode());
            result = 31 * result + this.s2PropertyDesc.getBeanDesc().getBeanClass().hashCode();
            result = 31 * result + this.s2PropertyDesc.getPropertyName().hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            S2PropertyAttribute other = (S2PropertyAttribute)obj;
            if (this.s2PropertyDesc == null) {
                if (other.s2PropertyDesc != null) {
                    return false;
                }
            } else {
                if (!this.s2PropertyDesc.getBeanDesc().getBeanClass().equals(other.s2PropertyDesc.getBeanDesc().getBeanClass())) {
                    return false;
                }
                if (!this.s2PropertyDesc.getPropertyName().equals(other.s2PropertyDesc.getPropertyName())) {
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class S2BeanDescImpl
    extends DefaultBeanDescProvider.BeanDescImpl {
        private Set<Field> recognizedAsPropertyFields;

        S2BeanDescImpl(Class<?> clazz) {
            super(clazz);
        }

        protected Map<String, Attribute> collectPropertyAttributeMap(Class<?> clazz) {
            this.recognizedAsPropertyFields = new HashSet<Field>();
            BeanDesc s2BeanDesc = BeanDescFactory.getBeanDesc(clazz);
            LinkedHashMap<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();
            for (int i = 0; i < s2BeanDesc.getPropertyDescSize(); ++i) {
                Field field;
                PropertyDesc propertyDesc = s2BeanDesc.getPropertyDesc(i);
                S2PropertyAttribute attribute = new S2PropertyAttribute(propertyDesc);
                if (!propertyDesc.hasReadMethod() && !propertyDesc.hasWriteMethod() && (field = propertyDesc.getField()) != null) {
                    this.recognizedAsPropertyFields.add(field);
                }
                attributes.put(propertyDesc.getPropertyName(), attribute);
            }
            return attributes;
        }

        protected Map<String, List<Attribute>> collectFieldAttributesMap(Class<?> clazz) {
            LinkedHashMap<String, List<Attribute>> fieldAttributes = new LinkedHashMap<String, List<Attribute>>();
            for (Field field : ReflectionUtils.findAllDeclaredField(clazz)) {
                List<DefaultBeanDescProvider.FieldAttribute> fieldDescs;
                if (this.recognizedAsPropertyFields.contains(field)) continue;
                String fieldName = field.getName();
                if (!fieldAttributes.containsKey(fieldName)) {
                    fieldDescs = new ArrayList();
                    fieldAttributes.put(fieldName, fieldDescs);
                } else {
                    fieldDescs = (List)fieldAttributes.get(fieldName);
                }
                DefaultBeanDescProvider.FieldAttribute attributes = new DefaultBeanDescProvider.FieldAttribute(clazz, field);
                fieldDescs.add(attributes);
            }
            return fieldAttributes;
        }
    }
}

