/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.tags;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.seasar.cubby.internal.controller.ThreadContext;
import org.seasar.cubby.internal.util.URLBodyEncoder;
import org.seasar.cubby.tags.TagUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubbyFunctions {
    public static Boolean contains(Object collection, Object obj) {
        if (collection instanceof Collection) {
            return CubbyFunctions._contains((Collection)collection, obj);
        }
        if (collection != null && collection.getClass().isArray()) {
            return CubbyFunctions._contains(Arrays.asList((Object[])collection), obj);
        }
        return false;
    }

    private static Boolean _contains(Collection<?> collection, Object obj) {
        return collection.contains(obj);
    }

    public static Boolean containsKey(Map<?, ?> map, Object key) {
        return map.containsKey(key);
    }

    public static Boolean containsValue(Map<?, ?> map, Object value) {
        return map.containsValue(value);
    }

    public static String odd(Integer index, String classNames) {
        String[] c = classNames.split(",");
        return c[index % c.length].trim();
    }

    public static String out(Object str) {
        return str == null ? "" : TagUtils.escapeHtml(str.toString());
    }

    public static String dateFormat(Object date, String pattern) {
        if (date instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            return format.format(date);
        }
        return "";
    }

    public static Object ifrender(Boolean condition, Object value) {
        if (condition.booleanValue()) {
            return value;
        }
        return TagUtils.REMOVE_ATTRIBUTE;
    }

    public static String url(Object str) throws UnsupportedEncodingException {
        if (str == null) {
            return "";
        }
        ThreadContext currentContext = ThreadContext.getCurrentContext();
        String characterEncoding = currentContext.getRequest().getCharacterEncoding();
        return URLBodyEncoder.encode(str.toString(), characterEncoding);
    }
}

