/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.handler;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.seasar.extension.jdbc.DbmsDialect;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.PropertyTypeImpl;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.beans.util.BeanMap;
import org.seasar.framework.convention.PersistenceConvention;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ModifierUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapResultSetHandler
implements ResultSetHandler {
    protected static final Class<? extends Map> DEFAULT_MAP_CLASS = BeanMap.class;
    protected Class<? extends Map> mapClass = DEFAULT_MAP_CLASS;
    protected DbmsDialect dialect;
    protected PersistenceConvention persistenceConvention;
    protected String sql;

    public AbstractMapResultSetHandler(Class<? extends Map> mapClass, DbmsDialect dialect, PersistenceConvention persistenceConvention, String sql) {
        if (!ModifierUtil.isAbstract(mapClass)) {
            this.mapClass = mapClass;
        }
        this.dialect = dialect;
        this.persistenceConvention = persistenceConvention;
        this.sql = sql;
    }

    protected PropertyType[] createPropertyTypes(ResultSetMetaData rsmd) throws SQLException {
        int count = rsmd.getColumnCount();
        PropertyType[] propertyTypes = new PropertyType[count];
        for (int i = 0; i < count; ++i) {
            String columnName = rsmd.getColumnLabel(i + 1);
            String propertyName = this.persistenceConvention.fromColumnNameToPropertyName(columnName);
            Class clazz = ValueTypes.getType((int)rsmd.getColumnType(i + 1));
            ValueType valueType = this.dialect.getValueType(clazz, false, null);
            propertyTypes[i] = new PropertyTypeImpl(propertyName, valueType, columnName);
        }
        return propertyTypes;
    }

    protected Object createRow(ResultSet rs, PropertyType[] propertyTypes) throws SQLException {
        Map row = (Map)ClassUtil.newInstance(this.mapClass);
        for (int i = 0; i < propertyTypes.length; ++i) {
            PropertyType pt = propertyTypes[i];
            if (pt.getColumnName().equalsIgnoreCase("rownumber_")) continue;
            Object value = pt.getValueType().getValue(rs, i + 1);
            row.put(pt.getPropertyName(), value);
        }
        return row;
    }
}

