/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Iterator;
import java.util.Stack;
import org.apache.poi.hssf.record.CustomField;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public class LinkedDataFormulaField
implements CustomField {
    Stack formulaTokens = new Stack();

    public int getSize() {
        int size = 0;
        Iterator iterator = this.formulaTokens.iterator();
        while (iterator.hasNext()) {
            Ptg token = (Ptg)iterator.next();
            size += token.getSize();
        }
        return size + 2;
    }

    public int fillField(RecordInputStream in) {
        short tokenSize = in.readShort();
        this.formulaTokens = Ptg.createParsedExpressionTokens(tokenSize, in);
        return tokenSize + 2;
    }

    public void toString(StringBuffer buffer) {
        for (int k = 0; k < this.formulaTokens.size(); ++k) {
            buffer.append("Formula ").append(k).append("=").append(this.formulaTokens.get(k).toString()).append("\n").append(((Ptg)this.formulaTokens.get(k)).toDebugString()).append("\n");
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        this.toString(b);
        return b.toString();
    }

    public int serializeField(int offset, byte[] data) {
        int size = this.getSize();
        LittleEndian.putShort(data, offset, (short)(size - 2));
        int pos = offset + 2;
        pos += Ptg.serializePtgStack(this.formulaTokens, data, pos);
        return size;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setFormulaTokens(Stack formulaTokens) {
        this.formulaTokens = (Stack)formulaTokens.clone();
    }

    public Stack getFormulaTokens() {
        return (Stack)this.formulaTokens.clone();
    }
}

