/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.datasource.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.seasar.extension.j2ee.JndiResourceLocator;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class SingletonDataSourceProxy
implements DataSource {
    public static final String actualDataSourceName_BINDING = "bindingType=may";
    protected String actualDataSourceName = "jdbc.dataSource";

    public SingletonDataSourceProxy() {
    }

    public SingletonDataSourceProxy(String actualDataSourceName) {
        this.setActualDataSourceName(actualDataSourceName);
    }

    public void setActualDataSourceName(String actualDataSourceName) {
        this.actualDataSourceName = JndiResourceLocator.resolveName(actualDataSourceName);
    }

    public Connection getConnection() throws SQLException {
        return this.getActualDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getActualDataSource().getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getActualDataSource().getLogWriter();
    }

    public int getLoginTimeout() throws SQLException {
        return this.getActualDataSource().getLoginTimeout();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getActualDataSource().setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.getActualDataSource().setLoginTimeout(seconds);
    }

    protected DataSource getActualDataSource() {
        return (DataSource)SingletonS2ContainerFactory.getContainer().getComponent((Object)this.actualDataSourceName);
    }
}

