/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.math.BigDecimal;
import java.math.BigInteger;
import ognl.Node;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlParser;
import ognl.SimpleNode;

class ASTConst
extends SimpleNode {
    private Object value;

    public ASTConst(int id) {
        super(id);
    }

    public ASTConst(OgnlParser p, int id) {
        super(p, id);
    }

    void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        return this.value;
    }

    public boolean isNodeConstant(OgnlContext context) throws OgnlException {
        return true;
    }

    public String getEscapedChar(char ch) {
        String result;
        switch (ch) {
            case '\b': {
                result = "\b";
                break;
            }
            case '\t': {
                result = "\\t";
                break;
            }
            case '\n': {
                result = "\\n";
                break;
            }
            case '\f': {
                result = "\\f";
                break;
            }
            case '\r': {
                result = "\\r";
                break;
            }
            case '\"': {
                result = "\\\"";
                break;
            }
            case '\'': {
                result = "\\'";
                break;
            }
            case '\\': {
                result = "\\\\";
                break;
            }
            default: {
                if (Character.isISOControl(ch) || ch > '\u00ff') {
                    String hc = Integer.toString(ch, 16);
                    int hcl = hc.length();
                    result = "\\u";
                    if (hcl < 4) {
                        result = hcl == 3 ? result + "0" : (hcl == 2 ? result + "00" : result + "000");
                    }
                    result = result + hc;
                    break;
                }
                result = new String(ch + "");
            }
        }
        return result;
    }

    public String getEscapedString(String value) {
        StringBuffer result = new StringBuffer();
        int icount = value.length();
        for (int i = 0; i < icount; ++i) {
            result.append(this.getEscapedChar(value.charAt(i)));
        }
        return new String(result);
    }

    public String toString() {
        String result;
        if (this.value == null) {
            result = "null";
        } else if (this.value instanceof String) {
            result = '\"' + this.getEscapedString(this.value.toString()) + '\"';
        } else if (this.value instanceof Character) {
            result = '\'' + this.getEscapedChar(((Character)this.value).charValue()) + '\'';
        } else {
            result = this.value.toString();
            if (this.value instanceof Long) {
                result = result + "L";
            } else if (this.value instanceof BigDecimal) {
                result = result + "B";
            } else if (this.value instanceof BigInteger) {
                result = result + "H";
            } else if (this.value instanceof Node) {
                result = ":[ " + result + " ]";
            }
        }
        return result;
    }
}

