/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.sql.Connection;
import javax.sql.DataSource;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.RowState;
import org.seasar.extension.dataset.TableWriter;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;

public class SqlTableWriter
implements TableWriter {
    private DataSource dataSource;

    public SqlTableWriter(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void write(DataTable table) {
        if (!table.hasMetaData()) {
            this.setupMetaData(table);
        }
        this.doWrite(table);
    }

    protected void doWrite(DataTable table) {
        for (int i = 0; i < table.getRowSize(); ++i) {
            DataRow row = table.getRow(i);
            RowState state = row.getState();
            state.update(this.dataSource, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupMetaData(DataTable table) {
        Connection con = DataSourceUtil.getConnection(this.dataSource);
        try {
            table.setupMetaData(ConnectionUtil.getMetaData(con));
        }
        finally {
            ConnectionUtil.close(con);
        }
    }
}

