/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.poi.POIDocument;
import org.apache.poi.hslf.EncryptedSlideShow;
import org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import org.apache.poi.hslf.exceptions.EncryptedPowerPointFileException;
import org.apache.poi.hslf.record.CurrentUserAtom;
import org.apache.poi.hslf.record.PersistPtrHolder;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;

public class HSLFSlideShow
extends POIDocument {
    private InputStream istream;
    private CurrentUserAtom currentUser;
    private byte[] _docstream;
    private Record[] _records;
    private PictureData[] _pictures;
    static /* synthetic */ Class class$org$apache$poi$hslf$HSLFSlideShow;

    protected POIFSFileSystem getPOIFSFileSystem() {
        return this.filesystem;
    }

    public HSLFSlideShow(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public HSLFSlideShow(InputStream inputStream) throws IOException {
        this(new POIFSFileSystem(inputStream));
        this.istream = inputStream;
    }

    public HSLFSlideShow(POIFSFileSystem filesystem) throws IOException {
        this.filesystem = filesystem;
        this.readCurrentUserStream();
        this.readPowerPointStream();
        boolean encrypted = EncryptedSlideShow.checkIfEncrypted(this);
        if (encrypted) {
            throw new EncryptedPowerPointFileException("Encrypted PowerPoint files are not supported");
        }
        this.buildRecords();
        this.readProperties();
        this.readOtherStreams();
        this.readPictures();
    }

    public HSLFSlideShow() throws IOException {
        this((class$org$apache$poi$hslf$HSLFSlideShow == null ? (class$org$apache$poi$hslf$HSLFSlideShow = HSLFSlideShow.class$("org.apache.poi.hslf.HSLFSlideShow")) : class$org$apache$poi$hslf$HSLFSlideShow).getResourceAsStream("/org/apache/poi/hslf/data/empty.ppt"));
    }

    public void close() throws IOException {
        if (this.istream != null) {
            this.istream.close();
        }
        this.filesystem = null;
    }

    private void readPowerPointStream() throws IOException {
        DocumentEntry docProps = (DocumentEntry)this.filesystem.getRoot().getEntry("PowerPoint Document");
        this._docstream = new byte[docProps.getSize()];
        this.filesystem.createDocumentInputStream("PowerPoint Document").read(this._docstream);
    }

    private void buildRecords() {
        this._records = Record.findChildRecords(this._docstream, 0, this._docstream.length);
    }

    private void readCurrentUserStream() {
        try {
            this.currentUser = new CurrentUserAtom(this.filesystem);
        }
        catch (IOException ie) {
            System.err.println("Error finding Current User Atom:\n" + ie);
            this.currentUser = new CurrentUserAtom();
        }
    }

    private void readOtherStreams() {
    }

    private void readPictures() throws IOException {
        int imgsize;
        byte[] pictstream;
        try {
            DocumentEntry entry = (DocumentEntry)this.filesystem.getRoot().getEntry("Pictures");
            pictstream = new byte[entry.getSize()];
            DocumentInputStream is = this.filesystem.createDocumentInputStream("Pictures");
            is.read(pictstream);
        }
        catch (FileNotFoundException e) {
            return;
        }
        ArrayList<PictureData> p = new ArrayList<PictureData>();
        for (int pos = 0; pos <= pictstream.length - 8; pos += imgsize) {
            int offset = pos;
            int signature = LittleEndian.getUShort(pictstream, pos);
            int type = LittleEndian.getUShort(pictstream, pos += 2);
            imgsize = LittleEndian.getInt(pictstream, pos += 2);
            pos += 4;
            if (imgsize < 0) {
                throw new CorruptPowerPointFileException("The file contains a picture, at position " + p.size() + ", which has a negatively sized data length, so we can't trust any of the picture data");
            }
            if (type == 0) {
                System.err.println("Problem reading picture: Invalid image type 0, on picture with length " + imgsize + ".\nYou document will probably become corrupted if you save it!");
                System.err.println(pos);
                continue;
            }
            byte[] imgdata = new byte[imgsize];
            if (imgsize > 0) {
                System.arraycopy(pictstream, pos, imgdata, 0, imgdata.length);
            }
            try {
                PictureData pict = PictureData.create(type - 61464);
                pict.setRawData(imgdata);
                pict.setOffset(offset);
                p.add(pict);
                continue;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Problem reading picture: " + e + "\nYou document will probably become corrupted if you save it!");
            }
        }
        this._pictures = p.toArray(new PictureData[p.size()]);
    }

    public void write(OutputStream out) throws IOException {
        PositionDependentRecord pdr;
        int i;
        POIFSFileSystem outFS = new POIFSFileSystem();
        this.writeProperties(outFS);
        Hashtable<Integer, Integer> oldToNewPositions = new Hashtable<Integer, Integer>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (i = 0; i < this._records.length; ++i) {
            if (this._records[i] instanceof PositionDependentRecord) {
                pdr = (PositionDependentRecord)((Object)this._records[i]);
                int oldPos = pdr.getLastOnDiskOffset();
                int newPos = baos.size();
                pdr.setLastOnDiskOffset(newPos);
                oldToNewPositions.put(new Integer(oldPos), new Integer(newPos));
            }
            this._records[i].writeOut(baos);
        }
        baos.reset();
        for (i = 0; i < this._records.length; ++i) {
            if (this._records[i] instanceof PositionDependentRecord) {
                pdr = (PositionDependentRecord)((Object)this._records[i]);
                pdr.updateOtherRecordReferences(oldToNewPositions);
            }
            this._records[i].writeOut(baos);
        }
        this._docstream = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        outFS.createDocument(bais, "PowerPoint Document");
        int oldLastUserEditAtomPos = (int)this.currentUser.getCurrentEditOffset();
        Integer newLastUserEditAtomPos = (Integer)oldToNewPositions.get(new Integer(oldLastUserEditAtomPos));
        if (newLastUserEditAtomPos == null) {
            throw new RuntimeException("Couldn't find the new location of the UserEditAtom that used to be at " + oldLastUserEditAtomPos);
        }
        this.currentUser.setCurrentEditOffset(newLastUserEditAtomPos.intValue());
        this.currentUser.writeToFS(outFS);
        if (this._pictures != null) {
            ByteArrayOutputStream pict = new ByteArrayOutputStream();
            for (int i2 = 0; i2 < this._pictures.length; ++i2) {
                this._pictures[i2].write(pict);
            }
            outFS.createDocument(new ByteArrayInputStream(pict.toByteArray()), "Pictures");
        }
        outFS.writeFilesystem(out);
    }

    public synchronized int appendRootLevelRecord(Record newRecord) {
        int addedAt = -1;
        Record[] r = new Record[this._records.length + 1];
        boolean added = false;
        for (int i = this._records.length - 1; i >= 0; --i) {
            if (added) {
                r[i] = this._records[i];
                continue;
            }
            r[i + 1] = this._records[i];
            if (!(this._records[i] instanceof PersistPtrHolder)) continue;
            r[i] = newRecord;
            added = true;
            addedAt = i;
        }
        this._records = r;
        return addedAt;
    }

    public void addPicture(PictureData img) {
        PictureData[] lst;
        if (this._pictures == null) {
            lst = new PictureData[1];
        } else {
            lst = new PictureData[this._pictures.length + 1];
            System.arraycopy(this._pictures, 0, lst, 0, this._pictures.length);
        }
        lst[lst.length - 1] = img;
        this._pictures = lst;
    }

    public Record[] getRecords() {
        return this._records;
    }

    public byte[] getUnderlyingBytes() {
        return this._docstream;
    }

    public CurrentUserAtom getCurrentUserAtom() {
        return this.currentUser;
    }

    public PictureData[] getPictures() {
        return this._pictures;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

