/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.core.CoreConstants;
import java.io.Serializable;

public class CallerData
implements Serializable {
    private static final long serialVersionUID = 2473626903716082403L;
    public static final String NA = "?";
    private static final String LOG4J_CATEGORY = "org.apache.log4j.Category";
    public static final int LINE_NA = -1;
    public static String CALLER_DATA_NA = "?#?:?" + CoreConstants.LINE_SEPARATOR;
    public static CallerData[] EMPTY_CALLER_DATA_ARRAY = new CallerData[0];
    int lineNumber;
    String fileName;
    String className;
    String methodName;
    boolean nativeMethod = false;

    public CallerData(String fileName, String className, String methodName, int lineNumber) {
        this.fileName = fileName;
        this.className = className;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
    }

    public CallerData(StackTraceElement ste) {
        this.className = ste.getClassName();
        this.fileName = ste.getFileName();
        this.methodName = ste.getMethodName();
        this.lineNumber = ste.getLineNumber();
        this.nativeMethod = ste.isNativeMethod();
    }

    public static CallerData[] extract(Throwable t, String fqnOfInvokingClass) {
        int i;
        if (t == null) {
            return null;
        }
        StackTraceElement[] steArray = t.getStackTrace();
        int found = -1;
        for (i = 0; i < steArray.length; ++i) {
            if (CallerData.isDirectlyInvokingClass(steArray[i].getClassName(), fqnOfInvokingClass)) {
                found = i + 1;
                continue;
            }
            if (found != -1) break;
        }
        if (found == -1) {
            return EMPTY_CALLER_DATA_ARRAY;
        }
        CallerData[] callerDataArray = new CallerData[steArray.length - found];
        for (i = found; i < steArray.length; ++i) {
            callerDataArray[i - found] = new CallerData(steArray[i]);
        }
        return callerDataArray;
    }

    public static boolean isDirectlyInvokingClass(String currentClass, String fqnOfInvokingClass) {
        return currentClass.equals(fqnOfInvokingClass) || currentClass.equals(LOG4J_CATEGORY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CallerData)) {
            return false;
        }
        CallerData r = (CallerData)o;
        if (!this.getClassName().equals(r.getClassName())) {
            return false;
        }
        if (!this.getFileName().equals(r.getFileName())) {
            return false;
        }
        if (!this.getMethodName().equals(r.getMethodName())) {
            return false;
        }
        return this.lineNumber == r.lineNumber;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClassName());
        buf.append('.');
        buf.append(this.getMethodName());
        buf.append('(');
        if (this.isNativeMethod()) {
            buf.append("Native Method");
        } else if (this.getFileName() == null) {
            buf.append("Unknown Source");
        } else {
            buf.append(this.getFileName());
            buf.append(':');
            buf.append(this.getLineNumber());
        }
        buf.append(')');
        return buf.toString();
    }

    public boolean isNativeMethod() {
        return this.nativeMethod;
    }
}

