/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javassist.runtime.Desc;
import javassist.util.proxy.ProxyFactory;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.container.ContainerNotRegisteredRuntimeException;
import org.seasar.framework.container.CyclicReferenceRuntimeException;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.ExternalContextComponentDefRegister;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.TooManyRegistrationComponentDef;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.container.impl.S2ContainerComponentDef;
import org.seasar.framework.container.impl.SimpleComponentDef;
import org.seasar.framework.container.impl.TooManyRegistrationComponentDefImpl;
import org.seasar.framework.container.ognl.S2ContainerPropertyAccessor;
import org.seasar.framework.container.util.MetaDefSupport;
import org.seasar.framework.container.util.S2ContainerUtil;
import org.seasar.framework.container.util.Traversal;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.StringUtil;

public class S2ContainerImpl
implements S2Container,
ContainerConstants {
    private static final Logger logger = Logger.getLogger(S2ContainerImpl.class);
    private Map componentDefMap = new HashMap();
    private List componentDefList = new ArrayList();
    private String namespace;
    private String path;
    private boolean initializeOnCreate;
    private List children = new ArrayList();
    private Map childPositions = new HashMap();
    private List parents = new ArrayList();
    private CaseInsensitiveMap descendants = new CaseInsensitiveMap();
    private S2Container root;
    private ExternalContext externalContext;
    private ExternalContextComponentDefRegister externalContextComponentDefRegister;
    private MetaDefSupport metaDefSupport = new MetaDefSupport(this);
    private boolean inited = false;
    private ClassLoader classLoader = null;

    public S2ContainerImpl() {
        this.root = this;
        this.register0(new SimpleComponentDef((Object)this, "container"));
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public S2Container getRoot() {
        return this.root;
    }

    public void setRoot(S2Container root) {
        this.root = root != null ? root : this;
    }

    public Object getComponent(Object componentKey) {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        ComponentDef cd = S2ContainerBehavior.acquireFromGetComponent(this, componentKey);
        if (cd == null) {
            return null;
        }
        return cd.getComponent();
    }

    public Object[] findComponents(Object componentKey) {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        ComponentDef[] componentDefs = this.findComponentDefs(componentKey);
        return this.toComponentArray(componentKey, componentDefs);
    }

    public Object[] findAllComponents(Object componentKey) throws CyclicReferenceRuntimeException {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        ComponentDef[] componentDefs = this.findAllComponentDefs(componentKey);
        return this.toComponentArray(componentKey, componentDefs);
    }

    public Object[] findLocalComponents(Object componentKey) throws CyclicReferenceRuntimeException {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        ComponentDef[] componentDefs = this.findLocalComponentDefs(componentKey);
        return this.toComponentArray(componentKey, componentDefs);
    }

    protected Object[] toComponentArray(Object componentKey, ComponentDef[] componentDefs) {
        int length = componentDefs.length;
        Object[] components = componentKey instanceof Class ? (Object[])Array.newInstance((Class)componentKey, length) : new Object[length];
        for (int i = 0; i < length; ++i) {
            components[i] = componentDefs[i].getComponent();
        }
        return components;
    }

    public void injectDependency(Object outerComponent) {
        this.injectDependency(outerComponent, outerComponent.getClass());
    }

    public void injectDependency(Object outerComponent, Class componentClass) {
        this.assertParameterIsNotNull(outerComponent, "outerComponent");
        this.assertParameterIsNotNull(componentClass, "componentClass");
        ComponentDef cd = S2ContainerBehavior.acquireFromInjectDependency(this, componentClass);
        if (cd != null) {
            cd.injectDependency(outerComponent);
        }
    }

    public void injectDependency(Object outerComponent, String componentName) {
        this.assertParameterIsNotNull(outerComponent, "outerComponent");
        this.assertParameterIsNotEmpty(componentName, "componentName");
        ComponentDef cd = S2ContainerBehavior.acquireFromInjectDependency(this, componentName);
        if (cd != null) {
            cd.injectDependency(outerComponent);
        }
    }

    public void register(Object component) {
        this.assertParameterIsNotNull(component, "component");
        this.register(new SimpleComponentDef(component));
    }

    public void register(Object component, String componentName) {
        this.assertParameterIsNotNull(component, "component");
        this.assertParameterIsNotEmpty(componentName, "componentName");
        this.register(new SimpleComponentDef(component, componentName));
    }

    public void register(Class componentClass) {
        this.assertParameterIsNotNull(componentClass, "componentClass");
        this.register(new ComponentDefImpl(componentClass));
    }

    public void register(Class componentClass, String componentName) {
        this.assertParameterIsNotNull(componentClass, "componentClass");
        this.assertParameterIsNotEmpty(componentName, "componentName");
        this.register(new ComponentDefImpl(componentClass, componentName));
    }

    public void register(ComponentDef componentDef) {
        this.assertParameterIsNotNull(componentDef, "componentDef");
        this.register0(componentDef);
        this.componentDefList.add(componentDef);
    }

    public void register0(ComponentDef componentDef) {
        if (componentDef.getContainer() == null) {
            componentDef.setContainer(this);
        }
        this.registerByClass(componentDef);
        this.registerByName(componentDef);
    }

    protected void registerByClass(ComponentDef componentDef) {
        Class[] classes = S2ContainerUtil.getAssignableClasses(componentDef.getComponentClass());
        for (int i = 0; i < classes.length; ++i) {
            this.registerMap(classes[i], componentDef);
        }
    }

    protected void registerByName(ComponentDef componentDef) {
        String componentName = componentDef.getComponentName();
        if (componentName != null) {
            this.registerMap(componentName, componentDef);
        }
    }

    protected void registerMap(Object key, ComponentDef componentDef) {
        this.registerMap(key, componentDef, this);
    }

    public void registerMap(Object key, ComponentDef componentDef, S2Container container) {
        int position = this.getContainerPosition(container);
        ComponentDefHolder holder = (ComponentDefHolder)this.componentDefMap.get(key);
        if (holder == null) {
            holder = new ComponentDefHolder(position, componentDef);
            this.componentDefMap.put(key, holder);
        } else {
            if (position > holder.getPosition()) {
                return;
            }
            if (position < holder.getPosition()) {
                holder.setPosition(position);
                holder.setComponentDef(componentDef);
            } else if (container != this) {
                holder.setComponentDef(componentDef);
            } else {
                holder.setComponentDef(S2ContainerImpl.createTooManyRegistration(key, holder.getComponentDef(), componentDef));
            }
        }
        this.registerParent(key, holder.getComponentDef());
    }

    protected void registerParent(Object key, ComponentDef componentDef) {
        for (int i = 0; i < this.getParentSize(); ++i) {
            S2Container parent = this.getParent(i);
            parent.registerMap(key, componentDef, this);
            if (!this.isNeedNS(key, componentDef)) continue;
            parent.registerMap(this.namespace + '.' + key, componentDef, this);
        }
    }

    public int getComponentDefSize() {
        return this.componentDefList.size();
    }

    public ComponentDef getComponentDef(int index) {
        return (ComponentDef)this.componentDefList.get(index);
    }

    public ComponentDef getComponentDef(Object key) throws ComponentNotFoundRuntimeException {
        this.assertParameterIsNotNull(key, "key");
        return S2ContainerBehavior.acquireFromGetComponentDef(this, key);
    }

    public ComponentDef[] findComponentDefs(Object key) throws ComponentNotFoundRuntimeException {
        this.assertParameterIsNotNull(key, "key");
        ComponentDef cd = this.internalGetComponentDef(key);
        return this.toComponentDefArray(cd);
    }

    public ComponentDef[] findAllComponentDefs(final Object componentKey) {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        final ArrayList componentDefs = new ArrayList();
        Traversal.forEachContainer(this, new Traversal.S2ContainerHandler(){

            public Object processContainer(S2Container container) {
                componentDefs.addAll(Arrays.asList(container.findLocalComponentDefs(componentKey)));
                return null;
            }
        });
        return componentDefs.toArray(new ComponentDef[componentDefs.size()]);
    }

    public ComponentDef[] findLocalComponentDefs(Object componentKey) {
        ComponentDefHolder holder = (ComponentDefHolder)this.componentDefMap.get(componentKey);
        if (holder == null || holder.getPosition() > 0) {
            return new ComponentDef[0];
        }
        return this.toComponentDefArray(holder.getComponentDef());
    }

    protected ComponentDef[] toComponentDefArray(ComponentDef cd) {
        if (cd == null) {
            return new ComponentDef[0];
        }
        if (cd instanceof TooManyRegistrationComponentDefImpl) {
            return ((TooManyRegistrationComponentDefImpl)cd).getComponentDefs();
        }
        return new ComponentDef[]{cd};
    }

    protected ComponentDef internalGetComponentDef(Object key) {
        String name;
        int index;
        ComponentDefHolder holder = (ComponentDefHolder)this.componentDefMap.get(key);
        if (holder != null) {
            return holder.getComponentDef();
        }
        if (key instanceof String && (index = (name = (String)key).indexOf(46)) > 0) {
            String ns = name.substring(0, index);
            name = name.substring(index + 1);
            if (ns.equals(this.namespace)) {
                return this.internalGetComponentDef(name);
            }
        }
        return null;
    }

    public boolean hasComponentDef(Object componentKey) {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        return S2ContainerBehavior.acquireFromHasComponentDef(this, componentKey) != null;
    }

    public boolean hasDescendant(String path) {
        this.assertParameterIsNotEmpty(path, "path");
        return this.descendants.containsKey(path);
    }

    public S2Container getDescendant(String path) {
        S2Container descendant = (S2Container)this.descendants.get(path);
        if (descendant != null) {
            return descendant;
        }
        throw new ContainerNotRegisteredRuntimeException(path);
    }

    public void registerDescendant(S2Container descendant) {
        this.assertParameterIsNotNull(descendant, "descendant");
        this.descendants.put(descendant.getPath(), descendant);
    }

    public void include(S2Container child) {
        this.assertParameterIsNotNull(child, "child");
        this.children.add(child);
        this.childPositions.put(child, new Integer(this.children.size()));
        child.setRoot(this.getRoot());
        child.addParent(this);
    }

    protected int getContainerPosition(S2Container container) {
        if (container == this) {
            return 0;
        }
        return (Integer)this.childPositions.get(container);
    }

    protected boolean isNeedNS(Object key, ComponentDef cd) {
        return key instanceof String && this.namespace != null;
    }

    public int getChildSize() {
        return this.children.size();
    }

    public S2Container getChild(int index) {
        return (S2Container)this.children.get(index);
    }

    public int getParentSize() {
        return this.parents.size();
    }

    public S2Container getParent(int index) {
        return (S2Container)this.parents.get(index);
    }

    public void addParent(S2Container parent) {
        this.parents.add(parent);
        Iterator it = this.componentDefMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            ComponentDefHolder holder = (ComponentDefHolder)entry.getValue();
            ComponentDef cd = holder.getComponentDef();
            parent.registerMap(key, cd, this);
            if (!this.isNeedNS(key, cd)) continue;
            parent.registerMap(this.namespace + '.' + key, cd, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.inited) {
            return;
        }
        ExternalContextComponentDefRegister register = this.getRoot().getExternalContextComponentDefRegister();
        if (register != null) {
            register.registerComponentDefs(this);
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            int i;
            for (i = 0; i < this.getChildSize(); ++i) {
                this.getChild(i).init();
            }
            for (i = 0; i < this.getComponentDefSize(); ++i) {
                this.getComponentDef(i).init();
            }
            this.inited = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!this.inited) {
            return;
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            int i;
            for (i = this.getComponentDefSize() - 1; 0 <= i; --i) {
                try {
                    this.getComponentDef(i).destroy();
                    continue;
                }
                catch (Throwable t) {
                    logger.error("ESSR0017", t);
                }
            }
            for (i = this.getChildSize() - 1; 0 <= i; --i) {
                this.getChild(i).destroy();
            }
            this.componentDefMap = null;
            this.componentDefList = null;
            this.namespace = null;
            this.path = null;
            this.children = null;
            this.childPositions = null;
            this.parents = null;
            this.descendants = null;
            this.externalContext = null;
            this.externalContextComponentDefRegister = null;
            this.metaDefSupport = null;
            this.classLoader = null;
            this.root = this;
            this.inited = false;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.componentDefMap.remove(namespace);
        this.namespace = namespace;
        this.registerMap(namespace, new S2ContainerComponentDef(this, namespace));
    }

    public boolean isInitializeOnCreate() {
        return this.initializeOnCreate;
    }

    public void setInitializeOnCreate(boolean initializeOnCreate) {
        this.initializeOnCreate = initializeOnCreate;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public void setExternalContext(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    public ExternalContextComponentDefRegister getExternalContextComponentDefRegister() {
        return this.externalContextComponentDefRegister;
    }

    public void setExternalContextComponentDefRegister(ExternalContextComponentDefRegister register) {
        this.externalContextComponentDefRegister = register;
    }

    public void addMetaDef(MetaDef metaDef) {
        this.metaDefSupport.addMetaDef(metaDef);
    }

    public MetaDef getMetaDef(int index) {
        return this.metaDefSupport.getMetaDef(index);
    }

    public MetaDef getMetaDef(String name) {
        return this.metaDefSupport.getMetaDef(name);
    }

    public MetaDef[] getMetaDefs(String name) {
        return this.metaDefSupport.getMetaDefs(name);
    }

    public int getMetaDefSize() {
        return this.metaDefSupport.getMetaDefSize();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static ComponentDef createTooManyRegistration(Object key, ComponentDef currentComponentDef, ComponentDef newComponentDef) {
        if (currentComponentDef instanceof TooManyRegistrationComponentDef) {
            ((TooManyRegistrationComponentDef)currentComponentDef).addComponentDef(newComponentDef);
            return currentComponentDef;
        }
        TooManyRegistrationComponentDefImpl tmrcf = new TooManyRegistrationComponentDefImpl(key);
        tmrcf.addComponentDef(currentComponentDef);
        tmrcf.addComponentDef(newComponentDef);
        return tmrcf;
    }

    protected void assertParameterIsNotNull(Object parameter, String name) {
        if (parameter == null) {
            throw new IllegalArgumentException(name);
        }
    }

    protected void assertParameterIsNotEmpty(String parameter, String name) {
        if (StringUtil.isEmpty(parameter)) {
            throw new IllegalArgumentException(name);
        }
    }

    static {
        OgnlRuntime.setPropertyAccessor((Class)S2Container.class, (PropertyAccessor)new S2ContainerPropertyAccessor());
        Desc.useContextClassLoader = true;
        ProxyFactory.classLoaderProvider = new ProxyFactory.ClassLoaderProvider(){

            public ClassLoader get(ProxyFactory proxyFactory) {
                return Thread.currentThread().getContextClassLoader();
            }
        };
    }

    static class ComponentDefHolder {
        private int position;
        private ComponentDef componentDef;

        public ComponentDefHolder(int position, ComponentDef componentDef) {
            this.position = position;
            this.componentDef = componentDef;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public ComponentDef getComponentDef() {
            return this.componentDef;
        }

        public void setComponentDef(ComponentDef componentDef) {
            this.componentDef = componentDef;
        }
    }
}

