/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.S2Container;

public class InvalidateSessionInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    protected S2Container container;

    public InvalidateSessionInterceptor(S2Container container) {
        this.container = container.getRoot();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = invocation.proceed();
        this.invalidate();
        return result;
    }

    protected void invalidate() {
        ExternalContext externalContext = this.container.getExternalContext();
        if (externalContext != null) {
            Map requestMap = externalContext.getRequestMap();
            requestMap.put("Seasar2-invalidateSession", Boolean.TRUE);
        }
    }
}

