/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.controller.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.seasar.cubby.controller.RequestParseException;
import org.seasar.cubby.controller.RequestParser;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.spi.ContainerProvider;
import org.seasar.cubby.spi.ProviderFactory;
import org.seasar.cubby.spi.container.Container;
import org.seasar.cubby.spi.container.LookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartRequestParser
implements RequestParser {
    @Override
    public Map<String, Object[]> getParameterMap(HttpServletRequest request) {
        HashMap<String, Object[]> parameterMap = new HashMap<String, Object[]>(request.getParameterMap());
        Container container = ProviderFactory.get(ContainerProvider.class).getContainer();
        try {
            RequestContext requestContext = container.lookup(RequestContext.class);
            FileUpload fileUpload = container.lookup(FileUpload.class);
            Map<String, Object[]> multipartParameterMap = this.getMultipartParameterMap(fileUpload, requestContext);
            parameterMap.putAll(multipartParameterMap);
            return parameterMap;
        }
        catch (LookupException e) {
            throw new IllegalStateException(e);
        }
    }

    Map<String, Object[]> getMultipartParameterMap(FileUpload fileUpload, RequestContext requestContext) {
        try {
            String encoding = requestContext.getCharacterEncoding();
            fileUpload.setHeaderEncoding(encoding);
            List items = fileUpload.parseRequest(requestContext);
            Map<String, Object[]> parameterMap = this.toParameterMap(encoding, items);
            return parameterMap;
        }
        catch (FileUploadException e) {
            Object[] args;
            String messageCode;
            if (e instanceof FileUploadBase.SizeLimitExceededException) {
                FileUploadBase.SizeLimitExceededException sle = (FileUploadBase.SizeLimitExceededException)e;
                messageCode = "ECUB0202";
                args = new Object[]{sle.getPermittedSize(), sle.getActualSize()};
            } else {
                messageCode = "ECUB0201";
                args = new Object[]{e};
            }
            throw new RequestParseException(LogMessages.format(messageCode, args), e);
        }
        catch (IOException e) {
            throw new RequestParseException(e);
        }
    }

    Map<String, Object[]> toParameterMap(String encoding, List<FileItem> items) throws UnsupportedEncodingException {
        LinkedHashMap<String, List<Object>> valueListParameterMap = new LinkedHashMap<String, List<Object>>();
        for (FileItem item : items) {
            List<String> values;
            Object value = item.isFormField() ? item.getString(encoding) : (StringUtils.isEmpty(item.getName()) || item.getSize() == 0L ? null : item);
            if (valueListParameterMap.containsKey(item.getFieldName())) {
                values = (List)valueListParameterMap.get(item.getFieldName());
            } else {
                values = new ArrayList();
                valueListParameterMap.put(item.getFieldName(), values);
            }
            values.add((String)value);
        }
        Map<String, Object[]> parameterMap = this.fromValueListMapToValueArrayMap(valueListParameterMap);
        return parameterMap;
    }

    Map<String, Object[]> fromValueListMapToValueArrayMap(Map<String, List<Object>> valueListMap) {
        HashMap<String, Object[]> parameterMap = new HashMap<String, Object[]>();
        for (Map.Entry<String, List<Object>> entry : valueListMap.entrySet()) {
            List<Object> values = entry.getValue();
            String[] valueArray = values.get(0) instanceof String ? new String[values.size()] : new FileItem[values.size()];
            parameterMap.put(entry.getKey(), values.toArray(valueArray));
        }
        return parameterMap;
    }

    @Override
    public boolean isParsable(HttpServletRequest request) {
        Container container = ProviderFactory.get(ContainerProvider.class).getContainer();
        try {
            RequestContext requestContext = container.lookup(RequestContext.class);
            return FileUploadBase.isMultipartContent((RequestContext)requestContext);
        }
        catch (LookupException e) {
            return false;
        }
    }
}

