/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.routing.impl;

import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.routing.PathTemplateException;
import org.seasar.cubby.routing.PathTemplateParser;

public class PathTemplateParserImpl
implements PathTemplateParser {
    private static final char OPEN_PLACE_HOLDER = '{';
    private static final char CLOSE_PLACE_HOLDER = '}';
    private static final char PLACE_HOLDER_SEPARATOR = ',';
    private static final char REGEXP_ESCAPE = '\\';

    public String parse(String template, PathTemplateParser.Handler handler) {
        StringBuilder pathRegex = new StringBuilder(100);
        StringBuilder paramName = new StringBuilder(10);
        StringBuilder paramRegex = new StringBuilder(10);
        State state = State.NORMAL;
        int braceDepth = 0;
        block6: for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            switch (state) {
                case NORMAL: {
                    if (c == '{') {
                        state = State.PARAM_NAME;
                        continue block6;
                    }
                    pathRegex.append(c);
                    continue block6;
                }
                case PARAM_NAME: {
                    String replacement;
                    if (c == '}') {
                        if (paramName.length() == 0) {
                            throw new PathTemplateException(LogMessages.format("ECUB0108", template, i));
                        }
                        replacement = handler.handle(paramName.toString(), "[a-zA-Z0-9]+");
                        pathRegex.append(replacement);
                        paramName.setLength(0);
                        state = State.NORMAL;
                        continue block6;
                    }
                    if (c == ',') {
                        state = State.PARAM_REGEX;
                        continue block6;
                    }
                    paramName.append(c);
                    continue block6;
                }
                case PARAM_REGEX: {
                    String replacement;
                    if (c == '\\') {
                        paramRegex.append(c);
                        state = State.PARAM_REGEX_ESCAPE;
                        continue block6;
                    }
                    if (c == '}' && braceDepth == 0) {
                        if (paramName.length() == 0) {
                            throw new PathTemplateException(LogMessages.format("ECUB0108", template, i));
                        }
                        if (paramRegex.length() == 0) {
                            throw new PathTemplateException(LogMessages.format("ECUB0109", template, i));
                        }
                        replacement = handler.handle(paramName.toString(), paramRegex.toString());
                        pathRegex.append(replacement);
                        paramName.setLength(0);
                        paramRegex.setLength(0);
                        braceDepth = 0;
                        state = State.NORMAL;
                        continue block6;
                    }
                    if (c == '{') {
                        ++braceDepth;
                    } else if (c == '}') {
                        --braceDepth;
                    }
                    paramRegex.append(c);
                    continue block6;
                }
                case PARAM_REGEX_ESCAPE: {
                    paramRegex.append(c);
                    state = State.PARAM_REGEX;
                    continue block6;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (state != State.NORMAL) {
            throw new PathTemplateException(LogMessages.format("ECUB0107", template));
        }
        return pathRegex.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NORMAL,
        PARAM_NAME,
        PARAM_REGEX,
        PARAM_REGEX_ESCAPE;

    }
}

