/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.spring;

import javax.servlet.ServletContext;
import org.seasar.cubby.plugin.AbstractPlugin;
import org.seasar.cubby.spi.BeanDescProvider;
import org.seasar.cubby.spi.ContainerProvider;
import org.seasar.cubby.spi.ConverterProvider;
import org.seasar.cubby.spi.PathResolverProvider;
import org.seasar.cubby.spi.Provider;
import org.seasar.cubby.spi.RequestParserProvider;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringPlugin
extends AbstractPlugin {
    private ApplicationContext applicationContext;

    public SpringPlugin() {
        this.support(BeanDescProvider.class);
        this.support(ContainerProvider.class);
        this.support(RequestParserProvider.class);
        this.support(PathResolverProvider.class);
        this.support(ConverterProvider.class);
    }

    public void initialize(ServletContext servletContext) throws Exception {
        super.initialize(servletContext);
        this.applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
    }

    public <S extends Provider> S getProvider(Class<S> service) {
        if (this.isSupport(service)) {
            String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, service);
            return (S)((Provider)service.cast(this.applicationContext.getBean(names[0])));
        }
        return null;
    }
}

