/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.util.ModifierUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.Tokenizer;

public class ConstantAnnotationUtil {
    protected ConstantAnnotationUtil() {
    }

    public static Map convertExpressionToMap(String expression) {
        if (StringUtil.isEmpty(expression)) {
            return null;
        }
        MyTokenizer tokenizer = new MyTokenizer(expression);
        HashMap<String, String> ret = new HashMap<String, String>();
        int token = tokenizer.nextToken();
        while (token != -1) {
            String s = tokenizer.getStringValue();
            token = tokenizer.nextToken();
            if (token == 61) {
                token = tokenizer.nextToken();
                String s2 = tokenizer.getStringValue();
                ret.put(s, s2);
                tokenizer.nextToken();
            } else if (token == 44) {
                ret.put(null, s);
            } else if (token == -1) {
                ret.put(null, s);
                break;
            }
            token = tokenizer.nextToken();
        }
        return ret;
    }

    public static boolean isConstantAnnotation(Field field) {
        return ModifierUtil.isPublicStaticFinalField(field) && field.getType().equals(String.class);
    }

    protected static class MyTokenizer
    extends Tokenizer {
        public static final int TT_EQUAL = 61;
        public static final int TT_COMMA = 44;
        private static byte[] defaultCtype = new byte[256];

        public MyTokenizer(String str) {
            super(str, defaultCtype);
        }

        public MyTokenizer(String str, byte[] ctype) {
            super(str, ctype);
        }

        protected static void setup(byte[] ctype2) {
            Tokenizer.setup(ctype2);
            MyTokenizer.ordinaryChar(ctype2, 61);
            MyTokenizer.ordinaryChar(ctype2, 44);
            MyTokenizer.wordChar(ctype2, 45);
        }

        static {
            MyTokenizer.setup(defaultCtype);
        }
    }
}

