/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.autodetector.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.seasar.framework.autodetector.ResourceAutoDetector;

public abstract class AbstractResourceAutoDetector
implements ResourceAutoDetector {
    private List targetDirPaths = new ArrayList();
    private List resourceNamePatterns = new ArrayList();
    private List ignoreResourceNamePatterns = new ArrayList();

    public void addTargetDirPath(String targetDirPath) {
        this.targetDirPaths.add(targetDirPath);
    }

    public int getTargetDirPathSize() {
        return this.targetDirPaths.size();
    }

    public String getTargetDirPath(int index) {
        return (String)this.targetDirPaths.get(index);
    }

    public void addResourceNamePattern(String resourceName) {
        this.resourceNamePatterns.add(Pattern.compile(resourceName));
    }

    public void addIgnoreResourceNamePattern(String resourceName) {
        this.ignoreResourceNamePatterns.add(Pattern.compile(resourceName));
    }

    public Pattern getResourceNamePattern(int index) {
        return (Pattern)this.resourceNamePatterns.get(index);
    }

    public int getResourceNamePatternSize() {
        return this.resourceNamePatterns.size();
    }

    public Pattern getIgnoreResourceNamePattern(int index) {
        return (Pattern)this.ignoreResourceNamePatterns.get(index);
    }

    public int getIgnoreResourceNamePatternSize() {
        return this.ignoreResourceNamePatterns.size();
    }

    protected boolean isApplied(String resourceName) {
        for (int i = 0; i < this.getResourceNamePatternSize(); ++i) {
            Pattern pattern = this.getResourceNamePattern(i);
            if (!pattern.matcher(resourceName).matches()) continue;
            return true;
        }
        return false;
    }

    protected boolean isIgnored(String resourceName) {
        for (int i = 0; i < this.getIgnoreResourceNamePatternSize(); ++i) {
            Pattern pattern = this.getIgnoreResourceNamePattern(i);
            if (!pattern.matcher(resourceName).matches()) continue;
            return true;
        }
        return false;
    }
}

