/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.s2.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.seasar.cubby.converter.Converter;
import org.seasar.cubby.plugins.s2.detector.ClassDetector;
import org.seasar.cubby.plugins.s2.detector.DetectClassProcessor;
import org.seasar.cubby.spi.impl.AbstractCachedConverterProvider;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2ConverterProvider
extends AbstractCachedConverterProvider
implements DetectClassProcessor,
Disposable {
    public static final String s2Container_BINDING = "bindingType=must";
    public static final String namingConvention_BINDING = "bindingType=must";
    public static final String classDetector_BINDING = "bindingType=must";
    private S2Container s2Container;
    private NamingConvention namingConvention;
    private ClassDetector classDetector;
    private boolean initialized;
    private final Set<Converter> converters = new LinkedHashSet<Converter>();

    public void setS2Container(S2Container s2Container) {
        this.s2Container = s2Container;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public void setClassDetector(ClassDetector classDetector) {
        this.classDetector = classDetector;
    }

    public Collection<Converter> getConverters() {
        this.initialize();
        return this.converters;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.classDetector.detect();
        Converter[] converters = (Converter[])this.s2Container.getRoot().findAllComponents(Converter.class);
        this.converters.addAll(Arrays.asList(converters));
        DisposableUtil.add((Disposable)this);
        this.initialized = true;
    }

    public void dispose() {
        this.converters.clear();
        super.clear();
        this.initialized = false;
    }

    public Converter getConverter(Class<?> parameterType, Class<?> objectType) {
        this.initialize();
        return super.getConverter(parameterType, objectType);
    }

    @Override
    public void processClass(String packageName, String shortClassName) {
        if (shortClassName.indexOf(36) != -1) {
            return;
        }
        String className = ClassUtil.concatName((String)packageName, (String)shortClassName);
        if (!this.namingConvention.isTargetClassName(className)) {
            return;
        }
        if (!className.endsWith(this.namingConvention.getConverterSuffix())) {
            return;
        }
        Class clazz = ClassUtil.forName((String)className);
        if (this.namingConvention.isSkipClass(clazz)) {
            return;
        }
        if ((clazz.getModifiers() & 0x400) != 0) {
            return;
        }
        if (!Converter.class.isAssignableFrom(clazz)) {
            return;
        }
        Converter converter = (Converter)this.s2Container.getRoot().getComponent((Object)clazz);
        this.converters.add(converter);
    }
}

