/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.s2.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import org.seasar.cubby.spi.beans.Attribute;
import org.seasar.cubby.spi.beans.BeanDesc;
import org.seasar.cubby.spi.beans.BeanDescFactory;
import org.seasar.framework.message.MessageFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2BeanELResolver
extends ELResolver {
    private final boolean readOnly;

    public S2BeanELResolver() {
        this(false);
    }

    public S2BeanELResolver(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        String propertyName = property.toString();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(base.getClass());
        if (!beanDesc.hasPropertyAttribute(propertyName)) {
            return null;
        }
        try {
            Attribute attributeDesc = beanDesc.getPropertyAttribute(propertyName);
            Object value = attributeDesc.getValue(base);
            context.setPropertyResolved(true);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        String propertyName = property.toString();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(base.getClass());
        if (!beanDesc.hasPropertyAttribute(propertyName)) {
            return null;
        }
        try {
            Attribute attributeDesc = beanDesc.getPropertyAttribute(propertyName);
            Class propertyType = attributeDesc.getType();
            context.setPropertyResolved(true);
            return propertyType;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return;
        }
        String propertyName = property.toString();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(base.getClass());
        if (!beanDesc.hasPropertyAttribute(propertyName)) {
            return;
        }
        if (this.readOnly) {
            throw new PropertyNotWritableException(MessageFormatter.getMessage((String)"ECUB0001", (Object[])new Object[]{base.getClass().getName()}));
        }
        try {
            Attribute attributeDesc = beanDesc.getPropertyAttribute(propertyName);
            attributeDesc.setValue(base, value);
            context.setPropertyResolved(true);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        String propertyName = property.toString();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(base.getClass());
        if (!beanDesc.hasPropertyAttribute(propertyName)) {
            return true;
        }
        if (this.readOnly) {
            return true;
        }
        try {
            Attribute attributeDesc = beanDesc.getPropertyAttribute(propertyName);
            boolean readOnly = !attributeDesc.isWritable();
            context.setPropertyResolved(true);
            return readOnly;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            return null;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(base.getClass());
        try {
            ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>();
            for (Attribute attributeDesc : beanDesc.findtPropertyAttributes()) {
                String propertyName = attributeDesc.getName();
                FeatureDescriptor descriptor = new FeatureDescriptor();
                descriptor.setDisplayName(propertyName);
                descriptor.setExpert(false);
                descriptor.setHidden(false);
                descriptor.setName(propertyName);
                descriptor.setPreferred(true);
                descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
                descriptor.setValue("type", attributeDesc.getType());
                descriptors.add(descriptor);
            }
            return descriptors.iterator();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null) {
            return Object.class;
        }
        return null;
    }
}

