/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.bio;

import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.transport.DataSender;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.PooledSender;
import org.apache.catalina.tribes.transport.bio.MultipointBioSender;

public class PooledMultiSender
extends PooledSender {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Member[] destination, ChannelMessage msg) throws ChannelException {
        MultiPointSender sender = null;
        try {
            sender = (MultiPointSender)this.getSender();
            if (sender == null) {
                ChannelException cx = new ChannelException("Unable to retrieve a data sender, time out error.");
                for (int i = 0; i < destination.length; ++i) {
                    cx.addFaultyMember(destination[i], new NullPointerException("Unable to retrieve a sender from the sender pool"));
                }
                throw cx;
            }
            sender.sendMessage(destination, msg);
            sender.keepalive();
        }
        finally {
            if (sender != null) {
                this.returnSender(sender);
            }
        }
    }

    public DataSender getNewDataSender() {
        MultipointBioSender sender = new MultipointBioSender();
        MultipointBioSender.transferProperties(this, sender);
        return sender;
    }
}

