/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator;

import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.action.FieldInfo;
import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.internal.controller.ConversionFailure;
import org.seasar.cubby.internal.controller.ThreadContext;
import org.seasar.cubby.internal.util.RequestUtils;
import org.seasar.cubby.validator.ValidationException;
import org.seasar.cubby.validator.ValidationRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionValidationRule
implements ValidationRule {
    private final String resourceKeyPrefix;

    public ConversionValidationRule() {
        this(null);
    }

    public ConversionValidationRule(String resourceKeyPrefix) {
        this.resourceKeyPrefix = resourceKeyPrefix;
    }

    @Override
    public void apply(Map<String, Object[]> params, Object form, ActionErrors errors) throws ValidationException {
        ThreadContext currentContext = ThreadContext.getCurrentContext();
        HttpServletRequest request = currentContext.getRequest();
        List conversionFailures = (List)RequestUtils.getAttribute((ServletRequest)request, "org.seasar.cubby.conversionFailures");
        if (conversionFailures != null && !conversionFailures.isEmpty()) {
            for (ConversionFailure conversionFailure : conversionFailures) {
                MessageInfo messageInfo = conversionFailure.getMessageInfo();
                String fieldNameKey = this.resourceKeyPrefix == null ? conversionFailure.getFieldName() : this.resourceKeyPrefix + conversionFailure.getFieldName();
                String message = messageInfo.toMessage(fieldNameKey);
                FieldInfo[] fieldInfos = conversionFailure.getFieldInfos();
                errors.add(message, fieldInfos);
            }
        }
    }
}

