/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.controller.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.cubby.action.FlashMap;
import org.seasar.cubby.internal.controller.ThreadContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FlashMapImpl
implements FlashMap {
    private static final String ATTRIBUTE_NAME = FlashMapImpl.class.getName() + ".MAP";
    private final HttpServletRequest request;
    private final Map<String, Object> map;

    public FlashMapImpl() {
        this(ThreadContext.getCurrentContext().getRequest());
    }

    public FlashMapImpl(HttpServletRequest request) {
        this.request = request;
        this.map = this.buildMap(request);
    }

    private Map<String, Object> buildMap(HttpServletRequest request) {
        Map map;
        HttpSession session = request.getSession(false);
        if (session != null && (map = (Map)FlashMapImpl.getAttribute(session, ATTRIBUTE_NAME)) != null) {
            return map;
        }
        return this.createMap();
    }

    protected Map<String, Object> createMap() {
        return new ConcurrentHashMap<String, Object>();
    }

    private void export(HttpSession session) {
        session.setAttribute(ATTRIBUTE_NAME, this.map);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        Object previousValue = this.map.put(key, value);
        this.export(this.request.getSession());
        return previousValue;
    }

    @Override
    public Object remove(Object key) {
        Object removedValue = this.map.remove(key);
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            this.export(session);
        }
        return removedValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        this.map.putAll(t);
        this.export(this.request.getSession());
    }

    @Override
    public void clear() {
        this.map.clear();
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            this.export(session);
        }
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    private static <T> T getAttribute(HttpSession session, String name) {
        return (T)session.getAttribute(name);
    }
}

