/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.controller.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.action.FieldInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActionErrorsImpl
implements ActionErrors {
    private final List<String> all = new ArrayList<String>();
    private final Map<String, List<String>> fields = new NotNullHashMap<String, List<String>>(new MessageListEmptyValueFactory());
    private final Map<String, Map<Integer, List<String>>> indexedFields = new NotNullHashMap<String, Map<Integer, List<String>>>(new IndexMapEmptyValueFactory());
    private final List<String> others = new ArrayList<String>();

    ActionErrorsImpl() {
    }

    @Override
    public List<String> getAll() {
        return this.all;
    }

    @Override
    public Map<String, List<String>> getFields() {
        return this.fields;
    }

    @Override
    public Map<String, Map<Integer, List<String>>> getIndexedFields() {
        return this.indexedFields;
    }

    @Override
    public List<String> getOthers() {
        return this.others;
    }

    @Override
    public boolean isEmpty() {
        return this.all.isEmpty();
    }

    @Override
    public void add(String message) {
        this.add(message, new FieldInfo[0]);
    }

    @Override
    public void add(String message, String ... fieldNames) {
        FieldInfo[] fieldInfos = new FieldInfo[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldInfos[i] = new FieldInfo(fieldNames[i]);
        }
        this.add(message, fieldInfos);
    }

    @Override
    public void add(String message, FieldInfo ... fieldInfos) {
        if (fieldInfos == null || fieldInfos.length == 0) {
            this.others.add(message);
        } else {
            for (FieldInfo fieldInfo : fieldInfos) {
                this.addFields(message, fieldInfo);
            }
        }
        this.all.add(message);
    }

    private void addFields(String message, FieldInfo fieldInfo) {
        Integer index;
        String name;
        if (fieldInfo == null) {
            name = null;
            index = null;
        } else {
            name = fieldInfo.getName();
            index = fieldInfo.getIndex();
        }
        List<String> messages = this.fields.get(name);
        messages.add(message);
        List<String> indexedMessages = this.indexedFields.get(name).get(index);
        indexedMessages.add(message);
    }

    @Override
    public void clear() {
        this.all.clear();
        this.fields.clear();
        this.indexedFields.clear();
        this.others.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexMapEmptyValueFactory
    implements EmptyValueFactory<Map<Integer, List<String>>> {
        private IndexMapEmptyValueFactory() {
        }

        @Override
        public Map<Integer, List<String>> create() {
            return new NotNullHashMap<Integer, List<String>>(new MessageListEmptyValueFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageListEmptyValueFactory
    implements EmptyValueFactory<List<String>> {
        private MessageListEmptyValueFactory() {
        }

        @Override
        public List<String> create() {
            return new ArrayList<String>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface EmptyValueFactory<T> {
        public T create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotNullHashMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final transient EmptyValueFactory<V> emptyValueFactory;

        private NotNullHashMap(EmptyValueFactory<V> emptyValueFactory) {
            this.emptyValueFactory = emptyValueFactory;
        }

        @Override
        public V get(Object key) {
            Object value = super.get(key);
            if (value != null) {
                return value;
            }
            V emptyValue = this.emptyValueFactory.create();
            this.put(key, emptyValue);
            return emptyValue;
        }
    }
}

