/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.util.CaseInsensitiveMap;

public class CaseInsensitiveSet
extends AbstractSet
implements Set,
Serializable {
    static final long serialVersionUID = 0L;
    private transient Map map;
    private static final Object PRESENT = new Object();

    public CaseInsensitiveSet() {
        this.map = new CaseInsensitiveMap();
    }

    public CaseInsensitiveSet(Collection c) {
        this.map = new CaseInsensitiveMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public CaseInsensitiveSet(int initialCapacity) {
        this.map = new CaseInsensitiveMap(initialCapacity);
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public boolean add(Object o) {
        return this.map.put(o, PRESENT) == null;
    }

    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    public void clear() {
        this.map.clear();
    }
}

