/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import java.util.List;
import java.util.Map;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Expression;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.UnaryOperator;
import org.apache.taglibs.standard.lang.jstl.VariableResolver;

public class UnaryOperatorExpression
extends Expression {
    UnaryOperator mOperator;
    List mOperators;
    Expression mExpression;

    public UnaryOperator getOperator() {
        return this.mOperator;
    }

    public void setOperator(UnaryOperator unaryOperator) {
        this.mOperator = unaryOperator;
    }

    public List getOperators() {
        return this.mOperators;
    }

    public void setOperators(List list) {
        this.mOperators = list;
    }

    public Expression getExpression() {
        return this.mExpression;
    }

    public void setExpression(Expression expression) {
        this.mExpression = expression;
    }

    public UnaryOperatorExpression(UnaryOperator unaryOperator, List list, Expression expression) {
        this.mOperator = unaryOperator;
        this.mOperators = list;
        this.mExpression = expression;
    }

    public String getExpressionString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        if (this.mOperator != null) {
            stringBuffer.append(this.mOperator.getOperatorSymbol());
            stringBuffer.append(" ");
        } else {
            for (int i = 0; i < this.mOperators.size(); ++i) {
                UnaryOperator unaryOperator = (UnaryOperator)this.mOperators.get(i);
                stringBuffer.append(unaryOperator.getOperatorSymbol());
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append(this.mExpression.getExpressionString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Object evaluate(Object object, VariableResolver variableResolver, Map map, String string, Logger logger) throws ELException {
        Object object2 = this.mExpression.evaluate(object, variableResolver, map, string, logger);
        if (this.mOperator != null) {
            object2 = this.mOperator.apply(object2, object, logger);
        } else {
            for (int i = this.mOperators.size() - 1; i >= 0; --i) {
                UnaryOperator unaryOperator = (UnaryOperator)this.mOperators.get(i);
                object2 = unaryOperator.apply(object2, object, logger);
            }
        }
        return object2;
    }
}

