/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Lists;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.servlet.FilterDefinition;
import com.google.inject.servlet.ServletModule;
import com.google.inject.servlet.UriPatternType;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FiltersModuleBuilder
extends AbstractModule {
    private final List<FilterDefinition> filterDefinitions = Lists.newArrayList();

    FiltersModuleBuilder() {
    }

    protected void configure() {
        this.bind(Key.get((TypeLiteral)new TypeLiteral<List<FilterDefinition>>(){}, (Annotation)UniqueAnnotations.create())).toInstance(this.filterDefinitions);
    }

    public ServletModule.FilterKeyBindingBuilder filter(List<String> patterns) {
        return new FilterKeyBindingBuilderImpl(patterns, UriPatternType.SERVLET);
    }

    public ServletModule.FilterKeyBindingBuilder filterRegex(List<String> regexes) {
        return new FilterKeyBindingBuilderImpl(regexes, UriPatternType.REGEX);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FilterKeyBindingBuilderImpl
    implements ServletModule.FilterKeyBindingBuilder {
        private final List<String> uriPatterns;
        private final UriPatternType uriPatternType;

        private FilterKeyBindingBuilderImpl(List<String> uriPatterns, UriPatternType uriPatternType) {
            this.uriPatterns = uriPatterns;
            this.uriPatternType = uriPatternType;
        }

        @Override
        public void through(Class<? extends Filter> filterKey) {
            this.through((Key<? extends Filter>)Key.get(filterKey));
        }

        @Override
        public void through(Key<? extends Filter> filterKey) {
            this.through(filterKey, new HashMap<String, String>());
        }

        @Override
        public void through(Class<? extends Filter> filterKey, Map<String, String> contextParams) {
            this.through((Key<? extends Filter>)Key.get(filterKey), contextParams);
        }

        @Override
        public void through(Key<? extends Filter> filterKey, Map<String, String> contextParams) {
            for (String pattern : this.uriPatterns) {
                FiltersModuleBuilder.this.filterDefinitions.add(new FilterDefinition(pattern, filterKey, UriPatternType.get(this.uriPatternType, pattern), contextParams));
            }
        }
    }
}

