/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugin;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.plugin.Plugin;
import org.seasar.cubby.spi.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginRegistry {
    private static final Logger logger = LoggerFactory.getLogger(PluginRegistry.class);
    private static final PluginRegistry INSTANCE = new PluginRegistry();
    private final Set<Plugin> plugins = new HashSet<Plugin>();
    private final Map<Class<? extends Provider>, Plugin> serviceToPlugins = new LinkedHashMap<Class<? extends Provider>, Plugin>();

    private PluginRegistry() {
    }

    public static PluginRegistry getInstance() {
        return INSTANCE;
    }

    public synchronized void clear() {
        this.plugins.clear();
        this.serviceToPlugins.clear();
    }

    public synchronized void register(Plugin plugin) {
        this.plugins.add(plugin);
        for (Class<? extends Provider> service : plugin.getSupportedServices()) {
            this.serviceToPlugins.put(service, plugin);
            if (!logger.isInfoEnabled()) continue;
            logger.info(LogMessages.format("ICUB0001", plugin, service));
        }
    }

    public <S extends Provider> S getProvider(Class<S> service) {
        Plugin plugin = this.serviceToPlugins.get(service);
        if (plugin == null) {
            throw new IllegalArgumentException(LogMessages.format("ECUB0054", service));
        }
        Provider provider = (Provider)service.cast(plugin.getProvider(service));
        if (provider == null) {
            throw new IllegalStateException(LogMessages.format("ECUB0053", plugin, service));
        }
        return (S)provider;
    }

    public Set<Plugin> getPlugins() {
        return this.plugins;
    }

    public <T extends Plugin> T getPlugin(Class<T> pluginType) {
        for (Plugin plugin : this.plugins) {
            if (!plugin.getClass().equals(pluginType)) continue;
            return (T)((Plugin)pluginType.cast(plugin));
        }
        return null;
    }
}

