/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.servlet.RequestScoped;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.seasar.cubby.action.ActionContext;
import org.seasar.cubby.action.ActionContextProxy;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.action.ActionErrorsProxy;
import org.seasar.cubby.action.FlashMap;
import org.seasar.cubby.action.FlashMapProxy;
import org.seasar.cubby.controller.FormatPattern;
import org.seasar.cubby.controller.MessagesBehaviour;
import org.seasar.cubby.controller.RequestParser;
import org.seasar.cubby.controller.impl.DefaultFormatPattern;
import org.seasar.cubby.controller.impl.DefaultMessagesBehaviour;
import org.seasar.cubby.controller.impl.DefaultRequestParser;
import org.seasar.cubby.controller.impl.MultipartRequestParser;
import org.seasar.cubby.converter.Converter;
import org.seasar.cubby.converter.impl.BigDecimalConverter;
import org.seasar.cubby.converter.impl.BigIntegerConverter;
import org.seasar.cubby.converter.impl.BooleanConverter;
import org.seasar.cubby.converter.impl.ByteArrayFileItemConverter;
import org.seasar.cubby.converter.impl.ByteConverter;
import org.seasar.cubby.converter.impl.CharacterConverter;
import org.seasar.cubby.converter.impl.DateConverter;
import org.seasar.cubby.converter.impl.DoubleConverter;
import org.seasar.cubby.converter.impl.EnumConverter;
import org.seasar.cubby.converter.impl.FloatConverter;
import org.seasar.cubby.converter.impl.InputStreamFileItemConverter;
import org.seasar.cubby.converter.impl.IntegerConverter;
import org.seasar.cubby.converter.impl.LongConverter;
import org.seasar.cubby.converter.impl.ShortConverter;
import org.seasar.cubby.converter.impl.SqlDateConverter;
import org.seasar.cubby.converter.impl.SqlTimeConverter;
import org.seasar.cubby.converter.impl.SqlTimestampConverter;
import org.seasar.cubby.plugins.guice.spi.GuiceContainerProvider;
import org.seasar.cubby.plugins.guice.spi.GuiceConverterProvider;
import org.seasar.cubby.plugins.guice.spi.GuicePathResolverProvider;
import org.seasar.cubby.plugins.guice.spi.GuiceRequestParserProvider;
import org.seasar.cubby.routing.PathResolver;
import org.seasar.cubby.routing.PathTemplateParser;
import org.seasar.cubby.routing.impl.PathResolverImpl;
import org.seasar.cubby.routing.impl.PathTemplateParserImpl;
import org.seasar.cubby.spi.BeanDescProvider;
import org.seasar.cubby.spi.ContainerProvider;
import org.seasar.cubby.spi.ConverterProvider;
import org.seasar.cubby.spi.PathResolverProvider;
import org.seasar.cubby.spi.RequestParserProvider;
import org.seasar.cubby.spi.beans.impl.DefaultBeanDescProvider;
import org.seasar.cubby.util.ActionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubbyModule
extends AbstractModule {
    private final Set<Class<?>> actionClasses = new LinkedHashSet();
    private final Set<Key<? extends Converter>> converterKeys = new LinkedHashSet<Key<? extends Converter>>();
    private final Set<Key<? extends RequestParser>> requestParserKeys = new LinkedHashSet<Key<? extends RequestParser>>();

    public void configure() {
        this.configureTypeListeners();
        this.configureProviders();
        this.configureComponents();
        this.configureDefaultRequestParsers();
        this.configureDefaultConverters();
    }

    private void configureTypeListeners() {
        this.bindListener((Matcher)new AbstractMatcher<TypeLiteral<?>>(){

            public boolean matches(TypeLiteral<?> typeLiteral) {
                boolean matches = ActionUtils.isActionClass((Class)typeLiteral.getRawType());
                return matches;
            }
        }, new TypeListener(){

            public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
                Class actionClass = typeLiteral.getRawType();
                CubbyModule.this.actionClasses.add(actionClass);
            }
        });
        this.bindListener((Matcher)new AbstractMatcher<TypeLiteral<?>>(){

            public boolean matches(TypeLiteral<?> typeLiteral) {
                boolean matches = Converter.class.isAssignableFrom(typeLiteral.getRawType());
                return matches;
            }
        }, new TypeListener(){

            public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
                Key key = CubbyModule.key(typeLiteral);
                CubbyModule.this.converterKeys.add(key);
            }
        });
        this.bindListener((Matcher)new AbstractMatcher<TypeLiteral<?>>(){

            public boolean matches(TypeLiteral<?> typeLiteral) {
                boolean matches = RequestParser.class.isAssignableFrom(typeLiteral.getRawType());
                return matches;
            }
        }, new TypeListener(){

            public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
                Key key = CubbyModule.key(typeLiteral);
                CubbyModule.this.requestParserKeys.add(key);
            }
        });
    }

    private void configureProviders() {
        this.bind(ContainerProvider.class).to(GuiceContainerProvider.class).asEagerSingleton();
        this.bind(BeanDescProvider.class).to(DefaultBeanDescProvider.class).asEagerSingleton();
        this.bind(RequestParserProvider.class).to(GuiceRequestParserProvider.class).asEagerSingleton();
        this.bind(ConverterProvider.class).to(GuiceConverterProvider.class).asEagerSingleton();
        this.bind(PathResolverProvider.class).to(GuicePathResolverProvider.class).asEagerSingleton();
    }

    private void configureComponents() {
        this.bind(MessagesBehaviour.class).to(DefaultMessagesBehaviour.class).asEagerSingleton();
        this.bind(FormatPattern.class).to(DefaultFormatPattern.class).asEagerSingleton();
    }

    protected void configureDefaultRequestParsers() {
        this.bind(MultipartRequestParser.class).asEagerSingleton();
        this.bind(DefaultRequestParser.class).asEagerSingleton();
    }

    protected void configureDefaultConverters() {
        this.bind(BigDecimalConverter.class).asEagerSingleton();
        this.bind(BigIntegerConverter.class).asEagerSingleton();
        this.bind(BooleanConverter.class).asEagerSingleton();
        this.bind(ByteArrayFileItemConverter.class).asEagerSingleton();
        this.bind(ByteConverter.class).asEagerSingleton();
        this.bind(CharacterConverter.class).asEagerSingleton();
        this.bind(DateConverter.class).asEagerSingleton();
        this.bind(DoubleConverter.class).asEagerSingleton();
        this.bind(EnumConverter.class).asEagerSingleton();
        this.bind(FloatConverter.class).asEagerSingleton();
        this.bind(InputStreamFileItemConverter.class).asEagerSingleton();
        this.bind(IntegerConverter.class).asEagerSingleton();
        this.bind(LongConverter.class).asEagerSingleton();
        this.bind(ShortConverter.class).asEagerSingleton();
        this.bind(SqlDateConverter.class).asEagerSingleton();
        this.bind(SqlTimeConverter.class).asEagerSingleton();
        this.bind(SqlTimestampConverter.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    Collection<RequestParser> provideRequestParsers(Injector injector) {
        LinkedHashSet<RequestParser> requestParsers = new LinkedHashSet<RequestParser>();
        for (Key<? extends RequestParser> key : this.requestParserKeys) {
            RequestParser requestParser = (RequestParser)injector.getInstance(key);
            requestParsers.add(requestParser);
        }
        return Collections.unmodifiableCollection(requestParsers);
    }

    @Provides
    @Singleton
    Collection<Converter> provideConverters(Injector injector) {
        HashSet<Converter> converters = new HashSet<Converter>();
        for (Key<? extends Converter> key : this.converterKeys) {
            Converter converter = (Converter)injector.getInstance(key);
            converters.add(converter);
        }
        return Collections.unmodifiableCollection(converters);
    }

    @Provides
    @Singleton
    PathTemplateParser providePathTemplateParser() {
        PathTemplateParserImpl pathTemplateParser = new PathTemplateParserImpl();
        return pathTemplateParser;
    }

    @Provides
    @Singleton
    PathResolver providePathResolver(PathTemplateParser pathTemplateParser) {
        PathResolverImpl pathResolver = new PathResolverImpl(pathTemplateParser);
        for (Class<?> actionClass : this.actionClasses) {
            pathResolver.add(actionClass);
        }
        return pathResolver;
    }

    @Provides
    @RequestScoped
    ActionErrors provideActionErrors(HttpServletRequest request) {
        ActionErrorsProxy actionErrors = new ActionErrorsProxy((ServletRequest)request);
        return actionErrors;
    }

    @Provides
    @RequestScoped
    FlashMap provideFlashMap(HttpServletRequest request) {
        FlashMapProxy flashMap = new FlashMapProxy((ServletRequest)request);
        return flashMap;
    }

    @Provides
    @RequestScoped
    ActionContext provideActionContext(HttpServletRequest request) {
        ActionContextProxy actionContext = new ActionContextProxy((ServletRequest)request);
        return actionContext;
    }

    private static <T> Key<T> key(TypeLiteral<?> typeLiteral) {
        Key key = Key.get(typeLiteral);
        return key;
    }
}

