/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator;

import java.lang.reflect.Method;
import org.seasar.cubby.action.Validation;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.spi.beans.Attribute;
import org.seasar.cubby.spi.beans.BeanDesc;
import org.seasar.cubby.spi.beans.BeanDescFactory;
import org.seasar.cubby.validator.ValidationRules;

public class ValidationUtils {
    public static Validation getValidation(Method method) {
        return method.getAnnotation(Validation.class);
    }

    public static ValidationRules getValidationRules(Object action, String attributeName) {
        Attribute attribute;
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(action.getClass());
        if (beanDesc.hasPropertyAttribute(attributeName)) {
            attribute = beanDesc.getPropertyAttribute(attributeName);
        } else if (beanDesc.hasFieldAttribute(attributeName)) {
            attribute = beanDesc.getFieldAttribute(attributeName);
        } else {
            throw new IllegalStateException(LogMessages.format("ECUB0113", action, attributeName));
        }
        if (!ValidationRules.class.isAssignableFrom(attribute.getType())) {
            throw new IllegalStateException(LogMessages.format("ECUB0114", action, attributeName, ValidationRules.class.getName()));
        }
        ValidationRules rules = (ValidationRules)attribute.getValue(action);
        return rules;
    }
}

