/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.routing.impl;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.cubby.action.RequestMethod;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.internal.util.MetaUtils;
import org.seasar.cubby.internal.util.QueryStringBuilder;
import org.seasar.cubby.internal.util.URLBodyEncoder;
import org.seasar.cubby.routing.PathInfo;
import org.seasar.cubby.routing.PathResolver;
import org.seasar.cubby.routing.PathTemplateParser;
import org.seasar.cubby.routing.Routing;
import org.seasar.cubby.routing.RoutingException;
import org.seasar.cubby.routing.impl.RoutingImpl;
import org.seasar.cubby.util.ActionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathResolverImpl
implements PathResolver {
    private static final Logger logger = LoggerFactory.getLogger(PathResolverImpl.class);
    private final Map<RoutingKey, Routing> routings = new TreeMap<RoutingKey, Routing>();
    private final PathTemplateParser pathTemplateParser;

    public PathResolverImpl(PathTemplateParser pathTemplateParser) {
        this.pathTemplateParser = pathTemplateParser;
    }

    @Override
    public Collection<Routing> getRoutings() {
        return this.routings.values();
    }

    @Override
    public void add(Class<?> actionClass) {
        for (Method method : actionClass.getMethods()) {
            RequestMethod[] acceptableRequestMethods;
            if (!ActionUtils.isActionMethod(method)) continue;
            String actionPath = MetaUtils.getActionPath(actionClass, method);
            for (RequestMethod requestMethod : acceptableRequestMethods = MetaUtils.getAcceptableRequestMethods(actionClass, method)) {
                String onSubmit = MetaUtils.getOnSubmit(method);
                int priority = MetaUtils.getPriority(method);
                this.add(actionPath, actionClass, method, requestMethod, onSubmit, priority);
            }
        }
    }

    @Override
    public void addAll(Collection<Class<?>> actionClasses) {
        for (Class<?> actionClass : actionClasses) {
            this.add(actionClass);
        }
    }

    @Override
    public void clear() {
        this.routings.clear();
    }

    @Override
    public void add(String actionPath, Class<?> actionClass, String methodName, RequestMethod requestMethod, String onSubmit, int priority) {
        try {
            Method method = actionClass.getMethod(methodName, new Class[0]);
            this.add(actionPath, actionClass, method, requestMethod, onSubmit, priority);
        }
        catch (NoSuchMethodException e) {
            throw new RoutingException(e);
        }
    }

    private void add(String actionPath, Class<?> actionClass, Method method, RequestMethod requestMethod, String onSubmit, int priority) {
        if (!ActionUtils.isActionMethod(method)) {
            throw new RoutingException(LogMessages.format("ECUB0003", method));
        }
        final ArrayList<String> uriParameterNames = new ArrayList<String>();
        String uriRegex = this.pathTemplateParser.parse(actionPath, new PathTemplateParser.Handler(){

            public String handle(String name, String regex) {
                uriParameterNames.add(name);
                return PathResolverImpl.regexGroup(regex);
            }
        });
        Pattern pattern = Pattern.compile("^" + uriRegex + "$");
        RoutingImpl routing = new RoutingImpl(actionClass, method, actionPath, uriParameterNames, pattern, requestMethod, onSubmit, priority);
        RoutingKey key = new RoutingKey(routing);
        if (logger.isDebugEnabled()) {
            logger.debug(LogMessages.format("DCUB0007", routing));
        }
        if (this.routings.containsKey(key)) {
            Routing duplication = this.routings.get(key);
            throw new RoutingException(LogMessages.format("ECUB0001", routing, duplication));
        }
        this.routings.put(key, routing);
    }

    @Override
    public PathInfo getPathInfo(String path, String requestMethod, String characterEncoding) {
        Iterator<Routing> iterator = this.getRoutings().iterator();
        while (iterator.hasNext()) {
            Routing routing = iterator.next();
            Matcher matcher = routing.getPattern().matcher(path);
            if (!matcher.find() || !routing.isAcceptable(requestMethod)) continue;
            HashMap<String, Routing> onSubmitRoutings = new HashMap<String, Routing>();
            onSubmitRoutings.put(routing.getOnSubmit(), routing);
            while (iterator.hasNext()) {
                Routing anotherRouting = iterator.next();
                if (!routing.getPattern().pattern().equals(anotherRouting.getPattern().pattern()) || !routing.getRequestMethod().equals((Object)anotherRouting.getRequestMethod())) continue;
                onSubmitRoutings.put(anotherRouting.getOnSubmit(), anotherRouting);
            }
            HashMap<String, String[]> uriParameters = new HashMap<String, String[]>();
            for (int i = 0; i < matcher.groupCount(); ++i) {
                String name = routing.getUriParameterNames().get(i);
                String value = matcher.group(i + 1);
                uriParameters.put(name, new String[]{value});
            }
            ResolvedPathInfo pathInfo = new ResolvedPathInfo(uriParameters, onSubmitRoutings);
            return pathInfo;
        }
        return null;
    }

    private static String regexGroup(String regex) {
        return "(" + regex + ")";
    }

    @Override
    public String reverseLookup(Class<?> actionClass, String methodName, Map<String, String[]> parameters, final String characterEncoding) {
        Collection<Routing> routings = this.getRoutings();
        Routing routing = PathResolverImpl.findRouting(routings, actionClass, methodName);
        final String actionPath = routing.getActionPath();
        final HashMap<String, String[]> copyOfParameters = new HashMap<String, String[]>(parameters);
        StringBuilder path = new StringBuilder(100);
        path.append(this.pathTemplateParser.parse(actionPath, new PathTemplateParser.Handler(){

            public String handle(String name, String regex) {
                if (!copyOfParameters.containsKey(name)) {
                    throw new RoutingException(LogMessages.format("ECUB0104", actionPath, name));
                }
                String value = ((String[])copyOfParameters.remove(name))[0];
                if (!value.matches(regex)) {
                    throw new RoutingException(LogMessages.format("ECUB0105", actionPath, name, value, regex));
                }
                return PathResolverImpl.encode(value, characterEncoding);
            }
        }));
        if (!copyOfParameters.isEmpty()) {
            QueryStringBuilder builder = new QueryStringBuilder();
            if (characterEncoding != null) {
                builder.setEncode(characterEncoding);
            }
            for (Map.Entry entry : copyOfParameters.entrySet()) {
                for (String value : (String[])entry.getValue()) {
                    builder.addParam((String)entry.getKey(), value);
                }
            }
            path.append('?');
            path.append(builder.toString());
        }
        return path.toString();
    }

    private static Routing findRouting(Collection<Routing> routings, Class<?> actionClass, String methodName) {
        for (Routing routing : routings) {
            if (!actionClass.getCanonicalName().equals(routing.getActionClass().getCanonicalName()) || !methodName.equals(routing.getActionMethod().getName())) continue;
            return routing;
        }
        throw new RoutingException(LogMessages.format("ECUB0103", actionClass, methodName));
    }

    private static String encode(String str, String characterEncoding) {
        if (characterEncoding == null) {
            return str;
        }
        try {
            return URLBodyEncoder.encode(str, characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RoutingException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResolvedPathInfo
    implements PathInfo {
        private final Map<String, String[]> uriParameters;
        private final Map<String, Routing> routings;

        public ResolvedPathInfo(Map<String, String[]> uriParameters, Map<String, Routing> routings) {
            this.uriParameters = uriParameters;
            this.routings = routings;
        }

        @Override
        public Map<String, String[]> getURIParameters() {
            return this.uriParameters;
        }

        @Override
        public Routing dispatch(Map<String, Object[]> parameterMap) {
            for (Map.Entry<String, Routing> entry : this.routings.entrySet()) {
                if (!parameterMap.containsKey(entry.getKey())) continue;
                return entry.getValue();
            }
            return this.routings.get(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RoutingKey
    implements Comparable<RoutingKey> {
        private final int priority;
        private final List<String> uriParameterNames;
        private final Pattern pattern;
        private final RequestMethod requestMethod;
        private final String onSubmit;

        public RoutingKey(Routing routing) {
            this.priority = routing.getPriority();
            this.uriParameterNames = routing.getUriParameterNames();
            this.pattern = routing.getPattern();
            this.requestMethod = routing.getRequestMethod();
            this.onSubmit = routing.getOnSubmit();
        }

        @Override
        public int compareTo(RoutingKey another) {
            int compare = this.priority - another.priority;
            if (compare != 0) {
                return compare;
            }
            compare = this.uriParameterNames.size() - another.uriParameterNames.size();
            if (compare != 0) {
                return compare;
            }
            compare = this.pattern.pattern().compareTo(another.pattern.pattern());
            if (compare != 0) {
                return compare;
            }
            compare = this.requestMethod.compareTo(another.requestMethod);
            if (compare != 0) {
                return compare;
            }
            compare = this.onSubmit == another.onSubmit ? 0 : (this.onSubmit == null ? -1 : (another.onSubmit == null ? 1 : this.onSubmit.compareTo(another.onSubmit)));
            return compare;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.onSubmit == null ? 0 : this.onSubmit.hashCode());
            result = 31 * result + (this.pattern.pattern() == null ? 0 : this.pattern.pattern().hashCode());
            result = 31 * result + this.priority;
            result = 31 * result + (this.requestMethod == null ? 0 : this.requestMethod.hashCode());
            result = 31 * result + (this.uriParameterNames == null ? 0 : ((Object)this.uriParameterNames).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RoutingKey other = (RoutingKey)obj;
            if (this.onSubmit == null ? other.onSubmit != null : !this.onSubmit.equals(other.onSubmit)) {
                return false;
            }
            if (this.pattern == null ? other.pattern != null : !this.pattern.pattern().equals(other.pattern.pattern())) {
                return false;
            }
            if (this.priority != other.priority) {
                return false;
            }
            if (this.requestMethod == null ? other.requestMethod != null : !this.requestMethod.equals((Object)other.requestMethod)) {
                return false;
            }
            return !(this.uriParameterNames == null ? other.uriParameterNames != null : !((Object)this.uriParameterNames).equals(other.uriParameterNames));
        }
    }
}

