/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.guice.spi;

import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import org.seasar.cubby.spi.ContainerProvider;
import org.seasar.cubby.spi.container.Container;
import org.seasar.cubby.spi.container.LookupException;

public class GuiceContainerProvider
implements ContainerProvider {
    private final Container container;

    @Inject
    public GuiceContainerProvider(Injector injector) {
        this.container = new GuiceContainerImpl(injector);
    }

    public Container getContainer() {
        return this.container;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GuiceContainerImpl
    implements Container {
        private final Injector injector;

        public GuiceContainerImpl(Injector injector) {
            this.injector = injector;
        }

        public <T> T lookup(Class<T> type) throws LookupException {
            try {
                return (T)this.injector.getInstance(type);
            }
            catch (ConfigurationException e) {
                throw new LookupException((Throwable)e);
            }
        }
    }
}

