/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.s2;

import javax.el.ELResolver;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.seasar.cubby.plugin.AbstractPlugin;
import org.seasar.cubby.spi.BeanDescProvider;
import org.seasar.cubby.spi.ContainerProvider;
import org.seasar.cubby.spi.ConverterProvider;
import org.seasar.cubby.spi.PathResolverProvider;
import org.seasar.cubby.spi.Provider;
import org.seasar.cubby.spi.RequestParserProvider;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2ContainerPlugin
extends AbstractPlugin {
    private static final Logger logger;
    private ServletContext servletContext;

    public S2ContainerPlugin() {
        this.support(BeanDescProvider.class);
        this.support(ContainerProvider.class);
        this.support(RequestParserProvider.class);
        this.support(PathResolverProvider.class);
        this.support(ConverterProvider.class);
    }

    public void initialize(ServletContext servletContext) throws Exception {
        super.initialize(servletContext);
        this.servletContext = servletContext;
    }

    public void ready() {
        JspFactory jspFactory = JspFactory.getDefaultFactory();
        if (jspFactory != null) {
            ELResolver[] elResolvers;
            JspApplicationContext jspApplicationContext = jspFactory.getJspApplicationContext(this.servletContext);
            S2Container container = SingletonS2ContainerFactory.getContainer();
            for (ELResolver elResolver : elResolvers = (ELResolver[])container.findAllComponents(ELResolver.class)) {
                jspApplicationContext.addELResolver(elResolver);
                logger.log("ICUB0001", new Object[]{elResolver});
            }
        }
    }

    public <S extends Provider> S getProvider(Class<S> service) {
        if (this.isSupport(service)) {
            S2Container container = SingletonS2ContainerFactory.getContainer();
            return (S)((Provider)service.cast(container.getComponent(service)));
        }
        return null;
    }

    static {
        block2: {
            logger = Logger.getLogger(S2ContainerPlugin.class);
            try {
                Class.forName("org.apache.jasper.compiler.JspRuntimeContext");
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)e.getMessage());
            }
        }
    }
}

